/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.config.BeforeAfterActionMetaData;
import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.extensions.PluginId;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IntentionActionMetaData
extends BeforeAfterActionMetaData {
    @NotNull
    private final IntentionAction myAction;
    public final String @NotNull [] myCategory;
    private String myDirName;
    @NonNls
    private static final String INTENTION_DESCRIPTION_FOLDER = "intentionDescriptions";

    public IntentionActionMetaData(@NotNull IntentionAction action2, @Nullable ClassLoader loader, String @NotNull [] category, @NotNull String descriptionDirectoryName) {
        super(loader, descriptionDirectoryName);
        this.myAction = action2;
        this.myCategory = category;
    }

    public String toString() {
        return this.getFamily();
    }

    @Nullable
    public PluginId getPluginId() {
        if (this.myLoader instanceof PluginClassLoader) {
            return ((PluginClassLoader)((Object)this.myLoader)).getPluginId();
        }
        return null;
    }

    @NotNull
    public String getFamily() {
        return this.myAction.getFamilyName();
    }

    @NotNull
    public IntentionAction getAction() {
        return this.myAction;
    }

    @Override
    protected String getResourceLocation(String resourceName) {
        if (this.myDirName == null) {
            String dirName = this.myDescriptionDirectoryName;
            if (this.myLoader != null && this.myLoader.getResource(IntentionActionMetaData.getResourceLocationStatic(dirName, resourceName)) == null && this.myLoader.getResource(IntentionActionMetaData.getResourceLocationStatic(dirName = this.getFamily(), resourceName)) == null) {
                PluginId pluginId = this.getPluginId();
                String errorMessage = "Intention Description Dir URL is null: " + this.getFamily() + "; " + this.myDescriptionDirectoryName + "; while looking for " + resourceName;
                if (pluginId != null) {
                    throw new PluginException(errorMessage, pluginId);
                }
                throw new RuntimeException(errorMessage);
            }
            this.myDirName = dirName;
        }
        return IntentionActionMetaData.getResourceLocationStatic(this.myDirName, resourceName);
    }

    @NotNull
    private static String getResourceLocationStatic(String dirName, String resourceName) {
        return "intentionDescriptions/" + dirName + "/" + resourceName;
    }

    public String getDescriptionDirectoryName() {
        return this.myDescriptionDirectoryName;
    }
}

