/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.BeforeAfterMetaData;
import com.intellij.codeInsight.intention.impl.config.PlainTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.ResourceTextDescriptor;
import com.intellij.codeInsight.intention.impl.config.TextDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.ExactFileNameMatcher;
import com.intellij.openapi.fileTypes.ExtensionFileNameMatcher;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BeforeAfterActionMetaData
implements BeforeAfterMetaData {
    private static final Logger LOG = Logger.getInstance(BeforeAfterActionMetaData.class);
    protected static final TextDescriptor[] EMPTY_EXAMPLE = new TextDescriptor[0];
    protected static final TextDescriptor EMPTY_DESCRIPTION = new PlainTextDescriptor("", "");
    @NonNls
    protected static final String DESCRIPTION_FILE_NAME = "description.html";
    @NonNls
    static final String EXAMPLE_USAGE_URL_SUFFIX = ".template";
    @NonNls
    private static final String BEFORE_TEMPLATE_PREFIX = "before";
    @NonNls
    private static final String AFTER_TEMPLATE_PREFIX = "after";
    protected final ClassLoader myLoader;
    protected final String myDescriptionDirectoryName;
    private TextDescriptor[] myExampleUsagesBefore;
    private TextDescriptor[] myExampleUsagesAfter;
    protected TextDescriptor myDescription;

    public BeforeAfterActionMetaData(@Nullable ClassLoader loader, @NotNull String descriptionDirectoryName) {
        this.myLoader = loader;
        this.myDescriptionDirectoryName = descriptionDirectoryName;
    }

    public BeforeAfterActionMetaData(@NotNull TextDescriptor description, TextDescriptor @NotNull [] exampleUsagesBefore, TextDescriptor @NotNull [] exampleUsagesAfter) {
        this.myLoader = null;
        this.myDescriptionDirectoryName = null;
        this.myExampleUsagesBefore = exampleUsagesBefore;
        this.myExampleUsagesAfter = exampleUsagesAfter;
        this.myDescription = description;
    }

    private TextDescriptor @NotNull [] retrieveURLs(@NotNull String prefix, @NotNull String suffix) {
        FileType[] fileTypes;
        LinkedHashSet<ResourceTextDescriptor> urls = new LinkedHashSet<ResourceTextDescriptor>();
        for (FileType fileType : fileTypes = FileTypeManager.getInstance().getRegisteredFileTypes()) {
            List matchers = FileTypeManager.getInstance().getAssociations(fileType);
            for (FileNameMatcher matcher : matchers) {
                String resourcePath;
                URL resource;
                if (matcher instanceof ExactFileNameMatcher) {
                    ExactFileNameMatcher exactFileNameMatcher = (ExactFileNameMatcher)matcher;
                    String fileName = StringUtil.trimStart((String)exactFileNameMatcher.getFileName(), (String)".");
                    String resourcePath2 = this.getResourceLocation(prefix + "." + fileName + suffix);
                    URL resource2 = this.myLoader.getResource(resourcePath2);
                    if (resource2 == null) continue;
                    urls.add(new ResourceTextDescriptor(this.myLoader, resourcePath2));
                    continue;
                }
                if (!(matcher instanceof ExtensionFileNameMatcher)) continue;
                ExtensionFileNameMatcher extensionFileNameMatcher = (ExtensionFileNameMatcher)matcher;
                String extension = extensionFileNameMatcher.getExtension();
                int i2 = 0;
                while ((resource = this.myLoader.getResource(resourcePath = this.getResourceLocation(prefix + "." + extension + (i2 == 0 ? "" : Integer.toString(i2)) + suffix))) != null) {
                    urls.add(new ResourceTextDescriptor(this.myLoader, resourcePath));
                    ++i2;
                }
            }
        }
        if (urls.isEmpty()) {
            String[] children2;
            URL descriptionUrl = this.myLoader.getResource(this.getResourceLocation(DESCRIPTION_FILE_NAME));
            String url = descriptionUrl.toExternalForm();
            URL descriptionDirectory = null;
            Exception cause = null;
            try {
                descriptionDirectory = new URL(url.substring(0, url.lastIndexOf(47)));
                URI uri = descriptionDirectory.toURI();
                children2 = uri.isOpaque() ? null : (String[])ObjectUtils.notNull((Object)new File(uri).list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY);
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
                cause = e;
                children2 = null;
            }
            LOG.error("URLs not found for available file types and prefix: '" + prefix + "', suffix: '" + suffix + "'; in directory: '" + descriptionDirectory + "'" + (children2 == null ? "" : "; directory contents: " + Arrays.asList(children2)), (Throwable)cause);
            return EMPTY_EXAMPLE;
        }
        return urls.toArray(new TextDescriptor[0]);
    }

    @Override
    public TextDescriptor @NotNull [] getExampleUsagesBefore() {
        if (this.myExampleUsagesBefore == null) {
            this.myExampleUsagesBefore = this.retrieveURLs(BEFORE_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
        }
        return this.myExampleUsagesBefore;
    }

    @Override
    public TextDescriptor @NotNull [] getExampleUsagesAfter() {
        if (this.myExampleUsagesAfter == null) {
            this.myExampleUsagesAfter = this.retrieveURLs(AFTER_TEMPLATE_PREFIX, EXAMPLE_USAGE_URL_SUFFIX);
        }
        return this.myExampleUsagesAfter;
    }

    @Override
    @NotNull
    public TextDescriptor getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new ResourceTextDescriptor(this.myLoader, this.getResourceLocation(DESCRIPTION_FILE_NAME));
        }
        return this.myDescription;
    }

    protected abstract String getResourceLocation(String var1);
}

