/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints.presentation;

import com.intellij.codeInsight.hints.presentation.InlayTextMetrics;
import com.intellij.openapi.editor.impl.EditorImpl;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/codeInsight/hints/presentation/InlayTextMetricsStorage;", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "normalTextMetrics", "Lcom/intellij/codeInsight/hints/presentation/InlayTextMetrics;", "normalTextSize", "", "getNormalTextSize", "()I", "smallTextMetrics", "smallTextSize", "getSmallTextSize", "getFontMetrics", "small", "", "intellij.platform.lang.impl"})
public final class InlayTextMetricsStorage {
    private InlayTextMetrics smallTextMetrics;
    private InlayTextMetrics normalTextMetrics;
    @NotNull
    private final EditorImpl editor;

    public final int getSmallTextSize() {
        int n = 1;
        int n2 = this.editor.getColorsScheme().getEditorFontSize() - 1;
        boolean bl = false;
        return Math.max(n, n2);
    }

    public final int getNormalTextSize() {
        return this.editor.getColorsScheme().getEditorFontSize();
    }

    @NotNull
    public final InlayTextMetrics getFontMetrics(boolean small) {
        InlayTextMetrics metrics = null;
        if (small) {
            metrics = this.smallTextMetrics;
            int fontSize = this.getSmallTextSize();
            if (metrics == null || !metrics.isActual(this.getSmallTextSize())) {
                this.smallTextMetrics = metrics = InlayTextMetrics.Companion.create(this.editor, fontSize);
            }
        } else {
            metrics = this.normalTextMetrics;
            int fontSize = this.getNormalTextSize();
            if (metrics == null || !metrics.isActual(this.getNormalTextSize())) {
                this.normalTextMetrics = metrics = InlayTextMetrics.Companion.create(this.editor, fontSize);
            }
        }
        return metrics;
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public InlayTextMetricsStorage(@NotNull EditorImpl editor) {
        this.editor = editor;
    }
}

