/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.HintInfoFilter;
import com.intellij.codeInsight.hints.HintUtilsKt;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.MethodInfoBlacklistFilter;
import com.intellij.codeInsight.hints.ParameterHintsPassFactory;
import com.intellij.codeInsight.hints.ParameterHintsUpdater;
import com.intellij.lang.Language;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorScrollingPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class ParameterHintsPass
extends EditorBoundHighlightingPass {
    private final TIntObjectHashMap<List<HintData>> myHints = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> myShowOnlyIfExistedBeforeHints = new TIntObjectHashMap();
    private final PsiElement myRootElement;
    private final HintInfoFilter myHintInfoFilter;
    private final boolean myForceImmediateUpdate;

    public ParameterHintsPass(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull HintInfoFilter hintsFilter, boolean forceImmediateUpdate) {
        super(editor, element2.getContainingFile(), true);
        this.myRootElement = element2;
        this.myHintInfoFilter = hintsFilter;
        this.myForceImmediateUpdate = forceImmediateUpdate;
    }

    public static void syncUpdate(@NotNull PsiElement element2, @NotNull Editor editor) {
        MethodInfoBlacklistFilter filter2 = MethodInfoBlacklistFilter.forLanguage(element2.getLanguage());
        ParameterHintsPass pass = new ParameterHintsPass(element2, editor, filter2, true);
        try {
            pass.doCollectInformation(new ProgressIndicatorBase());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        pass.applyInformationToEditor();
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        this.myHints.clear();
        Language language = this.myFile.getLanguage();
        InlayParameterHintsProvider provider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
        if (provider == null || !provider.canShowHintsWhenDisabled() && !ParameterHintsPass.isEnabled(language) || DiffUtil.isDiffEditor(this.myEditor)) {
            return;
        }
        if (!HighlightingLevelManager.getInstance(this.myFile.getProject()).shouldHighlight((PsiElement)this.myFile)) {
            return;
        }
        provider.createTraversal(this.myRootElement).forEach(element2 -> this.process((PsiElement)element2, provider));
    }

    private static boolean isEnabled(Language language) {
        return HintUtilsKt.isParameterHintsEnabledForLanguage(language);
    }

    private void process(@NotNull PsiElement element2, @NotNull InlayParameterHintsProvider provider) {
        List hints2 = provider.getParameterHints(element2, this.myFile);
        if (hints2.isEmpty()) {
            return;
        }
        HintInfo info = provider.getHintInfo(element2, this.myFile);
        boolean showHints = info == null || info instanceof HintInfo.OptionInfo || this.myHintInfoFilter.showHint(info);
        Stream<Object> inlays = hints2.stream();
        if (!showHints) {
            inlays = inlays.filter(inlayInfo -> !inlayInfo.isFilterByBlacklist());
        }
        inlays.forEach(hint -> {
            int offset = hint.getOffset();
            if (!this.canShowHintsAtOffset(offset)) {
                return;
            }
            String presentation2 = provider.getInlayPresentation(hint.getText());
            if (hint.isShowOnlyIfExistedBefore()) {
                this.myShowOnlyIfExistedBeforeHints.put(offset, (Object)presentation2);
            } else {
                ArrayList<HintData> hintList = (ArrayList<HintData>)this.myHints.get(offset);
                if (hintList == null) {
                    hintList = new ArrayList<HintData>();
                    this.myHints.put(offset, hintList);
                }
                HintWidthAdjustment widthAdjustment = ParameterHintsPass.convertHintPresentation(hint.getWidthAdjustment(), provider);
                hintList.add(new HintData(presentation2, hint.getRelatesToPrecedingText(), widthAdjustment));
            }
        });
    }

    private static HintWidthAdjustment convertHintPresentation(HintWidthAdjustment widthAdjustment, InlayParameterHintsProvider provider) {
        String adjusterHintPresentation;
        String hintText;
        if (widthAdjustment != null && (hintText = widthAdjustment.getHintTextToMatch()) != null && !hintText.equals(adjusterHintPresentation = provider.getInlayPresentation(hintText))) {
            widthAdjustment = new HintWidthAdjustment(widthAdjustment.getEditorTextToMatch(), adjusterHintPresentation, widthAdjustment.getAdjustmentPosition());
        }
        return widthAdjustment;
    }

    @Override
    public void doApplyInformationToEditor() {
        EditorScrollingPositionKeeper.perform(this.myEditor, false, () -> {
            ParameterHintsPresentationManager manager = ParameterHintsPresentationManager.getInstance();
            List<Inlay> hints2 = this.hintsInRootElementArea(manager);
            ParameterHintsUpdater updater2 = new ParameterHintsUpdater(this.myEditor, hints2, this.myHints, this.myShowOnlyIfExistedBeforeHints, this.myForceImmediateUpdate);
            updater2.update();
        });
        if (ParameterHintsUpdater.hintRemovalDelayed(this.myEditor)) {
            ParameterHintsPassFactory.forceHintsUpdateOnNextPass(this.myEditor);
        } else if (this.myRootElement == this.myFile) {
            ParameterHintsPassFactory.putCurrentPsiModificationStamp(this.myEditor, this.myFile);
        }
    }

    @NotNull
    private List<Inlay> hintsInRootElementArea(ParameterHintsPresentationManager manager) {
        TextRange range2 = this.myRootElement.getTextRange();
        int elementStart = range2.getStartOffset();
        int elementEnd = range2.getEndOffset();
        if (this.myDocument.getTextLength() != range2.getLength()) {
            ++elementStart;
            --elementEnd;
        }
        return manager.getParameterHintsInRange(this.myEditor, elementStart, elementEnd);
    }

    private boolean canShowHintsAtOffset(int offset) {
        TextRange rootRange = this.myRootElement.getTextRange();
        if (!rootRange.containsOffset(offset)) {
            return false;
        }
        if (offset > rootRange.getStartOffset() && offset < rootRange.getEndOffset()) {
            return true;
        }
        return this.myDocument.getTextLength() == rootRange.getLength();
    }

    static class HintData {
        final String presentationText;
        final boolean relatesToPrecedingText;
        final HintWidthAdjustment widthAdjustment;

        HintData(@NotNull String text, boolean relatesToPrecedingText, HintWidthAdjustment widthAdjustment) {
            this.presentationText = text;
            this.relatesToPrecedingText = relatesToPrecedingText;
            this.widthAdjustment = widthAdjustment;
        }
    }
}

