/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.serviceContainer.BaseKeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TooltipLinkHandlerEP
extends BaseKeyedLazyInstance<TooltipLinkHandler> {
    public static final ExtensionPointName<TooltipLinkHandlerEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.codeInsight.linkHandler");
    @Attribute(value="prefix")
    public String prefix;
    @Attribute(value="handlerClass")
    public String handlerClassName;

    @Nullable
    protected String getImplementationClassName() {
        return this.handlerClassName;
    }

    public static boolean handleLink(@NotNull String ref, @NotNull Editor editor) {
        return EP_NAME.computeSafeIfAny(ep2 -> {
            if (ref.startsWith(ep2.prefix)) {
                String refSuffix = ref.substring(ep2.prefix.length());
                return ((TooltipLinkHandler)ep2.getInstance()).handleLink(refSuffix.replaceAll("<br/>", "\n"), editor);
            }
            return null;
        }) == Boolean.TRUE;
    }

    @Nullable
    public static String getDescription(@NotNull String ref, @NotNull Editor editor) {
        return (String)EP_NAME.computeSafeIfAny(ep2 -> {
            if (ref.startsWith(ep2.prefix)) {
                String refSuffix = ref.substring(ep2.prefix.length());
                return ((TooltipLinkHandler)ep2.getInstance()).getDescription(refSuffix, editor);
            }
            return null;
        });
    }

    @NotNull
    public static String getDescriptionTitle(@NotNull String ref, @NotNull Editor editor) {
        return (String)Objects.requireNonNull(EP_NAME.computeSafeIfAny(ep2 -> {
            if (ref.startsWith(ep2.prefix)) {
                String refSuffix = ref.substring(ep2.prefix.length());
                return ((TooltipLinkHandler)ep2.getInstance()).getDescriptionTitle(refSuffix, editor);
            }
            return "Inspection info";
        }));
    }
}

