/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.hint.DeclarationRangeUtil;
import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.lang.LanguageStructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowContainerInfoHandler
implements CodeInsightActionHandler {
    private static final Key<WeakReference<LightweightHint>> MY_LAST_HINT_KEY = Key.create((String)"MY_LAST_HINT_KEY");
    private static final Key<PsiElement> CONTAINER_KEY = Key.create((String)"CONTAINER_KEY");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement container2 = ShowContainerInfoHandler.getProcessedHint(editor);
        StructureViewBuilder builder2 = LanguageStructureViewBuilder.INSTANCE.getStructureViewBuilder(file2);
        if (builder2 instanceof TreeBasedStructureViewBuilder) {
            StructureViewModel model = ((TreeBasedStructureViewBuilder)builder2).createStructureViewModel(editor);
            boolean goOneLevelUp = true;
            try {
                if (container2 == null) {
                    goOneLevelUp = false;
                    Object element2 = model.getCurrentEditorElement();
                    if (element2 instanceof PsiElement) {
                        container2 = (PsiElement)element2;
                    }
                }
            }
            finally {
                Disposer.dispose((Disposable)model);
            }
            while (true) {
                if (container2 != null && DeclarationRangeUtil.getPossibleDeclarationAtRange(container2) == null) {
                    if (!((container2 = container2.getParent()) instanceof PsiFile)) continue;
                    return;
                }
                if (container2 == null || container2 instanceof PsiFile) {
                    return;
                }
                if (goOneLevelUp) {
                    goOneLevelUp = false;
                } else if (!ShowContainerInfoHandler.isDeclarationVisible(container2, editor)) break;
                container2 = container2.getParent();
            }
        }
        if (container2 == null) {
            return;
        }
        TextRange range2 = DeclarationRangeUtil.getPossibleDeclarationAtRange(container2);
        if (range2 == null) {
            return;
        }
        PsiElement _container = container2;
        ApplicationManager.getApplication().invokeLater(() -> {
            LightweightHint hint1 = EditorFragmentComponent.showEditorFragmentHint(editor, range2, true, true);
            if (hint1 != null) {
                hint1.putUserData(CONTAINER_KEY, _container);
                editor.putUserData(MY_LAST_HINT_KEY, new WeakReference<LightweightHint>(hint1));
            }
        });
    }

    @Nullable
    public static PsiElement getProcessedHint(@NotNull Editor editor) {
        WeakReference ref = (WeakReference)editor.getUserData(MY_LAST_HINT_KEY);
        LightweightHint hint = (LightweightHint)SoftReference.dereference((Reference)ref);
        if (hint != null && hint.isVisible()) {
            hint.hide();
            PsiElement container2 = (PsiElement)hint.getUserData(CONTAINER_KEY);
            if (container2 != null && container2.isValid()) {
                return container2;
            }
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static boolean isDeclarationVisible(PsiElement container2, Editor editor) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        TextRange range2 = DeclarationRangeUtil.getPossibleDeclarationAtRange(container2);
        if (range2 == null) {
            return false;
        }
        LogicalPosition pos = editor.offsetToLogicalPosition(range2.getStartOffset());
        Point loc = editor.logicalPositionToXY(pos);
        return loc.y >= viewRect.y;
    }
}

