/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.DocumentFragment;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.HintHint;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DocumentFragmentTooltipRenderer
implements TooltipRenderer {
    private final DocumentFragment myDocumentFragment;

    public DocumentFragmentTooltipRenderer(DocumentFragment documentFragment) {
        this.myDocumentFragment = documentFragment;
    }

    @Override
    public LightweightHint show(@NotNull Editor editor, @NotNull Point p, boolean alignToRight, @NotNull TooltipGroup group, @NotNull HintHint intInfo) {
        JComponent editorComponent = editor.getComponent();
        TextRange range2 = this.myDocumentFragment.getTextRange();
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        Document doc = this.myDocumentFragment.getDocument();
        int endLine = doc.getLineNumber(endOffset);
        int startLine = doc.getLineNumber(startOffset);
        JLayeredPane layeredPane = editorComponent.getRootPane().getLayeredPane();
        VisualPosition visual = editor.offsetToVisualPosition(startOffset);
        p = editor.visualPositionToXY(visual);
        p = SwingUtilities.convertPoint(((EditorEx)editor).getGutterComponentEx(), p, layeredPane);
        p.x -= 3;
        p.y += editor.getLineHeight();
        Point screenPoint = new Point(p);
        SwingUtilities.convertPointToScreen(screenPoint, layeredPane);
        int maxLineCount = (ScreenUtil.getScreenRectangle((Point)screenPoint).height - screenPoint.y) / editor.getLineHeight();
        if (endLine - startLine > maxLineCount) {
            endOffset = doc.getLineEndOffset(Math.max(0, Math.min(startLine + maxLineCount, doc.getLineCount() - 1)));
        }
        if (endOffset < startOffset) {
            return null;
        }
        TextRange textRange = new TextRange(startOffset, endOffset);
        return EditorFragmentComponent.showEditorFragmentHintAt(editor, textRange, p.y, false, false, true, true, true);
    }
}

