/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TemplateLanguageErrorFilter
extends HighlightErrorFilter {
    @NotNull
    private final TokenSet myTemplateExpressionEdgeTokens;
    @NotNull
    private final Class myTemplateFileViewProviderClass;
    private final Set<Language> knownLanguageSet;
    private static final Key<FileViewProvider> TOP_LEVEL_VIEW_PROVIDER = Key.create((String)"TOP_LEVEL_VIEW_PROVIDER");

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionEdgeTokens, @NotNull Class templateFileViewProviderClass) {
        this(templateExpressionEdgeTokens, templateFileViewProviderClass, ArrayUtilRt.EMPTY_STRING_ARRAY);
    }

    protected TemplateLanguageErrorFilter(@NotNull TokenSet templateExpressionEdgeTokens, @NotNull Class templateFileViewProviderClass, String ... knownSubLanguageNames) {
        this.myTemplateExpressionEdgeTokens = TokenSet.create((IElementType[])templateExpressionEdgeTokens.getTypes());
        this.myTemplateFileViewProviderClass = templateFileViewProviderClass;
        ArrayList<String> knownSubLanguageList = new ArrayList<String>(Arrays.asList(knownSubLanguageNames));
        knownSubLanguageList.add("JavaScript");
        knownSubLanguageList.add("CSS");
        this.knownLanguageSet = new HashSet<Language>();
        for (String name : knownSubLanguageList) {
            Language language = Language.findLanguageByID((String)name);
            if (language == null) continue;
            this.knownLanguageSet.add(language);
        }
    }

    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element2) {
        if (this.isKnownSubLanguage(element2.getParent().getLanguage())) {
            TextRange range2;
            FileViewProvider viewProvider = (FileViewProvider)element2.getUserData(TOP_LEVEL_VIEW_PROVIDER);
            if (viewProvider == null) {
                viewProvider = InjectedLanguageManager.getInstance((Project)element2.getProject()).getTopLevelFile((PsiElement)element2).getViewProvider();
                element2.putUserData(TOP_LEVEL_VIEW_PROVIDER, (Object)viewProvider);
            }
            if (!this.isTemplateViewProvider(viewProvider)) {
                return true;
            }
            PsiFile psiFile = element2.getContainingFile();
            if (this.isNearTemplateExpressions(psiFile, (range2 = element2.getTextRange()).getStartOffset(), range2.getEndOffset()) || TemplateLanguageErrorFilter.hasErrorElementsBeforeAndUp((PsiElement)element2) || PsiTreeUtil.findChildOfType((PsiElement)element2, OuterLanguageElement.class) != null) {
                return false;
            }
        }
        return true;
    }

    protected boolean isTemplateViewProvider(FileViewProvider viewProvider) {
        return viewProvider.getClass() == this.myTemplateFileViewProviderClass;
    }

    private static boolean hasErrorElementsBeforeAndUp(@NotNull PsiElement element2) {
        JBIterable previousErrors = JBIterable.generate((Object)element2, e -> (PsiElement)ObjectUtils.coalesce((Object)e.getPrevSibling(), (Object)e.getParent())).skip(1).filter(PsiErrorElement.class);
        return previousErrors.isNotEmpty();
    }

    protected final boolean isNearTemplateExpressions(@NotNull PsiFile file2, int start2, int end) {
        InjectedLanguageManager injectedLanguageManager;
        PsiLanguageInjectionHost host;
        FileViewProvider viewProvider = file2.getViewProvider();
        if (this.isTemplateViewProvider(viewProvider) && file2.getLanguage() != viewProvider.getBaseLanguage()) {
            CharSequence fileText = viewProvider.getContents();
            PsiElement beforeWs = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, CharArrayUtil.shiftBackward((CharSequence)fileText, (int)(start2 - 1), (String)" \t\n"));
            PsiElement afterWs = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, CharArrayUtil.shiftForward((CharSequence)fileText, (int)end, (String)" \t\n"));
            if (this.isTemplateEdge(afterWs) || this.isTemplateEdge(beforeWs) || this.hasTemplateInside(start2, end, viewProvider)) {
                return true;
            }
        }
        if ((host = (injectedLanguageManager = InjectedLanguageManager.getInstance((Project)file2.getProject())).getInjectionHost((PsiElement)file2)) != null && (start2 = injectedLanguageManager.injectedToHost((PsiElement)file2, start2)) <= (end = injectedLanguageManager.injectedToHost((PsiElement)file2, end))) {
            return this.isNearTemplateExpressions(host.getContainingFile(), start2, end);
        }
        return false;
    }

    private boolean hasTemplateInside(int start2, int end, FileViewProvider viewProvider) {
        int dataEnd;
        PsiElement data2 = TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, start2);
        return data2 != null && (dataEnd = data2.getTextRange().getEndOffset()) < end && this.isTemplateEdge(TemplateLanguageErrorFilter.findBaseLanguageElement(viewProvider, dataEnd));
    }

    @Nullable
    private static PsiElement findBaseLanguageElement(FileViewProvider viewProvider, int offset) {
        return viewProvider.findElementAt(offset, viewProvider.getBaseLanguage());
    }

    private boolean isTemplateEdge(PsiElement e) {
        return this.myTemplateExpressionEdgeTokens.contains(PsiUtilCore.getElementType((PsiElement)e));
    }

    protected boolean isKnownSubLanguage(@NotNull Language language) {
        for (Language knownLanguage : this.knownLanguageSet) {
            if (!language.is(knownLanguage) && !knownLanguage.getDialects().contains(language)) continue;
            return true;
        }
        return false;
    }
}

