/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.PersistentFSConstants;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import org.jetbrains.annotations.NotNull;

public class LargeFilesAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        VirtualFile file2;
        if (element2 instanceof PsiFile && SingleRootFileViewProvider.isTooLargeForIntelligence(file2 = ((PsiFile)element2).getViewProvider().getVirtualFile())) {
            holder.newAnnotation(HighlightSeverity.WARNING, CodeInsightBundle.message((String)"message.file.size.0.exceeds.code.insight.limit.1", (Object[])new Object[]{StringUtil.formatFileSize((long)file2.getLength()), StringUtil.formatFileSize((long)PersistentFSConstants.getMaxIntellisenseFileSize())})).fileLevel().create();
        }
    }
}

