/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.highlighting.PsiHighlightedReference;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class HyperlinkAnnotator
implements Annotator {
    private static final Key<String> messageKey = Key.create((String)"hyperlink.message");

    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        if (holder.isBatchMode()) {
            return;
        }
        for (PsiHighlightedReference reference2 : PsiSymbolReferenceService.getService().getReferences(element2, PsiHighlightedReference.class)) {
            TextRange range2 = reference2.getAbsoluteRange();
            if (range2.isEmpty()) continue;
            String message = reference2.highlightMessage();
            AnnotationBuilder annotationBuilder = message == null ? holder.newSilentAnnotation(reference2.highlightSeverity()) : holder.newAnnotation(reference2.highlightSeverity(), message);
            reference2.highlightReference(annotationBuilder.range(range2)).create();
        }
        if (WebReference.isWebReferenceWorthy(element2)) {
            for (PsiReference reference3 : element2.getReferences()) {
                TextRange rangeInElement;
                TextRange range3;
                if (reference3 instanceof WebReference) {
                    String message = (String)holder.getCurrentAnnotationSession().getUserData(messageKey);
                    if (message == null) {
                        message = HyperlinkAnnotator.getMessage();
                        holder.getCurrentAnnotationSession().putUserData(messageKey, (Object)message);
                    }
                    range3 = reference3.getRangeInElement().shiftRight(element2.getTextRange().getStartOffset());
                    holder.newAnnotation(HighlightSeverity.INFORMATION, message).range(range3).textAttributes(CodeInsightColors.INACTIVE_HYPERLINK_ATTRIBUTES).create();
                    continue;
                }
                if (!(reference3 instanceof HighlightedReference) || reference3.isSoft() || (rangeInElement = reference3.getRangeInElement()).isEmpty()) continue;
                range3 = rangeInElement.shiftRight(element2.getTextRange().getStartOffset());
                holder.newSilentAnnotation(HighlightInfoType.HIGHLIGHTED_REFERENCE_SEVERITY).range(range3).textAttributes(DefaultLanguageHighlighterColors.HIGHLIGHTED_REFERENCE).create();
            }
        }
    }

    @NotNull
    @ApiStatus.Internal
    public static String getMessage() {
        Shortcut keyboardShortcut;
        String message = IdeBundle.message((String)"open.url.in.browser.tooltip", (Object[])new Object[0]);
        Object[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("GotoDeclaration");
        String shortcutText = "";
        Shortcut mouseShortcut = (Shortcut)ContainerUtil.find((Object[])shortcuts, shortcut -> !shortcut.isKeyboard());
        if (mouseShortcut != null) {
            shortcutText = shortcutText + KeymapUtil.getShortcutText((Shortcut)mouseShortcut);
            shortcutText = shortcutText.replace("Button1 ", "");
        }
        if ((keyboardShortcut = (Shortcut)ContainerUtil.find((Object[])shortcuts, shortcut -> shortcut.isKeyboard())) != null) {
            if (!shortcutText.isEmpty()) {
                shortcutText = shortcutText + ", ";
            }
            shortcutText = shortcutText + KeymapUtil.getShortcutText((Shortcut)keyboardShortcut);
        }
        if (!shortcutText.isEmpty()) {
            message = message + " (" + shortcutText + ")";
        }
        return message;
    }
}

