/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.daemon.impl.IdentifierUtil;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.highlighting.HighlightHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.highlighting.HighlightManagerImpl;
import com.intellij.codeInsight.highlighting.HighlightUsagesDescriptionLocation;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.codeInsight.highlighting.HighlightUsagesKt;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.pom.PsiDeclaredTarget;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.ExternallyAnnotated;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageTargetUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightUsagesHandler
extends HighlightHandlerBase {
    public static void invoke(@NotNull Project project, @NotNull Editor editor, @Nullable PsiFile file2) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        SelectionModel selectionModel = editor.getSelectionModel();
        if (file2 == null && !selectionModel.hasSelection()) {
            selectionModel.selectWordAtCaret(false);
        }
        if (file2 == null || selectionModel.hasSelection()) {
            HighlightUsagesHandler.doRangeHighlighting(editor, project);
            return;
        }
        HighlightUsagesHandlerBase handler2 = HighlightUsagesHandler.createCustomHandler(editor, file2);
        if (handler2 != null) {
            String featureId = handler2.getFeatureId();
            if (featureId != null) {
                FeatureUsageTracker.getInstance().triggerFeatureUsed(featureId);
            }
            handler2.highlightUsages();
            return;
        }
        DumbService.getInstance((Project)project).withAlternativeResolveEnabled(() -> {
            if (Registry.is((String)"ide.symbol.find.usages")) {
                if (!HighlightUsagesKt.highlightUsages(project, editor, file2)) {
                    HighlightUsagesHandler.handleNoUsageTargets(file2, editor, selectionModel, project);
                }
                return;
            }
            UsageTarget[] usageTargets = HighlightUsagesHandler.getUsageTargets(editor, file2);
            if (usageTargets.length == 0) {
                HighlightUsagesHandler.handleNoUsageTargets(file2, editor, selectionModel, project);
                return;
            }
            boolean clearHighlights = HighlightUsagesHandler.isClearHighlights(editor);
            for (UsageTarget target2 : usageTargets) {
                target2.highlightUsages(file2, editor, clearHighlights);
            }
        });
    }

    private static UsageTarget @NotNull [] getUsageTargets(@NotNull Editor editor, @NotNull PsiFile file2) {
        Object[] results;
        PsiReference ref;
        PsiElement targetElement;
        UsageTarget[] usageTargets = UsageTargetUtil.findUsageTargets((Editor)editor, (PsiFile)file2);
        if (usageTargets.length == 0 && (targetElement = HighlightUsagesHandler.getTargetElement(editor, file2)) != null && targetElement != file2) {
            if (!(targetElement instanceof NavigationItem)) {
                targetElement = targetElement.getNavigationElement();
            }
            if (targetElement instanceof NavigationItem) {
                usageTargets = new UsageTarget[]{new PsiElement2UsageTargetAdapter(targetElement)};
            }
        }
        if (usageTargets.length == 0 && (ref = TargetElementUtil.findReference(editor)) instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)ref).multiResolve(false)).length > 0) {
            usageTargets = (UsageTarget[])ContainerUtil.mapNotNull((Object[])results, result2 -> {
                PsiElement element2 = result2.getElement();
                return element2 == null ? null : new PsiElement2UsageTargetAdapter(element2);
            }, (Object[])UsageTarget.EMPTY_ARRAY);
        }
        return usageTargets;
    }

    private static void handleNoUsageTargets(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull SelectionModel selectionModel, @NotNull Project project) {
        if (file2.findElementAt(editor.getCaretModel().getOffset()) instanceof PsiWhiteSpace) {
            return;
        }
        selectionModel.selectWordAtCaret(false);
        String selection = selectionModel.getSelectedText();
        if (selection != null) {
            for (int i2 = 0; i2 < selection.length(); ++i2) {
                if (Character.isJavaIdentifierPart(selection.charAt(i2))) continue;
                selectionModel.removeSelection();
            }
        }
        HighlightUsagesHandler.doRangeHighlighting(editor, project);
        selectionModel.removeSelection();
    }

    @Nullable
    public static <T extends PsiElement> HighlightUsagesHandlerBase<T> createCustomHandler(@NotNull Editor editor, @NotNull PsiFile file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return HighlightUsagesHandler.createCustomHandler(editor, file2, visibleRange);
    }

    @Nullable
    public static <T extends PsiElement> HighlightUsagesHandlerBase<T> createCustomHandler(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull ProperTextRange visibleRange) {
        for (HighlightUsagesHandlerFactory factory2 : HighlightUsagesHandlerFactory.EP_NAME.getExtensionList()) {
            HighlightUsagesHandlerBase handler2 = factory2.createHighlightUsagesHandler(editor, file2, visibleRange);
            if (handler2 == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private static PsiElement getTargetElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        int offset;
        PsiElement element2;
        PsiElement target2 = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getReferenceSearchFlags());
        if (target2 == null && (element2 = file2.findElementAt(offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset()))) == null) {
            return null;
        }
        return target2;
    }

    private static void doRangeHighlighting(@NotNull Editor editor, @NotNull Project project) {
        EditorSearchSession oldSearch;
        if (!editor.getSelectionModel().hasSelection()) {
            return;
        }
        String text = editor.getSelectionModel().getSelectedText();
        if (text == null) {
            return;
        }
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((oldSearch = EditorSearchSession.get(editor)) != null && oldSearch.hasMatches()) {
            String oldText = oldSearch.getTextInField();
            if (!oldSearch.getFindModel().isRegularExpressions()) {
                oldText = StringUtil.escapeToRegexp((String)oldText);
                oldSearch.getFindModel().setRegularExpressions(true);
            }
            String newText = oldText + '|' + StringUtil.escapeToRegexp((String)text);
            oldSearch.setTextInField(newText);
            return;
        }
        EditorSearchSession.start(editor, project).getFindModel().setRegularExpressions(false);
    }

    public static void highlightReferences(@NotNull Project project, @NotNull PsiElement element2, @NotNull List<? extends PsiReference> refs, @NotNull Editor editor, @NotNull PsiFile file2, boolean clearHighlights) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        HighlightUsagesHandler.setupFindModel(project);
        ReadWriteAccessDetector detector = ReadWriteAccessDetector.findDetector((PsiElement)element2);
        if (detector != null) {
            ArrayList<PsiReference> readRefs = new ArrayList<PsiReference>();
            ArrayList<PsiReference> writeRefs = new ArrayList<PsiReference>();
            for (PsiReference psiReference : refs) {
                if (detector.getReferenceAccess(element2, psiReference) == ReadWriteAccessDetector.Access.Read) {
                    readRefs.add(psiReference);
                    continue;
                }
                writeRefs.add(psiReference);
            }
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, readRefs, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights);
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, writeRefs, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, clearHighlights);
        } else {
            HighlightUsagesHandler.doHighlightRefs(highlightManager, editor, refs, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights);
        }
        TextRange range2 = HighlightUsagesHandler.getNameIdentifierRange(file2, element2);
        if (range2 != null) {
            TextAttributesKey nameAttributes = detector != null && detector.isDeclarationWriteAccess(element2) ? EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES : EditorColors.SEARCH_RESULT_ATTRIBUTES;
            HighlightUsagesHandler.highlightRanges(highlightManager, editor, nameAttributes, clearHighlights, Collections.singletonList(range2));
        }
    }

    @ApiStatus.Experimental
    public static void highlightUsages(@NotNull Project project, @NotNull Editor editor, @NotNull @NotNull Couple<@NotNull List<@NotNull TextRange>> usages, boolean clearHighlights) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        HighlightUsagesHandler.setupFindModel(project);
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, EditorColors.SEARCH_RESULT_ATTRIBUTES, clearHighlights, (List<? extends TextRange>)((List)usages.first));
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES, clearHighlights, (List<? extends TextRange>)((List)usages.second));
        HighlightUsagesHandler.setStatusText(project, null, ((List)usages.first).size() + ((List)usages.second).size(), clearHighlights);
    }

    @Nullable
    public static TextRange getNameIdentifierRange(@NotNull PsiFile file2, @NotNull PsiElement element2) {
        PsiDeclaredTarget declaredTarget;
        TextRange range2;
        PomTarget target2;
        InjectedLanguageManager injectedManager = InjectedLanguageManager.getInstance((Project)element2.getProject());
        if (element2 instanceof PomTargetPsiElement && (target2 = ((PomTargetPsiElement)element2).getTarget()) instanceof PsiDeclaredTarget && (range2 = (declaredTarget = (PsiDeclaredTarget)target2).getNameIdentifierRange()) != null) {
            if (range2.getStartOffset() < 0 || range2.getLength() <= 0) {
                return null;
            }
            PsiElement navElement = declaredTarget.getNavigationElement();
            if (PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)navElement)) {
                return injectedManager.injectedToHost(navElement, range2.shiftRight(navElement.getTextRange().getStartOffset()));
            }
        }
        if (!PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)element2)) {
            return null;
        }
        PsiElement identifier = IdentifierUtil.getNameIdentifier(element2);
        if (identifier != null && PsiUtilBase.isUnderPsiRoot((PsiFile)file2, (PsiElement)identifier)) {
            TextRange range3 = identifier instanceof ExternallyAnnotated ? ((ExternallyAnnotated)identifier).getAnnotationRegion() : identifier.getTextRange();
            return range3 == null ? null : injectedManager.injectedToHost(identifier, range3);
        }
        return null;
    }

    @Deprecated
    public static void doHighlightElements(@NotNull Editor editor, PsiElement @NotNull [] elements2, @NotNull TextAttributes attributes, boolean clearHighlights) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)editor.getProject());
        ArrayList<TextRange> textRanges = new ArrayList<TextRange>(elements2.length);
        for (PsiElement element2 : elements2) {
            TextRange range2 = element2.getTextRange();
            range2 = InjectedLanguageManager.getInstance((Project)element2.getProject()).injectedToHost(element2, range2);
            textRanges.add(range2);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, null, clearHighlights, textRanges);
    }

    @Deprecated
    public static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor, @NotNull TextAttributes attributes, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributes, null, clearHighlights, textRanges);
    }

    public static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor, @NotNull TextAttributesKey attributesKey, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, null, attributesKey, clearHighlights, textRanges);
    }

    private static void highlightRanges(@NotNull HighlightManager highlightManager, @NotNull Editor editor, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean clearHighlights, @NotNull List<? extends TextRange> textRanges) {
        assert (attributes != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (clearHighlights) {
            HighlightUsagesHandler.clearHighlights(editor, highlightManager, textRanges, attributes, attributesKey);
            return;
        }
        ArrayList highlighters = new ArrayList();
        for (TextRange textRange : textRanges) {
            if (attributes != null) {
                highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributes, false, highlighters);
                continue;
            }
            highlightManager.addRangeHighlight(editor, textRange.getStartOffset(), textRange.getEndOffset(), attributesKey, false, highlighters);
        }
        for (RangeHighlighter rangeHighlighter : highlighters) {
            String tooltip = HighlightUsagesHandler.getLineTextErrorStripeTooltip(editor.getDocument(), rangeHighlighter.getStartOffset(), true);
            rangeHighlighter.setErrorStripeTooltip((Object)tooltip);
        }
    }

    public static boolean isClearHighlights(@NotNull Editor editor) {
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)HighlightManager.getInstance((Project)editor.getProject())).getHighlighters(editor);
        int caretOffset = editor.getCaretModel().getOffset();
        for (RangeHighlighter highlighter : highlighters) {
            if (!TextRange.create((Segment)highlighter).grown(1).contains(caretOffset)) continue;
            return true;
        }
        return false;
    }

    private static void clearHighlights(@NotNull Editor editor, @NotNull HighlightManager highlightManager, @NotNull List<? extends TextRange> rangesToHighlight, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey) {
        assert (attributes != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        RangeHighlighter[] highlighters = ((HighlightManagerImpl)highlightManager).getHighlighters(editor);
        Arrays.sort(highlighters, Comparator.comparingInt(RangeMarker::getStartOffset));
        rangesToHighlight.sort(Comparator.comparingInt(TextRange::getStartOffset));
        int i2 = 0;
        int j = 0;
        while (i2 < highlighters.length && j < rangesToHighlight.size()) {
            RangeHighlighter highlighter = highlighters[i2];
            TextRange highlighterRange = TextRange.create((Segment)highlighter);
            TextRange refRange = rangesToHighlight.get(j);
            if (refRange.equals((Object)highlighterRange) && highlighter.getLayer() == 5999 && (Objects.equals(attributesKey, highlighter.getTextAttributesKey()) || Objects.equals(attributes, highlighter.getTextAttributes(editor.getColorsScheme())))) {
                highlightManager.removeSegmentHighlighter(editor, highlighter);
                ++i2;
                continue;
            }
            if (refRange.getStartOffset() > highlighterRange.getEndOffset()) {
                ++i2;
                continue;
            }
            if (refRange.getEndOffset() < highlighterRange.getStartOffset()) {
                ++j;
                continue;
            }
            ++i2;
            ++j;
        }
    }

    private static void doHighlightRefs(@NotNull HighlightManager highlightManager, @NotNull Editor editor, @NotNull List<? extends PsiReference> refs, @NotNull TextAttributesKey attributesKey, boolean clearHighlights) {
        ArrayList textRanges = new ArrayList(refs.size());
        for (PsiReference psiReference : refs) {
            HighlightUsagesHandler.collectHighlightRanges((PsiSymbolReference)psiReference, textRanges);
        }
        HighlightUsagesHandler.highlightRanges(highlightManager, editor, attributesKey, clearHighlights, textRanges);
    }

    @NotNull
    public static List<TextRange> collectRangesToHighlight(@NotNull PsiReference ref, @NotNull List<TextRange> result2) {
        HighlightUsagesHandler.collectHighlightRanges((PsiSymbolReference)ref, result2);
        return result2;
    }

    public static void collectHighlightRanges(@NotNull PsiSymbolReference ref, @NotNull List<? super TextRange> result2) {
        for (TextRange relativeRange : ReferenceRange.getRanges((PsiSymbolReference)ref)) {
            HighlightUsagesHandler.collectHighlightRanges(ref.getElement(), relativeRange, result2);
        }
    }

    public static void collectHighlightRanges(@NotNull PsiElement element2, @NotNull TextRange rangeInElement, @NotNull List<? super TextRange> result2) {
        TextRange range2 = HighlightUsagesHandler.safeCut(element2.getTextRange(), rangeInElement);
        if (range2.isEmpty()) {
            return;
        }
        result2.add((TextRange)InjectedLanguageManager.getInstance((Project)element2.getProject()).injectedToHost(element2, range2));
    }

    @NotNull
    private static TextRange safeCut(@NotNull TextRange range2, @NotNull TextRange relative) {
        int start2 = Math.min(range2.getEndOffset(), range2.getStartOffset() + relative.getStartOffset());
        int end = Math.min(range2.getEndOffset(), range2.getStartOffset() + relative.getEndOffset());
        return new TextRange(start2, end);
    }

    private static void setStatusText(@NotNull Project project, @Nullable String elementName, int refCount, boolean clearHighlights) {
        String message = clearHighlights ? "" : (refCount > 0 ? CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.message" : "status.bar.highlighted.usages.no.target.message"), (Object[])new Object[]{refCount, elementName, HighlightUsagesHandler.getShortcutText()}) : CodeInsightBundle.message((String)(elementName != null ? "status.bar.highlighted.usages.not.found.message" : "status.bar.highlighted.usages.not.found.no.target.message"), (Object[])new Object[]{elementName}));
        WindowManager.getInstance().getStatusBar(project).setInfo(message);
    }

    @NotNull
    private static String getElementName(@NotNull PsiElement element2) {
        return ElementDescriptionUtil.getElementDescription((PsiElement)element2, (ElementDescriptionLocation)HighlightUsagesDescriptionLocation.INSTANCE);
    }

    @NotNull
    public static String getShortcutText() {
        Shortcut[] shortcuts = ActionManager.getInstance().getAction("HighlightUsagesInFile").getShortcutSet().getShortcuts();
        if (shortcuts.length == 0) {
            return "<no key assigned>";
        }
        return KeymapUtil.getShortcutText((Shortcut)shortcuts[0]);
    }

    public static class DoHighlightRunnable
    implements Runnable {
        private final List<? extends PsiReference> myRefs;
        @NotNull
        private final Project myProject;
        private final PsiElement myTarget;
        private final Editor myEditor;
        private final PsiFile myFile;
        private final boolean myClearHighlights;

        public DoHighlightRunnable(@NotNull List<? extends PsiReference> refs, @NotNull Project project, @NotNull PsiElement target2, @NotNull Editor editor, @NotNull PsiFile file2, boolean clearHighlights) {
            this.myRefs = refs;
            this.myProject = project;
            this.myTarget = target2;
            this.myEditor = editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor;
            this.myFile = file2;
            this.myClearHighlights = clearHighlights;
        }

        @Override
        public void run() {
            HighlightUsagesHandler.highlightReferences(this.myProject, this.myTarget, this.myRefs, this.myEditor, this.myFile, this.myClearHighlights);
            HighlightUsagesHandler.setStatusText(this.myProject, HighlightUsagesHandler.getElementName(this.myTarget), this.myRefs.size(), this.myClearHighlights);
        }
    }
}

