/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.Consumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightFlags>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project) {
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject).subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Document document = event.getDocument();
                Iterator iterator2 = EditorFactory.getInstance().editors(document).iterator();
                while (iterator2.hasNext()) {
                    Editor editor = (Editor)iterator2.next();
                    Map map2 = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map2 == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map2.keySet()) {
                        HighlightFlags info = (HighlightFlags)map2.get(highlighter);
                        if (!info.editor.getDocument().equals(document) || !BitUtil.isSet((int)info.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener(documentListener, (Disposable)this.myProject);
    }

    @Nullable
    private Map<RangeHighlighter, HighlightFlags> getHighlightInfoMap(@NotNull Editor editor, boolean toCreate) {
        Map map2;
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        if ((map2 = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY)) == null && toCreate) {
            map2 = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, new HashMap());
        }
        return map2;
    }

    public RangeHighlighter @NotNull [] getHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightFlags> highlightersMap = this.getHighlightInfoMap(editor, false);
        if (highlightersMap == null) {
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightFlags> entry : highlightersMap.entrySet()) {
            HighlightFlags info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set.add(entry.getKey());
        }
        return set.toArray(RangeHighlighter.EMPTY_ARRAY);
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        Map<RangeHighlighter, HighlightFlags> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 == null) {
            return false;
        }
        HighlightFlags info = map2.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map2.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, PsiReference @NotNull [] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        this.addOccurrenceHighlights(editor, occurrences, attributes, null, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, PsiReference @NotNull [] occurrences, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        this.addOccurrenceHighlights(editor, occurrences, null, attributesKey, hideByTextChange, outHighlighters);
    }

    private void addOccurrenceHighlights(@NotNull Editor editor, PsiReference @NotNull [] occurrences, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        assert (attributes != null || attributesKey != null) : "Both attributes and attributesKey are null";
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project;
            PsiElement element2 = occurrence.getElement();
            int startOffset = element2.getTextRange().getStartOffset();
            int start2 = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element2.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project = element2.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start2, end, attributes, attributesKey, flags, outHighlighters, scrollMarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start2, int end, TextAttributes attributes, int flags, Collection<? super RangeHighlighter> outHighlighters, Color scrollMarkColor) {
        this.addOccurrenceHighlight(editor, start2, end, attributes, null, flags, outHighlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start2, int end, TextAttributesKey attributesKey, int flags, Collection<? super RangeHighlighter> outHighlighters) {
        this.addOccurrenceHighlight(editor, start2, end, null, attributesKey, flags, outHighlighters, null);
    }

    private void addOccurrenceHighlight(@NotNull Editor editor, int start2, int end, @Nullable TextAttributes forcedAttributes, @Nullable TextAttributesKey attributesKey, int flags, @Nullable Collection<? super RangeHighlighter> outHighlighters, @Nullable Color scrollMarkColor) {
        MarkupModelEx markupModel = (MarkupModelEx)editor.getMarkupModel();
        markupModel.addRangeHighlighterAndChangeAttributes(attributesKey, start2, end, 5999, HighlighterTargetArea.EXACT_RANGE, false, (Consumer<? super RangeHighlighterEx>)((Consumer)highlighter -> {
            HighlightFlags info = new HighlightFlags(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
            Map<RangeHighlighter, HighlightFlags> map2 = this.getHighlightInfoMap(editor, true);
            map2.put((RangeHighlighter)highlighter, info);
            highlighter.setVisibleIfFolded(true);
            if (outHighlighters != null) {
                outHighlighters.add((RangeHighlighter)highlighter);
            }
            if (forcedAttributes != null) {
                highlighter.setTextAttributes(forcedAttributes);
            }
            if (scrollMarkColor != null) {
                highlighter.setErrorStripeMarkColor(scrollMarkColor);
            }
        }));
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, @Nullable Collection<? super RangeHighlighter> highlighters) {
        this.addRangeHighlight(editor, startOffset, endOffset, null, attributesKey, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<? super RangeHighlighter> highlighters) {
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, null, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, null, hideByTextChange, hideByAnyKey, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        this.addRangeHighlight(editor, startOffset, endOffset, null, attributesKey, hideByTextChange, hideByAnyKey, highlighters);
    }

    private void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<? super RangeHighlighter> highlighters) {
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, attributesKey, flags, highlighters, scrollMarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, PsiElement @NotNull [] elements2, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        this.addOccurrenceHighlights(editor, elements2, attributes, null, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, PsiElement @NotNull [] elements2, @NotNull TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        this.addOccurrenceHighlights(editor, elements2, null, attributesKey, hideByTextChange, outHighlighters);
    }

    private void addOccurrenceHighlights(@NotNull Editor editor, PsiElement @NotNull [] elements2, @Nullable TextAttributes attributes, @Nullable TextAttributesKey attributesKey, boolean hideByTextChange, Collection<? super RangeHighlighter> outHighlighters) {
        if (elements2.length == 0 || editor instanceof ImaginaryEditor) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollMarkColor = HighlightManagerImpl.getScrollMarkColor(attributes, editor.getColorsScheme());
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element2 : elements2) {
            TextRange range2 = element2.getTextRange();
            range2 = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element2, range2);
            this.addOccurrenceHighlight(editor, HighlightManagerImpl.trimOffsetToDocumentSize(editor, range2.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor, range2.getEndOffset()), attributes, attributesKey, flags, outHighlighters, scrollMarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor, int offset) {
        if (offset < 0) {
            return 0;
        }
        int textLength = editor.getDocument().getTextLength();
        return Math.min(offset, textLength);
    }

    @Nullable
    private static Color getScrollMarkColor(@Nullable TextAttributes attributes, @NotNull EditorColorsScheme colorScheme) {
        if (attributes == null) {
            return null;
        }
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            boolean isDark = ColorUtil.isDark((Color)colorScheme.getDefaultBackground());
            return isDark ? attributes.getBackgroundColor().brighter() : attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor, @HighlightManager.HideFlags int mask) {
        Map<RangeHighlighter, HighlightFlags> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 == null) {
            return false;
        }
        boolean done = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map2.keySet()) {
            HighlightFlags info = map2.get(highlighter);
            if (!InjectedLanguageUtil.getTopLevelEditor(info.editor).equals(InjectedLanguageUtil.getTopLevelEditor(editor)) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done;
    }

    boolean hasHideByEscapeHighlighters(@NotNull Editor editor) {
        Map<RangeHighlighter, HighlightFlags> map2 = this.getHighlightInfoMap(editor, false);
        if (map2 != null) {
            for (HighlightFlags info : map2.values()) {
                if (!info.editor.equals(editor) || (info.flags & 1) == 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class HighlightFlags {
        @NotNull
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        HighlightFlags(@NotNull Editor editor, @HighlightManager.HideFlags int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            this.requestHideHighlights(dataContext);
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(@NotNull DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }
    }
}

