/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCodeBlockSupportHandler
implements CodeBlockSupportHandler {
    @NotNull
    protected abstract TokenSet getTopLevelElementTypes();

    @NotNull
    protected abstract TokenSet getKeywordElementTypes();

    @NotNull
    protected abstract TokenSet getBlockElementTypes();

    @NotNull
    protected abstract TokenSet getDirectChildrenElementTypes(@Nullable IElementType var1);

    @Override
    @NotNull
    public List<TextRange> getCodeBlockMarkerRanges(@NotNull PsiElement elementAtCursor) {
        TokenSet keywordElementTypes = this.getKeywordElementTypes();
        if (!keywordElementTypes.contains(PsiUtilCore.getElementType((PsiElement)elementAtCursor))) {
            return Collections.emptyList();
        }
        PsiElement rootElement = AbstractCodeBlockSupportHandler.getParentByTokenSet(elementAtCursor, this.getTopLevelElementTypes());
        if (rootElement == null) {
            return Collections.emptyList();
        }
        return this.computeMarkersRanges(rootElement, keywordElementTypes);
    }

    @Override
    @NotNull
    public TextRange getCodeBlockRange(@NotNull PsiElement elementAtCursor) {
        return (TextRange)ObjectUtils.notNull((Object)ObjectUtils.doIfNotNull((Object)AbstractCodeBlockSupportHandler.getParentByTokenSet(elementAtCursor, this.getBlockElementTypes()), PsiElement::getTextRange), (Object)TextRange.EMPTY_RANGE);
    }

    @NotNull
    private List<TextRange> computeMarkersRanges(@NotNull PsiElement rootElement, @NotNull TokenSet keywordsElementTypes) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)rootElement);
        if (keywordsElementTypes.contains(type)) {
            return Collections.singletonList(rootElement.getTextRange());
        }
        TokenSet directChildrenTypes = this.getDirectChildrenElementTypes(type);
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        for (PsiElement currentElement = rootElement.getFirstChild(); currentElement != null; currentElement = currentElement.getNextSibling()) {
            IElementType currentElementType = PsiUtilCore.getElementType((PsiElement)currentElement);
            if (!directChildrenTypes.contains(currentElementType)) continue;
            result2.addAll(this.computeMarkersRanges(currentElement, keywordsElementTypes));
        }
        return result2;
    }

    @Nullable
    private static PsiElement getParentByTokenSet(@NotNull PsiElement element2, @NotNull TokenSet tokenSet) {
        PsiElement run2;
        for (run2 = element2; run2 != null && !tokenSet.contains(PsiUtilCore.getElementType((PsiElement)run2)); run2 = run2.getParent()) {
        }
        return run2;
    }
}

