/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SelfManagingCommenterUtil {
    @Nullable
    public static TextRange getBlockCommentRange(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull String prefix, @NotNull String suffix) {
        CharSequence sequence = document.getCharsSequence();
        selectionStart = CharArrayUtil.shiftForward((CharSequence)sequence, (int)selectionStart, (String)" \t\n");
        if ((selectionEnd = CharArrayUtil.shiftBackward((CharSequence)sequence, (int)(selectionEnd - 1), (String)" \t\n") + 1) < selectionStart) {
            selectionEnd = selectionStart;
        }
        if (CharArrayUtil.regionMatches((CharSequence)sequence, (int)(selectionEnd - suffix.length()), (CharSequence)suffix) && CharArrayUtil.regionMatches((CharSequence)sequence, (int)selectionStart, (CharSequence)prefix)) {
            return new TextRange(selectionStart, selectionEnd);
        }
        return null;
    }

    @NotNull
    public static TextRange insertBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull String prefix, @NotNull String suffix) {
        document.insertString(startOffset, (CharSequence)prefix);
        document.insertString(endOffset + prefix.length(), (CharSequence)suffix);
        return new TextRange(startOffset, endOffset + prefix.length() + suffix.length());
    }

    public static void uncommentBlockComment(int startOffset, int endOffset, @NotNull Document document, @NotNull String prefix, @NotNull String suffix) {
        document.deleteString(endOffset - suffix.length(), endOffset);
        document.deleteString(startOffset, startOffset + prefix.length());
    }
}

