/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.PatternDescriptor;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateByPatternDialog
extends DialogWrapper {
    private final Project myProject;
    private JPanel myPanel;
    private Splitter mySplitter;
    private final Tree myTree;
    private final Editor myEditor;
    private final MultiMap<String, PatternDescriptor> myMap;

    public GenerateByPatternDialog(Project project, PatternDescriptor[] descriptors) {
        super(project);
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(CodeInsightBundle.message((String)"button.generate.by.pattern", (Object[])objectArray));
        this.setOKButtonText(CodeInsightBundle.message((String)"button.generate", (Object[])new Object[0]));
        this.myMap = new MultiMap();
        for (PatternDescriptor descriptor2 : descriptors) {
            this.myMap.putValue((Object)descriptor2.getParentId(), (Object)descriptor2);
        }
        DefaultMutableTreeNode root = this.createNode(null);
        this.myTree = new SimpleTree(){};
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            @NotNull
            public Component getTreeCellRendererComponent(@NotNull JTree tree, Object value2, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component component2 = super.getTreeCellRendererComponent(tree, value2, sel, expanded, leaf, row, hasFocus);
                Object object = ((DefaultMutableTreeNode)value2).getUserObject();
                if (object instanceof PatternDescriptor) {
                    this.setText(((PatternDescriptor)object).getName());
                    this.setIcon(((PatternDescriptor)object).getIcon());
                }
                return component2;
            }
        });
        this.myTree.setModel((TreeModel)new DefaultTreeModel(root));
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                GenerateByPatternDialog.this.update();
            }
        });
        this.myEditor = TemplateEditorUtil.createEditor(true, "");
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myTree));
        JPanel details = new JPanel(new BorderLayout());
        details.add((Component)this.myEditor.getComponent(), "Center");
        this.mySplitter.setSecondComponent((JComponent)details);
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setShowDividerControls(true);
        this.myTree.setSelectionRow(0);
        this.init();
    }

    private void update() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        this.getOKAction().setEnabled(node != null && node.isLeaf());
        PatternDescriptor descriptor2 = this.getSelectedDescriptor();
        if (descriptor2 != null) {
            this.updateDetails(descriptor2);
        }
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.myTree.getSelectionModel().getSelectionPath();
        return path == null ? null : (DefaultMutableTreeNode)path.getLastPathComponent();
    }

    PatternDescriptor getSelectedDescriptor() {
        Object object;
        DefaultMutableTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode != null && (object = selectedNode.getUserObject()) instanceof PatternDescriptor) {
            return (PatternDescriptor)object;
        }
        return null;
    }

    private void updateDetails(PatternDescriptor descriptor2) {
        WriteCommandAction.writeCommandAction((Project)this.myProject).run(() -> {
            Template template = descriptor2.getTemplate();
            if (template instanceof TemplateImpl) {
                String text = template.getString();
                this.myEditor.getDocument().replaceString(0, this.myEditor.getDocument().getTextLength(), (CharSequence)text);
                TemplateEditorUtil.setHighlighter(this.myEditor, ((TemplateImpl)template).getTemplateContext());
            } else {
                this.myEditor.getDocument().replaceString(0, this.myEditor.getDocument().getTextLength(), (CharSequence)"");
            }
        });
    }

    private DefaultMutableTreeNode createNode(@Nullable PatternDescriptor descriptor2) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(descriptor2){

            @Override
            @NotNull
            public String toString() {
                Object object = this.getUserObject();
                return object == null ? "" : ((PatternDescriptor)object).getName();
            }
        };
        String id2 = descriptor2 == null ? "root" : descriptor2.getId();
        Collection collection = this.myMap.get((Object)id2);
        for (PatternDescriptor childDescriptor : collection) {
            root.add(this.createNode(childDescriptor));
        }
        return root;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    protected String getDimensionServiceKey() {
        return "generate.patterns.dialog";
    }

    protected void dispose() {
        super.dispose();
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }

    private void createUIComponents() {
        this.mySplitter = new Splitter(false, 0.3f);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Splitter splitter = this.mySplitter;
        jPanel2.add((Component)splitter, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, new Dimension(400, 300), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

