/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.folding.impl.AbstractElementSignatureProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNamesElementSignatureProvider
extends AbstractElementSignatureProvider {
    private static final String TYPE_MARKER = "n";
    private static final String TOP_LEVEL_CHILD_MARKER = "!!top";
    private static final String DOC_COMMENT_MARKER = "!!doc";
    private static final String CODE_BLOCK_MARKER = "!!block";

    @Override
    protected PsiElement restoreBySignatureTokens(@NotNull PsiFile file2, @NotNull PsiElement parent, @NotNull String type, @NotNull StringTokenizer tokenizer, @Nullable StringBuilder processingInfoStorage) {
        if (!TYPE_MARKER.equals(type)) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because given signature doesn't have expected type - can work with '%s' but got '%s'%n", this.getClass().getName(), TYPE_MARKER, type));
            }
            return null;
        }
        String elementMarker = tokenizer.nextToken();
        if (TOP_LEVEL_CHILD_MARKER.equals(elementMarker)) {
            PsiElement result2 = null;
            for (PsiElement child2 = file2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                if (child2 instanceof PsiWhiteSpace) continue;
                if (result2 == null) {
                    result2 = child2;
                    continue;
                }
                if (processingInfoStorage != null) {
                    processingInfoStorage.append(String.format("Stopping '%s' provider because it has top level marker but more than one non white-space child: %s%n", this.getClass().getName(), Arrays.toString(file2.getChildren())));
                }
                return null;
            }
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Finished processing of '%s' provider because all of its top-level children have been processed: %s%n", this.getClass().getName(), Arrays.toString(file2.getChildren())));
            }
            return result2;
        }
        if (DOC_COMMENT_MARKER.equals(elementMarker)) {
            PsiElement candidate = parent.getFirstChild();
            return candidate instanceof PsiComment ? candidate : null;
        }
        if (CODE_BLOCK_MARKER.equals(elementMarker)) {
            int index;
            block18: {
                index = 0;
                if (tokenizer.hasMoreTokens()) {
                    String indexStr = tokenizer.nextToken();
                    try {
                        index = Integer.parseInt(indexStr);
                    }
                    catch (NumberFormatException e) {
                        if (processingInfoStorage == null) break block18;
                        processingInfoStorage.append("Invalid block index: ").append(indexStr).append("\n");
                    }
                }
            }
            for (PsiElement child3 = parent.getFirstChild(); child3 != null; child3 = child3.getNextSibling()) {
                if (!PsiNamesElementSignatureProvider.isBlockElement(child3) || --index >= 0) continue;
                return child3;
            }
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Stopping '%s' provider because it has no more data to process%n", this.getClass().getName()));
            }
            return null;
        }
        try {
            int index = Integer.parseInt(tokenizer.nextToken());
            if (processingInfoStorage != null) {
                processingInfoStorage.append(String.format("Looking for the child with a name '%s' # %d at the element '%s'%n", elementMarker, index, parent));
            }
            return PsiNamesElementSignatureProvider.restoreElementInternal(parent, PsiNamesElementSignatureProvider.unescape(elementMarker), index, PsiNamedElement.class);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getSignature(@NotNull PsiElement element2) {
        StringBuilder buffer = null;
        for (PsiElement current2 = element2; current2 != null && !(current2 instanceof PsiFile); current2 = current2.getParent()) {
            int length = buffer == null ? 0 : buffer.length();
            StringBuilder b = PsiNamesElementSignatureProvider.getSignature(current2, buffer);
            if (b == null && buffer != null && current2.getParent() instanceof PsiFile && PsiNamesElementSignatureProvider.canResolveTopLevelChild(current2)) {
                buffer.append(TYPE_MARKER).append("#").append(TOP_LEVEL_CHILD_MARKER).append(";");
                break;
            }
            buffer = b;
            if (buffer == null || length >= buffer.length()) {
                return null;
            }
            buffer.append(";");
        }
        if (buffer == null) {
            return null;
        }
        buffer.setLength(buffer.length() - 1);
        return buffer.toString();
    }

    private static boolean canResolveTopLevelChild(@NotNull PsiElement element2) {
        PsiElement parent = element2.getParent();
        if (parent == null) {
            return false;
        }
        for (PsiElement child2 = parent.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
            if (child2 instanceof PsiWhiteSpace || child2 == element2) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static StringBuilder getSignature(@NotNull PsiElement element2, @Nullable StringBuilder buffer) {
        PsiElement parent;
        if (element2 instanceof PsiNamedElement) {
            PsiNamedElement named = (PsiNamedElement)element2;
            String name = named.getName();
            if (StringUtil.isEmpty((String)name)) {
                return null;
            }
            int index = PsiNamesElementSignatureProvider.getChildIndex(named, element2.getParent(), name, PsiNamedElement.class);
            if (index < 0) {
                return null;
            }
            StringBuilder bufferToUse = buffer;
            if (bufferToUse == null) {
                bufferToUse = new StringBuilder();
            }
            bufferToUse.append(TYPE_MARKER).append("#").append(PsiNamesElementSignatureProvider.escape(name)).append("#").append(index);
            return bufferToUse;
        }
        if (element2 instanceof PsiComment) {
            parent = element2.getParent();
            boolean nestedComment = false;
            if (parent instanceof PsiComment && parent.getTextRange().equals((Object)element2.getTextRange())) {
                parent = parent.getParent();
                nestedComment = true;
            }
            if (parent instanceof PsiNamedElement && (nestedComment || parent.getFirstChild() == element2)) {
                StringBuilder bufferToUse = buffer;
                if (bufferToUse == null) {
                    bufferToUse = new StringBuilder();
                }
                bufferToUse.append(TYPE_MARKER).append("#").append(DOC_COMMENT_MARKER);
                return bufferToUse;
            }
        }
        if ((parent = element2.getParent()) instanceof PsiNamedElement && !(parent instanceof PsiFile) && PsiNamesElementSignatureProvider.isBlockElement(element2)) {
            int index = PsiNamesElementSignatureProvider.getBlockElementIndex(element2);
            StringBuilder bufferToUse = buffer;
            if (bufferToUse == null) {
                bufferToUse = new StringBuilder();
            }
            bufferToUse.append(TYPE_MARKER).append("#").append(CODE_BLOCK_MARKER);
            if (index > 0) {
                bufferToUse.append("#").append(index);
            }
            return bufferToUse;
        }
        return null;
    }

    private static boolean isBlockElement(@NotNull PsiElement element2) {
        PsiElement firstChild = element2.getFirstChild();
        PsiElement lastChild = element2.getLastChild();
        return firstChild != null && "{".equals(firstChild.getText()) && lastChild != null && "}".equals(lastChild.getText());
    }

    private static int getBlockElementIndex(@NotNull PsiElement element2) {
        int i2 = 0;
        for (PsiElement sibling : element2.getParent().getChildren()) {
            if (element2.equals(sibling)) {
                return i2;
            }
            if (!PsiNamesElementSignatureProvider.isBlockElement(sibling)) continue;
            ++i2;
        }
        throw new RuntimeException("Malformed PSI");
    }
}

