/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.DocumentFoldingInfo;
import com.intellij.codeInsight.folding.impl.EditorFoldingInfo;
import com.intellij.codeInsight.folding.impl.FoldingUpdate;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.UpdateFoldRegionsOperation;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.containers.WeakList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeFoldingManagerImpl
extends CodeFoldingManager
implements Disposable {
    private final Project myProject;
    private final Collection<Document> myDocumentsWithFoldingInfo = new WeakList();
    private final Key<DocumentFoldingInfo> myFoldingInfoInDocumentKey = Key.create((String)"FOLDING_INFO_IN_DOCUMENT_KEY");
    private static final Key<Boolean> FOLDING_STATE_KEY = Key.create((String)"FOLDING_STATE_KEY");

    public CodeFoldingManagerImpl(final Project project) {
        this.myProject = project;
        LanguageFolding.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<KeyedLazyInstance<FoldingBuilder>>(){

            public void extensionAdded(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    CodeFoldingManagerImpl.this.scheduleAsyncFoldingUpdate(((TextEditor)fileEditor).getEditor());
                }
            }

            public void extensionRemoved(@NotNull KeyedLazyInstance<FoldingBuilder> extension, @NotNull PluginDescriptor pluginDescriptor) {
                for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                    if (!(fileEditor instanceof TextEditor)) continue;
                    CodeFoldingManagerImpl.this.updateFoldRegions(((TextEditor)fileEditor).getEditor());
                }
            }
        }, (Disposable)this);
        Runnable listener2 = () -> {
            for (FileEditor fileEditor : FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(fileEditor instanceof TextEditor)) continue;
                FoldingUpdate.clearFoldingCache(((TextEditor)fileEditor).getEditor());
            }
        };
        MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.addChangeListener((AreaInstance)project, listener2, (Disposable)this);
        LanguageInjector.EXTENSION_POINT_NAME.addChangeListener(listener2, (Disposable)this);
        CustomFoldingProvider.EP_NAME.addChangeListener(listener2, (Disposable)this);
    }

    public void dispose() {
        for (Document document : this.myDocumentsWithFoldingInfo) {
            if (document == null) continue;
            document.putUserData(this.myFoldingInfoInDocumentKey, null);
        }
    }

    @Override
    public void releaseFoldings(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        EditorFoldingInfo.disposeForEditor(editor);
    }

    @Override
    public void buildInitialFoldings(@NotNull Editor editor) {
        Project project = editor.getProject();
        if (project == null || !project.equals(this.myProject) || editor.isDisposed()) {
            return;
        }
        if (!((FoldingModelEx)editor.getFoldingModel()).isFoldingEnabled()) {
            return;
        }
        if (!FoldingUpdate.supportsDumbModeFolding(editor)) {
            return;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document);
        CodeFoldingState foldingState = this.buildInitialFoldings(document);
        if (foldingState != null) {
            foldingState.setToEditor(editor);
        }
    }

    @Override
    @Nullable
    public CodeFoldingState buildInitialFoldings(@NotNull Document document) {
        if (this.myProject.isDisposed()) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        if (psiDocumentManager.isUncommited(document)) {
            return null;
        }
        PsiFile file2 = psiDocumentManager.getPsiFile(document);
        if (file2 == null || !file2.isValid() || !file2.getViewProvider().isPhysical() && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        List<FoldingUpdate.RegionInfo> regionInfos = FoldingUpdate.getFoldingsFor(file2, true);
        return editor -> {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (this.myProject.isDisposed() || editor.isDisposed()) {
                return;
            }
            FoldingModelEx foldingModel = (FoldingModelEx)editor.getFoldingModel();
            if (!foldingModel.isFoldingEnabled()) {
                return;
            }
            if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                return;
            }
            if (DumbService.isDumb((Project)this.myProject) && !FoldingUpdate.supportsDumbModeFolding(editor)) {
                return;
            }
            foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new UpdateFoldRegionsOperation(this.myProject, editor, file2, regionInfos, UpdateFoldRegionsOperation.ApplyDefaultStateMode.YES, false, false));
            this.initFolding(editor);
        };
    }

    @Override
    @Nullable
    public Boolean isCollapsedByDefault(@NotNull FoldRegion region) {
        return (Boolean)region.getUserData(UpdateFoldRegionsOperation.COLLAPSED_BY_DEFAULT);
    }

    @Override
    public void scheduleAsyncFoldingUpdate(@NotNull Editor editor) {
        FoldingUpdate.clearFoldingCache(editor);
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    private void initFolding(@NotNull Editor editor) {
        Document document = editor.getDocument();
        editor.getFoldingModel().runBatchFoldingOperation(() -> {
            DocumentFoldingInfo documentFoldingInfo = this.getDocumentFoldingInfo(document);
            EditorFactory.getInstance().editors(document, this.myProject).filter(otherEditor -> otherEditor != editor && CodeFoldingManagerImpl.isFoldingsInitializedInEditor(otherEditor)).findFirst().ifPresent(documentFoldingInfo::loadFromEditor);
            documentFoldingInfo.setToEditor(editor);
            documentFoldingInfo.clear();
            editor.putUserData(FOLDING_STATE_KEY, (Object)Boolean.TRUE);
        });
    }

    @Override
    @Nullable
    public FoldRegion findFoldRegion(@NotNull Editor editor, int startOffset, int endOffset) {
        return FoldingUtil.findFoldRegion(editor, startOffset, endOffset);
    }

    @Override
    public FoldRegion[] getFoldRegionsAtOffset(@NotNull Editor editor, int offset) {
        return FoldingUtil.getFoldRegionsAtOffset(editor, offset);
    }

    @Override
    public void updateFoldRegions(@NotNull Editor editor) {
        this.updateFoldRegions(editor, false);
    }

    public void updateFoldRegions(Editor editor, boolean quick) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(editor.getDocument());
        Runnable runnable2 = this.updateFoldRegions(editor, false, quick);
        if (runnable2 != null) {
            runnable2.run();
        }
    }

    @Override
    @Nullable
    public Runnable updateFoldRegionsAsync(@NotNull Editor editor, boolean firstTime) {
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return null;
        }
        Runnable runnable2 = this.updateFoldRegions(editor, firstTime, false);
        return () -> {
            if (runnable2 != null) {
                runnable2.run();
            }
            if (firstTime && !CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
                this.initFolding(editor);
            }
        };
    }

    @Nullable
    private Runnable updateFoldRegions(@NotNull Editor editor, boolean applyDefaultState, boolean quick) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        return file2 == null ? null : FoldingUpdate.updateFoldRegions(editor, file2, applyDefaultState, quick);
    }

    @Override
    public CodeFoldingState saveFoldingState(@NotNull Editor editor) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(editor.getDocument());
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            info.loadFromEditor(editor);
        }
        return info;
    }

    @Override
    public void restoreFoldingState(@NotNull Editor editor, @NotNull CodeFoldingState state) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (CodeFoldingManagerImpl.isFoldingsInitializedInEditor(editor)) {
            state.setToEditor(editor);
        }
    }

    @Override
    public void writeFoldingState(@NotNull CodeFoldingState state, @NotNull Element element2) {
        if (state instanceof DocumentFoldingInfo) {
            ((DocumentFoldingInfo)state).writeExternal(element2);
        }
    }

    @Override
    public CodeFoldingState readFoldingState(@NotNull Element element2, @NotNull Document document) {
        DocumentFoldingInfo info = this.getDocumentFoldingInfo(document);
        info.readExternal(element2);
        return info;
    }

    @NotNull
    private DocumentFoldingInfo getDocumentFoldingInfo(@NotNull Document document) {
        DocumentFoldingInfo info = (DocumentFoldingInfo)document.getUserData(this.myFoldingInfoInDocumentKey);
        if (info == null) {
            info = new DocumentFoldingInfo(this.myProject, document);
            DocumentFoldingInfo written = (DocumentFoldingInfo)((UserDataHolderEx)document).putUserDataIfAbsent(this.myFoldingInfoInDocumentKey, (Object)info);
            if (written == info) {
                this.myDocumentsWithFoldingInfo.add(document);
            } else {
                info = written;
            }
        }
        return info;
    }

    private static boolean isFoldingsInitializedInEditor(@NotNull Editor editor) {
        return Boolean.TRUE.equals(editor.getUserData(FOLDING_STATE_KEY));
    }
}

