/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.completion.SkipAutopopupInStrings;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralValue;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.IntStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class InjectedFileReferenceSelectioner
extends AbstractWordSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        return PsiTreeUtil.getParentOfType((PsiElement)e, PsiLanguageInjectionHost.class) != null;
    }

    @Override
    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        BitSet compositeIndexes;
        BitSet charEscapeLocations;
        PsiElement host = PsiTreeUtil.getParentOfType((PsiElement)e, PsiLanguageInjectionHost.class);
        if (host == null) {
            return Collections.emptyList();
        }
        TextRange realRange = ElementManipulators.getValueTextRange((PsiElement)host).shiftRight(host.getTextRange().getStartOffset());
        if (!realRange.contains(cursorOffset)) {
            return Collections.emptyList();
        }
        PsiElement valueElement = InjectedFileReferenceSelectioner.findValueElement(host, realRange);
        List<TextRange> segments = InjectedFileReferenceSelectioner.buildSegments(editorText, cursorOffset, realRange = InjectedFileReferenceSelectioner.limitToCurrentLineAndStripWhiteSpace(editorText, cursorOffset, realRange), charEscapeLocations = InjectedFileReferenceSelectioner.isWithinLiteral(e, host) ? InjectedFileReferenceSelectioner.findCharEscapeLocations(editor, editorText, host.getTextRange(), realRange.getStartOffset()) : new BitSet(0), compositeIndexes = InjectedFileReferenceSelectioner.createCompositeIndexesSet(valueElement, realRange.getStartOffset()));
        if (!segments.isEmpty()) {
            int endOffsetAlignment = segments.get(segments.size() - 1).getEndOffset();
            ListIterator<TextRange> it = segments.listIterator();
            while (it.hasNext()) {
                TextRange r = it.next();
                if (r.getEndOffset() > cursorOffset) continue;
                it.set(TextRange.create((int)r.getStartOffset(), (int)endOffsetAlignment));
            }
            segments.add(realRange);
        }
        return segments;
    }

    @NotNull
    private static PsiElement findValueElement(@NotNull PsiElement host, @NotNull TextRange valueRange) {
        return (PsiElement)ObjectUtils.notNull((Object)PsiTreeUtil.findFirstParent((PsiElement)host.getContainingFile().findElementAt(valueRange.getStartOffset()), (boolean)false, parent -> parent == host || parent.getTextRange().contains(valueRange)), (Object)host);
    }

    @NotNull
    private static List<TextRange> buildSegments(@NotNull CharSequence editorText, int cursorOffset, @NotNull TextRange range2, @NotNull BitSet charEscapeLocations, @NotNull BitSet compositeIndexes) {
        if (range2.getLength() == 0) {
            return Collections.emptyList();
        }
        int hostTextOffset = range2.getStartOffset();
        int hostTextEndOffset = range2.getEndOffset();
        ArrayList<TextRange> segments = new ArrayList<TextRange>();
        int rangeStart = hostTextOffset;
        boolean segmentsFinished = false;
        int hardSegmentCount = 0;
        for (int i2 = hostTextOffset; i2 < hostTextEndOffset; ++i2) {
            if (compositeIndexes.get(i2 - hostTextOffset)) continue;
            char ch = editorText.charAt(i2);
            if (!segmentsFinished) {
                if (ch == '/' || ch == '\\' && !charEscapeLocations.get(i2 - hostTextOffset) || ch == ' ' && i2 <= cursorOffset) {
                    if (rangeStart < i2) {
                        if (editorText.charAt(i2 - 1) == ':') {
                            segments.add(new TextRange(rangeStart, i2 - 1));
                        } else {
                            segments.add(new TextRange(rangeStart, i2));
                        }
                        if (i2 > cursorOffset) {
                            segmentsFinished = true;
                        }
                    }
                    rangeStart = i2 + 1;
                    if (ch != ' ') {
                        ++hardSegmentCount;
                    }
                } else if (ch == '?') {
                    segments.add(new TextRange(rangeStart, i2));
                    if (i2 + 1 < hostTextEndOffset) {
                        segments.add(new TextRange(i2 + 1, hostTextEndOffset));
                    }
                    segments.add(new TextRange(rangeStart, hostTextEndOffset));
                    segmentsFinished = true;
                }
            }
            if ((ch != '>' || i2 <= hostTextOffset || editorText.charAt(i2 - 1) != '/') && (ch != '<' || i2 + 1 >= hostTextEndOffset || editorText.charAt(i2 + 1) != '/')) continue;
            return Collections.emptyList();
        }
        if (hardSegmentCount <= 0) {
            return Collections.emptyList();
        }
        if (!segmentsFinished && rangeStart < hostTextEndOffset) {
            segments.add(new TextRange(rangeStart, hostTextEndOffset));
        }
        return segments;
    }

    @NotNull
    private static BitSet createCompositeIndexesSet(@NotNull PsiElement valueElement, int indexesOffset) {
        return ((StreamEx)StreamEx.of((Object[])valueElement.getChildren()).filter(child2 -> !(child2 instanceof LeafPsiElement))).map(PsiElement::getTextRange).flatMapToInt(range2 -> IntStream.range(range2.getStartOffset(), range2.getEndOffset())).map(index -> index - indexesOffset).atLeast(0).toBitSet();
    }

    @NotNull
    private static TextRange limitToCurrentLineAndStripWhiteSpace(@NotNull CharSequence text, int cursor, @NotNull TextRange range2) {
        int subsequenceOffset = range2.getStartOffset();
        CharSequenceSubSequence rangeText = new CharSequenceSubSequence(text, subsequenceOffset, range2.getEndOffset());
        int start2 = CharArrayUtil.shiftBackwardUntil((CharSequence)rangeText, (int)(cursor - subsequenceOffset), (String)"\n\r") + 1;
        int end = CharArrayUtil.shiftForwardUntil((CharSequence)rangeText, (int)(cursor - subsequenceOffset), (String)"\n\r");
        start2 = CharArrayUtil.shiftForward((CharSequence)rangeText, (int)start2, (int)(cursor - subsequenceOffset), (String)" \t");
        end = CharArrayUtil.shiftBackward((CharSequence)rangeText, (int)(cursor - subsequenceOffset), (int)(end - 1), (String)" \t") + 1;
        return new TextRange(subsequenceOffset + start2, subsequenceOffset + end);
    }

    private static boolean isWithinLiteral(@NotNull PsiElement e, PsiElement host) {
        return host instanceof PsiLiteralValue || SkipAutopopupInStrings.isInStringLiteral((PsiElement)e);
    }

    private static BitSet findCharEscapeLocations(@NotNull Editor editor, @NotNull CharSequence text, @NotNull TextRange range2, int indexesOffset) {
        int pos;
        HighlighterIterator iterator2 = ((EditorEx)editor).getHighlighter().createIterator(range2.getStartOffset());
        int rangeEnd = range2.getEndOffset();
        BitSet locations = new BitSet(range2.getLength());
        while (!iterator2.atEnd() && (pos = iterator2.getStart()) < rangeEnd) {
            if (text.charAt(pos) == '\\' && (pos + 1 >= rangeEnd || text.charAt(pos + 1) != '\\') && pos >= indexesOffset) {
                locations.set(pos - indexesOffset);
            }
            iterator2.advance();
        }
        return locations;
    }
}

