/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesDelegate;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public abstract class EnterBetweenBracesNoCommitDelegate
extends EnterBetweenBracesDelegate {
    @Override
    public boolean bracesAreInTheSameElement(@NotNull PsiFile file2, @NotNull Editor editor, int lBraceOffset, int rBraceOffset) {
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)editor, lBraceOffset + 1);
        while (!it.atEnd() && it.getStart() < rBraceOffset) {
            it.advance();
            if (it.getStart() != rBraceOffset) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isInComment(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)editor, offset);
        return !it.atEnd() && this.isCommentType(it.getTokenType());
    }

    public abstract boolean isCommentType(IElementType var1);

    @Override
    protected void formatAtOffset(@NotNull PsiFile file2, @NotNull Editor editor, int offset, Language language) {
        EnterHandler.adjustLineIndentNoCommit(language, editor.getDocument(), editor, offset);
    }

    @NotNull
    public static HighlighterIterator createBeforeIterator(@NotNull EditorEx editor, int caretOffset) {
        return editor.getHighlighter().createIterator(caretOffset == 0 ? 0 : caretOffset - 1);
    }
}

