/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.highlighting.BraceHighlightingHandler;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.codeInsight.highlighting.CodeBlockSupportHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MatchBraceAction
extends EditorAction {
    public MatchBraceAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static void moveCaret(Editor editor, Caret caret, int offset) {
        caret.removeSelection();
        caret.moveToOffset(offset);
        EditorModificationUtil.scrollToCaret((Editor)editor);
    }

    private static class MyHandler
    extends EditorActionHandler {
        MyHandler() {
            super(true);
        }

        public void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (file2 == null) {
                return;
            }
            int targetOffset = MyHandler.getClosestTargetOffset(editor, file2);
            if (targetOffset > -1) {
                MatchBraceAction.moveCaret(editor, editor.getCaretModel().getCurrentCaret(), targetOffset);
            }
        }

        private static int getClosestTargetOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
            int caretOffset;
            int offsetFromBraceMatcher = MyHandler.getOffsetFromBraceMatcher(editor, file2);
            TextRange rangeFromCodeBlockSupport = CodeBlockSupportHandler.findCodeBlockRange(editor, file2);
            if (rangeFromCodeBlockSupport.isEmpty() || rangeFromCodeBlockSupport.contains(offsetFromBraceMatcher)) {
                return offsetFromBraceMatcher;
            }
            EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
            HighlighterIterator iterator2 = highlighter.createIterator(caretOffset = editor.getCaretModel().getOffset());
            if (iterator2.atEnd() || iterator2.getEnd() == rangeFromCodeBlockSupport.getEndOffset() || caretOffset > 0 && highlighter.createIterator(caretOffset - 1).getEnd() == rangeFromCodeBlockSupport.getEndOffset()) {
                return rangeFromCodeBlockSupport.getStartOffset();
            }
            return rangeFromCodeBlockSupport.getEndOffset();
        }

        private static int getOffsetFromBraceMatcher(@NotNull Editor editor, @NotNull PsiFile file2) {
            BraceMatchingUtil.BraceHighlightingAndNavigationContext matchingContext = BraceMatchingUtil.computeHighlightingAndNavigationContext(editor, file2);
            return matchingContext != null ? matchingContext.navigationOffset : MyHandler.tryFindPreviousUnclosedOpeningBraceOffset(editor, file2);
        }

        private static int tryFindPreviousUnclosedOpeningBraceOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
            FileType fileType;
            EditorHighlighter highlighter = BraceHighlightingHandler.getLazyParsableHighlighterIfAny(file2.getProject(), editor, file2);
            CharSequence text = editor.getDocument().getCharsSequence();
            HighlighterIterator iterator2 = highlighter.createIterator(editor.getCaretModel().getOffset());
            FileType fileType2 = fileType = iterator2.atEnd() ? null : PsiUtilBase.getPsiFileAtOffset((PsiFile)file2, (int)iterator2.getStart()).getFileType();
            if (fileType == null) {
                return -1;
            }
            int unopenedBraces = 0;
            while (true) {
                if (BraceMatchingUtil.isRBraceToken(iterator2, text, fileType)) {
                    ++unopenedBraces;
                } else if (BraceMatchingUtil.isLBraceToken(iterator2, text, fileType)) {
                    --unopenedBraces;
                }
                if (unopenedBraces < 0) {
                    return iterator2.getStart();
                }
                if (iterator2.getStart() == 0) {
                    return -1;
                }
                iterator2.retreat();
            }
        }
    }
}

