/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleRenderedDocPresentationAction
extends EditorAction {
    public ToggleRenderedDocPresentationAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorActionHandler {
        private Handler() {
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            return Handler.getItem(editor) != null;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            DocRenderItem item = Handler.getItem(editor);
            if (item != null) {
                item.toggle(null);
            }
        }

        private static DocRenderItem getItem(@NotNull Editor editor) {
            return DocRenderItem.getItemAroundOffset(editor, editor.getCaretModel().getOffset());
        }
    }
}

