/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.documentation.render.DocRenderDummyLineMarkerProvider;
import com.intellij.codeInsight.documentation.render.DocRenderItem;
import com.intellij.codeInsight.documentation.render.DocRenderManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocRenderPassFactory
implements TextEditorHighlightingPassFactoryRegistrar,
TextEditorHighlightingPassFactory,
DumbAware {
    private static final Logger LOG = Logger.getInstance(DocRenderPassFactory.class);
    private static final Key<Long> MODIFICATION_STAMP = Key.create((String)"doc.render.modification.stamp");
    private static final Key<Boolean> RESET_TO_DEFAULT = Key.create((String)"doc.render.reset.to.default");
    private static final Key<Boolean> ICONS_ENABLED = Key.create((String)"doc.render.icons.enabled");

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.AFTER, 1, false, false);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        long current2 = PsiModificationTracker.SERVICE.getInstance((Project)file2.getProject()).getModificationCount();
        boolean iconsEnabled = DocRenderDummyLineMarkerProvider.isGutterIconEnabled();
        Long existing = (Long)editor.getUserData(MODIFICATION_STAMP);
        Boolean iconsWereEnabled = (Boolean)editor.getUserData(ICONS_ENABLED);
        return editor.getProject() == null || existing != null && existing == current2 && iconsWereEnabled != null && iconsWereEnabled == iconsEnabled ? null : new DocRenderPass(editor, file2);
    }

    static void forceRefreshOnNextPass(@NotNull Editor editor) {
        editor.putUserData(MODIFICATION_STAMP, null);
        editor.putUserData(RESET_TO_DEFAULT, (Object)Boolean.TRUE);
    }

    @NotNull
    public static Items calculateItemsToRender(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        boolean enabled = DocRenderManager.isDocRenderingEnabled(editor);
        Document document = editor.getDocument();
        Items items = new Items();
        DocumentationManager.getProviderFromElement((PsiElement)psiFile).collectDocComments(psiFile, comment -> {
            TextRange range2 = comment.getTextRange();
            if (range2 != null && DocRenderItem.isValidRange(document, range2)) {
                String textToRender = enabled ? DocRenderPassFactory.calcText(comment) : null;
                items.addItem(new Item(range2, textToRender));
            }
        });
        return items;
    }

    @NotNull
    static String calcText(@Nullable PsiDocCommentBase comment) {
        try {
            String text = comment == null ? null : DocumentationManager.getProviderFromElement((PsiElement)comment).generateRenderedDoc(comment);
            return text == null ? CodeInsightBundle.message((String)"doc.render.not.available.text", (Object[])new Object[0]) : DocRenderPassFactory.preProcess(text);
        }
        catch (IndexNotReadyException e) {
            LOG.warn((Throwable)e);
            return CodeInsightBundle.message((String)"doc.render.dumb.mode.text", (Object[])new Object[0]);
        }
    }

    private static String preProcess(String text) {
        return DocumentationComponent.addExternalLinksIcon(text);
    }

    public static void applyItemsToRender(@NotNull Editor editor, @NotNull Project project, @NotNull Items items, boolean collapseNewRegions) {
        editor.putUserData(MODIFICATION_STAMP, (Object)PsiModificationTracker.SERVICE.getInstance((Project)project).getModificationCount());
        editor.putUserData(ICONS_ENABLED, (Object)DocRenderDummyLineMarkerProvider.isGutterIconEnabled());
        DocRenderItem.setItemsToEditor(editor, items, collapseNewRegions);
    }

    static class Item {
        final TextRange textRange;
        final String textToRender;

        private Item(@NotNull TextRange textRange, @Nullable String textToRender) {
            this.textRange = textRange;
            this.textToRender = textToRender;
        }
    }

    public static class Items
    implements Iterable<Item> {
        private final Map<TextRange, Item> myItems = new LinkedHashMap<TextRange, Item>();

        boolean isEmpty() {
            return this.myItems.isEmpty();
        }

        private void addItem(@NotNull Item item) {
            this.myItems.put(item.textRange, item);
        }

        @Nullable
        Item removeItem(@NotNull Segment textRange) {
            return this.myItems.remove(TextRange.create((Segment)textRange));
        }

        @Override
        @NotNull
        public Iterator<Item> iterator() {
            return this.myItems.values().iterator();
        }
    }

    private static class DocRenderPass
    extends EditorBoundHighlightingPass
    implements DumbAware {
        private Items items;

        DocRenderPass(@NotNull Editor editor, @NotNull PsiFile psiFile) {
            super(editor, psiFile, false);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            this.items = DocRenderPassFactory.calculateItemsToRender(this.myEditor, this.myFile);
        }

        @Override
        public void doApplyInformationToEditor() {
            boolean resetToDefault = this.myEditor.getUserData(RESET_TO_DEFAULT) != null;
            this.myEditor.putUserData(RESET_TO_DEFAULT, null);
            DocRenderPassFactory.applyItemsToRender(this.myEditor, this.myProject, this.items, resetToDefault && DocRenderManager.isDocRenderingEnabled(this.myEditor));
        }
    }
}

