/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation.render;

import com.intellij.diagnostic.VMOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.NotNull;

abstract class AbstractDocRenderMemoryManager<T> {
    private static final Logger LOG = Logger.getInstance(AbstractDocRenderMemoryManager.class);
    private final LinkedHashMap<T, Integer> myNotPaintedCache = new LinkedHashMap();
    private final LinkedHashMap<T, Integer> myPaintedCache = new LinkedHashMap();
    private final int myCacheSizeLimitKb;
    private int myTotalSize;

    AbstractDocRenderMemoryManager(@NotNull String sizeRegistryKey) {
        int memorySizeMb = 750;
        try {
            memorySizeMb = VMOptions.readOption(VMOptions.MemoryKind.HEAP, true);
        }
        catch (Throwable e) {
            LOG.error("Failed to get Xmx", e);
        }
        int cacheSize = 10000;
        try {
            cacheSize = Math.max(cacheSize, (int)((double)(memorySizeMb * 1024) * Registry.get((String)sizeRegistryKey).asDouble()));
        }
        catch (Throwable e) {
            LOG.error("Error calculating cache size limit", e);
        }
        this.myCacheSizeLimitKb = cacheSize;
        LOG.debug("Cache size: " + this.myCacheSizeLimitKb + "kB");
    }

    synchronized void register(@NotNull T object, int sizeKb) {
        T toRemove2;
        this.unregister(object);
        this.myNotPaintedCache.put(object, sizeKb);
        this.myTotalSize += sizeKb;
        while (this.myNotPaintedCache.size() > 1 && this.myTotalSize > this.myCacheSizeLimitKb) {
            toRemove2 = this.myNotPaintedCache.keySet().iterator().next();
            this.destroy(toRemove2);
            assert (!this.myNotPaintedCache.containsKey(toRemove2));
        }
        while (!this.myPaintedCache.isEmpty() && this.myTotalSize > this.myCacheSizeLimitKb) {
            toRemove2 = this.myPaintedCache.keySet().iterator().next();
            this.destroy(toRemove2);
            assert (!this.myPaintedCache.containsKey(toRemove2));
        }
    }

    synchronized void unregister(@NotNull T object) {
        Integer oldSize = (Integer)this.myNotPaintedCache.remove(object);
        if (oldSize != null) {
            this.myTotalSize -= oldSize.intValue();
        }
        if ((oldSize = (Integer)this.myPaintedCache.remove(object)) != null) {
            this.myTotalSize -= oldSize.intValue();
        }
    }

    synchronized void notifyPainted(@NotNull T object) {
        Integer size = (Integer)this.myNotPaintedCache.remove(object);
        if (size == null) {
            size = (Integer)this.myPaintedCache.remove(object);
        }
        if (size != null) {
            this.myPaintedCache.put(object, size);
        }
    }

    abstract void destroy(@NotNull T var1);
}

