/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.documentation;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.FontSize;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.reference.SoftReference;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.lang.ref.WeakReference;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public final class DocFontSizePopup {
    private static WeakReference<JSlider> ourCurrentSlider;

    public static void show(final @NotNull Runnable changeCallback, @NotNull Component parentComponent) {
        final JSlider slider = new JSlider(0, 0, FontSize.values().length - 1, 3);
        slider.setOpaque(true);
        slider.setMinorTickSpacing(1);
        slider.setPaintTicks(true);
        slider.setPaintTrack(true);
        slider.setSnapToTicks(true);
        UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
        DocFontSizePopup.updateSliderPosition(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DocumentationComponent.setQuickDocFontSize(FontSize.values()[slider.getValue()]);
                changeCallback.run();
            }
        });
        ourCurrentSlider = new WeakReference<JSlider>(slider);
        JPanel panel2 = new JPanel(new FlowLayout(2, 3, 0));
        panel2.setOpaque(true);
        panel2.add(new JLabel(ApplicationBundle.message((String)"label.font.size", (Object[])new Object[0])));
        panel2.add(slider);
        panel2.setBorder(BorderFactory.createLineBorder(JBColor.border(), 1));
        JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)panel2, (JComponent)slider).createPopup();
        Point location = MouseInfo.getPointerInfo().getLocation();
        popup2.show(new RelativePoint(new Point(location.x - panel2.getPreferredSize().width / 2, location.y - panel2.getPreferredSize().height / 2)).getPointOn(parentComponent));
    }

    public static void update() {
        JSlider slider = (JSlider)SoftReference.dereference(ourCurrentSlider);
        if (slider != null && slider.isShowing()) {
            DocFontSizePopup.updateSliderPosition(slider);
        }
    }

    private static void updateSliderPosition(@NotNull JSlider slider) {
        slider.setValue(DocumentationComponent.getQuickDocFontSize().ordinal());
    }
}

