/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

class RenameFileReferenceIntentionAction
implements IntentionAction,
LocalQuickFix {
    private final String myExistingElementName;
    private final FileReference myFileReference;

    RenameFileReferenceIntentionAction(String existingElementName, FileReference fileReference) {
        this.myExistingElementName = existingElementName;
        this.myFileReference = fileReference;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"rename.file.reference.text", (Object[])new Object[]{this.myExistingElementName});
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"rename.file.reference.family", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        if (this.isAvailable(project, null, null)) {
            WriteCommandAction.writeCommandAction((Project)project).run(() -> this.invoke(project, null, descriptor2.getPsiElement().getContainingFile()));
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.myFileReference.handleElementRename(this.myExistingElementName);
    }

    public boolean startInWriteAction() {
        return true;
    }
}

