/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.impl.quickfix.RenameFileFix;
import com.intellij.codeInsight.daemon.quickFix.CreateDirectoryPathFix;
import com.intellij.codeInsight.daemon.quickFix.CreateFilePathFix;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.RenameFileReferenceIntentionAction;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.CreateFromTemplateActionBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileTargetContext;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileReferenceQuickFixProvider {
    private FileReferenceQuickFixProvider() {
    }

    @NotNull
    public static List<? extends LocalQuickFix> registerQuickFix(@NotNull FileReference reference2) {
        NewFileLocation location;
        FileReferenceSet fileReferenceSet = reference2.getFileReferenceSet();
        int index = reference2.getIndex();
        if (index < 0) {
            return Collections.emptyList();
        }
        String newFileName = reference2.getFileNameToCreate();
        if (newFileName.isEmpty() || newFileName.indexOf(92) != -1 || newFileName.indexOf(42) != -1 || newFileName.indexOf(63) != -1 || SystemInfo.isWindows && newFileName.indexOf(58) != -1) {
            return Collections.emptyList();
        }
        PsiElement element2 = reference2.getElement();
        PsiFile containingFile = element2.getContainingFile();
        if (fileReferenceSet.isCaseSensitive()) {
            PsiFileSystemItem psiElement;
            PsiFileSystemItem psiFileSystemItem = psiElement = containingFile == null ? null : reference2.innerSingleResolve(false, containingFile);
            if (psiElement != null) {
                String existingElementName = ((PsiNamedElement)psiElement).getName();
                RenameFileReferenceIntentionAction renameRefAction = new RenameFileReferenceIntentionAction(existingElementName, reference2);
                RenameFileFix renameFileFix = new RenameFileFix(newFileName);
                return Arrays.asList(renameRefAction, renameFileFix);
            }
        }
        if (reference2.isLast()) {
            location = FileReferenceQuickFixProvider.getNewFileLocation(reference2, newFileName, containingFile, false);
            if (location == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new MyCreateFileFix(element2, location, reference2.getNewFileTemplateName()));
        }
        location = FileReferenceQuickFixProvider.getNewFileLocation(reference2, newFileName, containingFile, true);
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateDirectoryPathFix(element2, location));
    }

    @Nullable
    public static NewFileLocation getNewFileLocation(@NotNull FileReference reference2, String newFileName, boolean isDirectory) {
        return FileReferenceQuickFixProvider.getNewFileLocation(reference2, newFileName, reference2.getElement().getContainingFile(), isDirectory);
    }

    @Nullable
    private static NewFileLocation getNewFileLocation(@NotNull FileReference reference2, String newFileName, PsiFile containingFile, boolean isDirectory) {
        @Nullable Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
        List<TargetDirectory> targetDirectories = FileReferenceQuickFixProvider.getTargets(reference2, module, newFileName, isDirectory);
        if (targetDirectories.isEmpty()) {
            return null;
        }
        return new NewFileLocation(targetDirectories, FileReferenceQuickFixProvider.getPathToReferencePart(reference2), newFileName);
    }

    @NotNull
    private static List<TargetDirectory> getTargets(@NotNull FileReference reference2, @Nullable Module module, String newFileName, boolean isDirectory) {
        List<FileTargetContext> contexts = FileReferenceQuickFixProvider.getSuitableContexts(reference2, module);
        SmartList targetDirectories = new SmartList();
        for (FileTargetContext targetContext : contexts) {
            PsiDirectory directory;
            FileType ft;
            PsiFileSystemItem context = targetContext.getFileSystemItem();
            VirtualFile virtualFile = context.getVirtualFile();
            if (virtualFile == null || !virtualFile.isValid() || !isDirectory && (ft = FileTypeManager.getInstance().getFileTypeByFileName(newFileName)) instanceof UnknownFileType || (directory = context.getManager().findDirectory(virtualFile)) == null || !FileReferenceQuickFixProvider.checkFileWriteAccess(reference2, directory, targetContext.getPathToCreate(), newFileName, isDirectory)) continue;
            if (module != null) {
                targetDirectories.add(new TargetDirectory(directory, targetContext.getPathToCreate()));
                continue;
            }
            targetDirectories.add(new TargetDirectory(directory));
        }
        return targetDirectories;
    }

    private static boolean checkFileWriteAccess(FileReference reference2, PsiDirectory targetRoot, String[] pathToCreate, String newFileName, boolean isDirectory) {
        PsiDirectory currentDirectory = targetRoot;
        for (String part : pathToCreate) {
            PsiDirectory subDirectory = currentDirectory.findSubdirectory(part);
            if (subDirectory == null) {
                return FileReferenceQuickFixProvider.checkCreateSubdirectory(currentDirectory, part);
            }
            currentDirectory = subDirectory;
        }
        if (reference2.getIndex() > 0) {
            FileReference[] references = reference2.getFileReferenceSet().getAllReferences();
            for (int i2 = 0; i2 < references.length - 1; ++i2) {
                String part = references[i2].getFileNameToCreate();
                PsiDirectory subDirectory = currentDirectory.findSubdirectory(part);
                if (subDirectory == null) {
                    return FileReferenceQuickFixProvider.checkCreateSubdirectory(currentDirectory, part);
                }
                currentDirectory = subDirectory;
            }
        }
        if (isDirectory) {
            return FileReferenceQuickFixProvider.checkCreateSubdirectory(currentDirectory, newFileName);
        }
        return FileReferenceQuickFixProvider.checkCreateFile(currentDirectory, newFileName);
    }

    private static boolean checkCreateFile(PsiDirectory directory, String newFileName) {
        try {
            directory.checkCreateFile(newFileName);
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
        return true;
    }

    private static boolean checkCreateSubdirectory(PsiDirectory directory, String part) {
        try {
            directory.checkCreateSubdirectory(part);
        }
        catch (IncorrectOperationException ex) {
            return false;
        }
        return true;
    }

    private static String @NotNull [] getPathToReferencePart(FileReference reference2) {
        if (reference2.getIndex() == 0) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        FileReference[] references = reference2.getFileReferenceSet().getAllReferences();
        String[] path = new String[reference2.getIndex()];
        for (int i2 = 0; i2 < reference2.getIndex(); ++i2) {
            path[i2] = references[i2].getFileNameToCreate();
        }
        return path;
    }

    @NotNull
    private static List<FileTargetContext> getSuitableContexts(@NotNull FileReference reference2, @Nullable Module module) {
        FileReferenceSet fileReferenceSet = reference2.getFileReferenceSet();
        Collection<FileTargetContext> targetContexts = fileReferenceSet.getTargetContexts();
        if (targetContexts.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList contexts = new SmartList();
        for (FileTargetContext targetContext : targetContexts) {
            PsiFileSystemItem fsContext = targetContext.getFileSystemItem();
            if (module != null) {
                if (module != FileReferenceQuickFixProvider.getModuleForContext(fsContext)) continue;
                contexts.add((Object)targetContext);
                continue;
            }
            contexts.add((Object)targetContext);
        }
        if (contexts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            return Collections.singletonList(targetContexts.iterator().next());
        }
        return contexts;
    }

    @Nullable
    private static Module getModuleForContext(@NotNull PsiFileSystemItem context) {
        VirtualFile file2 = context.getVirtualFile();
        return file2 != null ? ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)context.getProject()) : null;
    }

    private static class MyCreateFileFix
    extends CreateFilePathFix {
        private final String myNewFileTemplateName;

        private MyCreateFileFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, @Nullable String newFileTemplateName) {
            super(psiElement, newFileLocation);
            this.myNewFileTemplateName = newFileTemplateName;
        }

        @Override
        protected String getFileText() {
            Project project;
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            if (this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project = this.getStartElement().getProject()))) != null) {
                try {
                    return template.getText(fileTemplateManager.getDefaultProperties());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return super.getFileText();
        }

        private FileTemplate findTemplate(FileTemplateManager fileTemplateManager) {
            FileTemplate template = fileTemplateManager.getTemplate(this.myNewFileTemplateName);
            if (template == null) {
                template = fileTemplateManager.findInternalTemplate(this.myNewFileTemplateName);
            }
            if (template == null) {
                for (FileTemplate fileTemplate : fileTemplateManager.getAllJ2eeTemplates()) {
                    String fileTemplateWithExtension = fileTemplate.getName() + '.' + fileTemplate.getExtension();
                    if (!fileTemplateWithExtension.equals(this.myNewFileTemplateName)) continue;
                    return fileTemplate;
                }
            }
            return template;
        }

        @Override
        protected void openFile(@NotNull Project project, PsiDirectory directory, PsiFile newFile, String text) {
            FileTemplateManager fileTemplateManager;
            FileTemplate template;
            super.openFile(project, directory, newFile, text);
            if (this.myNewFileTemplateName != null && (template = this.findTemplate(fileTemplateManager = FileTemplateManager.getInstance(project))) != null && template.isLiveTemplateEnabled()) {
                CreateFromTemplateActionBase.startLiveTemplate(newFile);
            }
        }
    }
}

