/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInsight.daemon.quickFix.TargetDirectory;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.IconUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class AbstractCreateFileFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final int REFRESH_INTERVAL = 1000;
    protected static final String CURRENT_DIRECTORY_REF = ".";
    protected static final String PARENT_DIRECTORY_REF = "..";
    protected final String myNewFileName;
    protected final List<TargetDirectory> myDirectories;
    protected final String[] mySubPath;
    @PropertyKey(resourceBundle="messages.CodeInsightBundle")
    @NotNull
    protected final String myKey;
    protected boolean myIsAvailable;
    protected long myIsAvailableTimeStamp;

    protected AbstractCreateFileFix(@Nullable PsiElement element2, @NotNull NewFileLocation newFileLocation, @NotNull String fixLocaleKey) {
        super(element2);
        this.myNewFileName = newFileLocation.getNewFileName();
        this.myDirectories = newFileLocation.getDirectories();
        this.mySubPath = newFileLocation.getSubPath();
        this.myKey = fixLocaleKey;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        long current2 = System.currentTimeMillis();
        if ((ApplicationManager.getApplication().isUnitTestMode() || current2 - this.myIsAvailableTimeStamp > 1000L) && this.myDirectories.size() == 1) {
            PsiDirectory myDirectory = this.myDirectories.get(0).getDirectory();
            this.myIsAvailable &= myDirectory != null && myDirectory.getVirtualFile().findChild(this.myNewFileName) == null;
            this.myIsAvailableTimeStamp = current2;
        }
        return this.myIsAvailable;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file2, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (this.isAvailable(project, null, file2)) {
            if (this.myDirectories.size() == 1) {
                this.apply(this.myStartElement.getProject(), this.myDirectories.get(0), editor);
            } else {
                List directories = ContainerUtil.filter(this.myDirectories, d -> d.getDirectory() != null);
                if (directories.isEmpty()) {
                    return;
                }
                if (editor == null || ApplicationManager.getApplication().isUnitTestMode()) {
                    this.apply(this.myStartElement.getProject(), (TargetDirectory)directories.get(0), editor);
                } else {
                    this.showOptionsPopup(project, editor, directories);
                }
            }
        }
    }

    private void apply(@NotNull Project project, @NotNull TargetDirectory directory, @Nullable Editor editor) {
        this.myIsAvailableTimeStamp = 0L;
        PsiDirectory currentDirectory = directory.getDirectory();
        if (currentDirectory == null) {
            return;
        }
        try {
            for (String pathPart : directory.getPathToCreate()) {
                currentDirectory = AbstractCreateFileFix.findOrCreateSubdirectory(currentDirectory, pathPart);
            }
            for (String pathPart : this.mySubPath) {
                currentDirectory = AbstractCreateFileFix.findOrCreateSubdirectory(currentDirectory, pathPart);
            }
            if (currentDirectory == null) {
                if (editor != null) {
                    HintManager hintManager = HintManager.getInstance();
                    hintManager.showErrorHint(editor, CodeInsightBundle.message((String)"create.file.incorrect.path.hint", (Object[])new Object[]{this.myNewFileName}));
                }
                return;
            }
            this.apply(project, currentDirectory, editor);
        }
        catch (IncorrectOperationException e) {
            this.myIsAvailable = false;
        }
    }

    protected abstract void apply(@NotNull Project var1, @NotNull PsiDirectory var2, @Nullable Editor var3) throws IncorrectOperationException;

    @Nullable
    private static PsiDirectory findOrCreateSubdirectory(@Nullable PsiDirectory directory, @NotNull String subDirectoryName) {
        if (directory == null) {
            return null;
        }
        if (CURRENT_DIRECTORY_REF.equals(subDirectoryName)) {
            return directory;
        }
        if (PARENT_DIRECTORY_REF.equals(subDirectoryName)) {
            return directory.getParentDirectory();
        }
        PsiDirectory existingDirectory = directory.findSubdirectory(subDirectoryName);
        if (existingDirectory == null) {
            return directory.createSubdirectory(subDirectoryName);
        }
        return existingDirectory;
    }

    private void showOptionsPopup(final @NotNull Project project, final @NotNull Editor editor, List<TargetDirectory> directories) {
        List<TargetDirectoryListItem> items = AbstractCreateFileFix.getTargetDirectoryListItems(directories);
        String filePath = this.myNewFileName;
        if (this.mySubPath.length > 0) {
            filePath = FileUtil.toSystemDependentName((String)(StringUtil.join((String[])this.mySubPath, (String)"/") + '/' + this.myNewFileName));
        }
        SimpleListCellRenderer renderer = SimpleListCellRenderer.create((label2, value2, index) -> {
            label2.setIcon(value2.getIcon());
            label2.setText(((TargetDirectoryListItem)value2).getPresentablePath());
        });
        JBPopupFactory.getInstance().createPopupChooserBuilder(items).setSelectionMode(0).setTitle(CodeInsightBundle.message((String)this.myKey, (Object[])new Object[]{filePath})).setMovable(false).setResizable(false).setRequestFocus(true).setRenderer((ListCellRenderer)renderer).setNamerForFiltering(item -> ((TargetDirectoryListItem)item).getPresentablePath()).setItemChosenCallback(chosenValue -> WriteCommandAction.writeCommandAction((Project)project).withName(CodeInsightBundle.message((String)"create.file.text", (Object[])new Object[]{this.myNewFileName})).run(() -> this.apply(project, ((TargetDirectoryListItem)chosenValue).getTarget(), editor))).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
                if (file2 != null) {
                    DaemonCodeAnalyzer.getInstance((Project)project).restart(file2);
                }
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    private static List<TargetDirectoryListItem> getTargetDirectoryListItems(List<TargetDirectory> directories) {
        return ContainerUtil.map(directories, targetDirectory -> {
            PsiDirectory d = targetDirectory.getDirectory();
            assert (d != null) : "Invalid PsiDirectory instances found";
            String presentablePath = AbstractCreateFileFix.getPresentableContentRootPath(d, targetDirectory.getPathToCreate());
            Icon icon2 = AbstractCreateFileFix.getContentRootIcon(d);
            return new TargetDirectoryListItem((TargetDirectory)targetDirectory, icon2, presentablePath);
        });
    }

    @NotNull
    private static Icon getContentRootIcon(@NotNull PsiDirectory directory) {
        VirtualFile file2 = directory.getVirtualFile();
        Project project = directory.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)project);
        SourceFolder sourceFolder = projectFileIndex.getSourceFolder(file2);
        if (sourceFolder != null && sourceFolder.getFile() != null) {
            return IconUtil.getIcon((VirtualFile)sourceFolder.getFile(), (int)0, (Project)project);
        }
        return IconUtil.getIcon((VirtualFile)file2, (int)0, (Project)project);
    }

    @NotNull
    private static String getPresentableContentRootPath(@NotNull PsiDirectory directory, String @NotNull [] pathToCreate) {
        VirtualFile f = directory.getVirtualFile();
        Project project = directory.getProject();
        String path = f.getPath();
        if (pathToCreate.length > 0) {
            path = path + '/' + StringUtil.join((String[])pathToCreate, (String)"/");
        }
        String presentablePath = f.getFileSystem().extractPresentableUrl(path);
        return ProjectUtilCore.displayUrlRelativeToProject((VirtualFile)f, (String)presentablePath, (Project)project, (boolean)true, (boolean)true);
    }

    protected static class TargetDirectoryListItem {
        private final TargetDirectory myTargetDirectory;
        private final Icon myIcon;
        private final String myPresentablePath;

        public TargetDirectoryListItem(@NotNull TargetDirectory targetDirectory, Icon icon2, @NotNull String presentablePath) {
            this.myTargetDirectory = targetDirectory;
            this.myIcon = icon2;
            this.myPresentablePath = presentablePath;
        }

        public Icon getIcon() {
            return this.myIcon;
        }

        private String getPresentablePath() {
            return this.myPresentablePath;
        }

        private TargetDirectory getTarget() {
            return this.myTargetDirectory;
        }
    }
}

