/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.actions;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.ContainerBasedSuppressQuickFix;
import com.intellij.codeInspection.InjectionAwareSuppressQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThreeState;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBatchSuppressByNoInspectionCommentFix
implements ContainerBasedSuppressQuickFix,
InjectionAwareSuppressQuickFix,
Iconable {
    @NotNull
    protected final String myID;
    private final boolean myReplaceOtherSuppressionIds;
    private ThreeState myShouldBeAppliedToInjectionHost = ThreeState.UNSURE;
    private String myText = "";

    @Nullable
    public abstract PsiElement getContainer(PsiElement var1);

    public AbstractBatchSuppressByNoInspectionCommentFix(@NotNull String ID2, boolean replaceOtherSuppressionIds) {
        this.myID = ID2;
        this.myReplaceOtherSuppressionIds = replaceOtherSuppressionIds;
    }

    public void setShouldBeAppliedToInjectionHost(@NotNull ThreeState shouldBeAppliedToInjectionHost) {
        this.myShouldBeAppliedToInjectionHost = shouldBeAppliedToInjectionHost;
    }

    @NotNull
    public ThreeState isShouldBeAppliedToInjectionHost() {
        return this.myShouldBeAppliedToInjectionHost;
    }

    @NotNull
    public String getName() {
        return this.getText();
    }

    public Icon getIcon(int flags) {
        return AllIcons.Ide.HectorOff;
    }

    public @IntentionName @NotNull String getText() {
        return this.myText;
    }

    protected void setText(@IntentionName @NotNull String text) {
        this.myText = text;
    }

    public String toString() {
        return this.getText();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element2 = descriptor2.getStartElement();
        if (element2 == null) {
            return;
        }
        this.invoke(project, element2);
    }

    public boolean isSuppressAll() {
        return "ALL".equalsIgnoreCase(this.myID);
    }

    protected final void replaceSuppressionComment(@NotNull PsiElement comment) {
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{comment})) {
            return;
        }
        WriteAction.run(() -> SuppressionUtil.replaceSuppressionComment(comment, this.myID, this.myReplaceOtherSuppressionIds, this.getCommentLanguage(comment)));
    }

    protected void createSuppression(@NotNull Project project, @NotNull PsiElement element2, @NotNull PsiElement container2) throws IncorrectOperationException {
        SuppressionUtil.createSuppression(project, container2, this.myID, this.getCommentLanguage(element2));
    }

    @NotNull
    protected Language getCommentLanguage(@NotNull PsiElement element2) {
        return element2.getLanguage();
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
        return context.isValid() && this.getContainer(context) != null;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (!this.isAvailable(project, element2)) {
            return;
        }
        PsiElement container2 = this.getContainer(element2);
        PsiFile file2 = element2.getContainingFile();
        if (container2 == null) {
            return;
        }
        if (this.replaceSuppressionComments(container2)) {
            return;
        }
        this.createSuppression(project, element2, container2);
        UndoUtil.markPsiFileForUndo((PsiFile)file2);
    }

    protected boolean replaceSuppressionComments(PsiElement container2) {
        List<? extends PsiElement> comments = this.getCommentsFor(container2);
        if (comments != null) {
            for (PsiElement psiElement : comments) {
                if (!(psiElement instanceof PsiComment) || !SuppressionUtil.isSuppressionComment(psiElement)) continue;
                this.replaceSuppressionComment(psiElement);
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected List<? extends PsiElement> getCommentsFor(@NotNull PsiElement container2) {
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)container2);
        if (prev == null) {
            return null;
        }
        return Collections.singletonList(prev);
    }

    @NotNull
    public String getFamilyName() {
        String text = this.getText();
        return StringUtil.isEmpty((String)text) ? AnalysisBundle.message((String)"suppress.inspection.family", (Object[])new Object[0]) : text;
    }
}

