/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.WolfHighlightingPass;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class WolfPassFactory
implements TextEditorHighlightingPassFactory {
    private long myPsiModificationCount;

    WolfPassFactory() {
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        Project project = file2.getProject();
        final long psiModificationCount = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
        if (psiModificationCount == this.myPsiModificationCount) {
            return null;
        }
        return new WolfHighlightingPass(project, editor.getDocument(), file2){

            @Override
            protected void applyInformationWithProgress() {
                super.applyInformationWithProgress();
                WolfPassFactory.this.myPsiModificationCount = psiModificationCount;
            }
        };
    }

    static final class MyRegistrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        MyRegistrar() {
        }

        @Override
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new WolfPassFactory(), new int[]{4}, new int[]{7}, false, 9);
        }
    }
}

