/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;

public class TogglePopupHintsAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TogglePopupHintsAction.class);

    private static PsiFile getTargetFile(@NotNull DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        VirtualFile[] files2 = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        if (files2.length == 0) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(files2[0]);
        LOG.assertTrue(psiFile != null);
        return psiFile;
    }

    public void update(@NotNull AnActionEvent e) {
        PsiFile psiFile = TogglePopupHintsAction.getTargetFile(e.getDataContext());
        e.getPresentation().setEnabled(psiFile != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile = TogglePopupHintsAction.getTargetFile(e.getDataContext());
        LOG.assertTrue(psiFile != null);
        Project project = e.getProject();
        LOG.assertTrue(project != null);
        DaemonCodeAnalyzer codeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
        codeAnalyzer.setImportHintsEnabled(psiFile, !codeAnalyzer.isImportHintsEnabled(psiFile));
    }
}

