/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.ProjectSdkSetupValidator;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.impl.UnknownSdkEditorNotification;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import org.jetbrains.annotations.NotNull;

public final class SdkSetupNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel>
implements DumbAware {
    public static final Key<EditorNotificationPanel> KEY = Key.create((String)"SdkSetupNotification");

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        if (!UnknownSdkEditorNotification.getInstance(project).allowProjectSdkNotifications()) {
            return null;
        }
        for (ProjectSdkSetupValidator validator : ProjectSdkSetupValidator.EP_NAME.getExtensionList()) {
            if (!validator.isApplicableFor(project, file2)) continue;
            String errorMessage = validator.getErrorMessage(project, file2);
            return errorMessage != null ? SdkSetupNotificationProvider.createPanel(errorMessage, validator.getFixHandler(project, file2)) : null;
        }
        return null;
    }

    @NotNull
    private static EditorNotificationPanel createPanel(@NotNull String message, @NotNull EditorNotificationPanel.ActionHandler fix) {
        EditorNotificationPanel panel2 = new EditorNotificationPanel();
        panel2.setText(message);
        panel2.createActionLabel(ProjectBundle.message((String)"project.sdk.setup", (Object[])new Object[0]), fix, true);
        return panel2;
    }
}

