/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.find.FindUtil;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ListComponentUpdater;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.usages.UsageView;
import com.intellij.util.Consumer;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiElementListNavigator {
    private PsiElementListNavigator() {
    }

    public static <T extends NavigatablePsiElement> void openTargets(MouseEvent e, T[] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer<? super T> listRenderer) {
        PsiElementListNavigator.openTargets((MouseEvent)e, targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)null);
    }

    public static <T extends NavigatablePsiElement> void openTargets(MouseEvent e, T[] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask);
        if (popup2 != null) {
            RelativePoint point = new RelativePoint(e);
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.show(point), listUpdaterTask);
            } else {
                popup2.show(point);
            }
        }
    }

    public static <T extends NavigatablePsiElement> void openTargets(Editor e, T[] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer<? super T> listRenderer) {
        PsiElementListNavigator.openTargets((Editor)e, targets2, (String)title, (String)findUsagesTitle, listRenderer, null);
    }

    public static <T extends NavigatablePsiElement> void openTargets(Editor e, T[] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        JBPopup popup2 = PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask);
        if (popup2 != null) {
            if (listUpdaterTask != null) {
                PsiElementListNavigator.runActionAndListUpdaterTask(() -> popup2.showInBestPositionFor(e), listUpdaterTask);
            } else {
                popup2.showInBestPositionFor(e);
            }
        }
    }

    private static void runActionAndListUpdaterTask(@NotNull Runnable action2, @NotNull BackgroundUpdaterTask listUpdaterTask) {
        action2.run();
        ProgressManager.getInstance().run((Task)listUpdaterTask);
    }

    @Nullable
    public static <T extends NavigatablePsiElement> JBPopup navigateOrCreatePopup(T[] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask) {
        return PsiElementListNavigator.navigateOrCreatePopup(targets2, (String)title, (String)findUsagesTitle, listRenderer, (BackgroundUpdaterTask)listUpdaterTask, selectedElements -> {
            for (NavigatablePsiElement element2 : selectedElements) {
                PsiElement selected2 = (PsiElement)element2;
                if (!selected2.isValid()) continue;
                ((NavigatablePsiElement)selected2).navigate(true);
            }
        });
    }

    @Nullable
    public static <T extends NavigatablePsiElement> JBPopup navigateOrCreatePopup(T @NotNull [] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer<? super T> listRenderer, @Nullable BackgroundUpdaterTask listUpdaterTask, @NotNull Consumer<? super T[]> consumer) {
        return new NavigateOrPopupHelper(targets2, title).setFindUsagesTitle(findUsagesTitle).setListRenderer(listRenderer).setListUpdaterTask(listUpdaterTask).setTargetsConsumer(consumer).navigateOrCreatePopup();
    }

    @Deprecated
    public static void openTargets(MouseEvent e, NavigatablePsiElement[] targets2, @Nls String title, @Nls String findUsagesTitle, ListCellRenderer listRenderer, @Nullable ListBackgroundUpdaterTask listUpdaterTask) {
        PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])targets2, (String)title, (String)findUsagesTitle, (ListCellRenderer)listRenderer, (BackgroundUpdaterTask)listUpdaterTask);
    }

    public static class NavigateOrPopupHelper<T extends NavigatablePsiElement> {
        private final T @NotNull [] myTargets;
        private final String myTitle;
        private Consumer<? super T[]> myTargetsConsumer;
        @Nullable
        private String myFindUsagesTitle;
        @Nullable
        private ListCellRenderer<? super T> myListRenderer;
        @Nullable
        private BackgroundUpdaterTask myListUpdaterTask;
        @Nullable
        private Project myProject;

        public NavigateOrPopupHelper(T @NotNull [] targets2, @Nls String title) {
            this.myTargets = targets2;
            this.myTitle = title;
            this.myTargetsConsumer = selectedElements -> {
                for (NavigatablePsiElement element2 : selectedElements) {
                    if (!element2.isValid()) continue;
                    element2.navigate(true);
                }
            };
        }

        @NotNull
        public NavigateOrPopupHelper setFindUsagesTitle(@Nls @Nullable String findUsagesTitle) {
            this.myFindUsagesTitle = findUsagesTitle;
            return this;
        }

        @NotNull
        public NavigateOrPopupHelper setListRenderer(@Nullable ListCellRenderer<? super NavigatablePsiElement> listRenderer) {
            this.myListRenderer = listRenderer;
            return this;
        }

        @NotNull
        public NavigateOrPopupHelper setListUpdaterTask(@Nullable BackgroundUpdaterTask listUpdaterTask) {
            this.myListUpdaterTask = listUpdaterTask;
            return this;
        }

        @NotNull
        public NavigateOrPopupHelper setTargetsConsumer(@NotNull Consumer<? super NavigatablePsiElement[]> targetsConsumer) {
            this.myTargetsConsumer = targetsConsumer;
            return this;
        }

        @NotNull
        public NavigateOrPopupHelper setProject(@Nullable Project project) {
            this.myProject = project;
            return this;
        }

        @Nullable
        public final JBPopup navigateOrCreatePopup() {
            if (this.myTargets.length == 0) {
                if (!this.allowEmptyTargets()) {
                    return null;
                }
                if (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished()) {
                    return null;
                }
            }
            if (this.myTargets.length == 1 && (this.myListUpdaterTask == null || this.myListUpdaterTask.isFinished())) {
                this.myTargetsConsumer.consume(this.myTargets);
                return null;
            }
            List<T> initialTargetsList = Arrays.asList(this.myTargets);
            final Ref updatedTargetsList = Ref.create(this.myTargets);
            IPopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(initialTargetsList);
            this.afterPopupBuilderCreated(builder2);
            if (this.myListRenderer instanceof PsiElementListCellRenderer) {
                ((PsiElementListCellRenderer)this.myListRenderer).installSpeedSearch(builder2);
            }
            IPopupChooserBuilder popupChooserBuilder = builder2.setTitle(this.myTitle).setMovable(true).setFont(EditorUtil.getEditorFont()).setRenderer(this.myListRenderer).withHintUpdateSupply().setResizable(true).setItemsChosenCallback(elements2 -> this.myTargetsConsumer.consume((Object)elements2.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY))).setCancelCallback(() -> {
                if (this.myListUpdaterTask != null) {
                    this.myListUpdaterTask.cancelTask();
                }
                return true;
            });
            Ref usageView = new Ref();
            if (this.myFindUsagesTitle != null) {
                popupChooserBuilder = popupChooserBuilder.setCouldPin(popup2 -> {
                    usageView.set((Object)FindUtil.showInUsageView(null, (PsiElement[])updatedTargetsList.get(), this.myFindUsagesTitle, this.getProject()));
                    popup2.cancel();
                    return false;
                });
            }
            JBPopup popup3 = popupChooserBuilder.createPopup();
            if (builder2 instanceof PopupChooserBuilder) {
                final JBList list2 = (JBList)((PopupChooserBuilder)builder2).getChooserComponent();
                list2.setTransferHandler(new TransferHandler(){

                    @Override
                    protected Transferable createTransferable(JComponent c) {
                        Object[] selectedValues = list2.getSelectedValues();
                        PsiElement[] copy2 = new PsiElement[selectedValues.length];
                        for (int i2 = 0; i2 < selectedValues.length; ++i2) {
                            copy2[i2] = (PsiElement)selectedValues[i2];
                        }
                        return new PsiCopyPasteManager.MyTransferable(copy2);
                    }

                    @Override
                    public int getSourceActions(JComponent c) {
                        return 1;
                    }
                });
                JScrollPane pane2 = ((PopupChooserBuilder)builder2).getScrollPane();
                pane2.setBorder(null);
                pane2.setViewportBorder(null);
            }
            if (this.myListUpdaterTask != null) {
                final ListComponentUpdater popupUpdater = builder2.getBackgroundUpdater();
                this.myListUpdaterTask.init(popup3, new ListComponentUpdater(){

                    public void replaceModel(@NotNull List<? extends PsiElement> data2) {
                        updatedTargetsList.set((Object)data2.toArray(NavigatablePsiElement.EMPTY_NAVIGATABLE_ELEMENT_ARRAY));
                        popupUpdater.replaceModel(data2);
                    }

                    public void paintBusy(boolean paintBusy) {
                        popupUpdater.paintBusy(paintBusy);
                    }
                }, (Ref<? extends UsageView>)((Ref<UsageView>)usageView));
            }
            return popup3;
        }

        @NotNull
        private Project getProject() {
            if (this.myProject != null) {
                return this.myProject;
            }
            assert (!this.allowEmptyTargets()) : "Project was not set and cannot be taken from targets";
            return this.myTargets[0].getProject();
        }

        protected boolean allowEmptyTargets() {
            return false;
        }

        protected void afterPopupBuilderCreated(@NotNull IPopupChooserBuilder<T> builder2) {
        }
    }
}

