/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.MainHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.LocalInspectionsPass;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarImpl;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.NotNull;

public final class LocalInspectionsPassFactory
implements MainHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Logger LOG = Logger.getInstance(LocalInspectionsPassFactory.class);

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        int[] ghp = new int[]{4};
        boolean serializeCodeInsightPasses = ((TextEditorHighlightingPassRegistrarImpl)registrar).isSerializeCodeInsightPasses();
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, (int[])(serializeCodeInsightPasses ? ghp : null), serializeCodeInsightPasses ? null : ghp, true, 7);
    }

    @Override
    @NotNull
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        TextRange textRange = FileStatusMap.getDirtyTextRange(editor, 7);
        if (textRange == null) {
            return new ProgressableTextEditorHighlightingPass.EmptyPass(file2.getProject(), editor.getDocument());
        }
        ProperTextRange visibleRange = VisibleHighlightingPassFactory.calculateVisibleRange(editor);
        return new MyLocalInspectionsPass(file2, editor.getDocument(), textRange, (TextRange)visibleRange, new DefaultHighlightInfoProcessor());
    }

    @Override
    public TextEditorHighlightingPass createMainHighlightingPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        TextRange textRange = file2.getTextRange();
        LOG.assertTrue(textRange != null, (Object)("textRange is null for " + file2 + " (" + PsiUtilCore.getVirtualFile((PsiElement)file2) + ")"));
        return new MyLocalInspectionsPass(file2, document, textRange, LocalInspectionsPass.EMPTY_PRIORITY_RANGE, highlightInfoProcessor);
    }

    private static class MyLocalInspectionsPass
    extends LocalInspectionsPass {
        private MyLocalInspectionsPass(@NotNull PsiFile file2, @NotNull Document document, @NotNull TextRange textRange, @NotNull TextRange visibleRange, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
            super(file2, document, textRange.getStartOffset(), textRange.getEndOffset(), visibleRange, true, highlightInfoProcessor, true);
        }

        @Override
        protected boolean isAcceptableLocalTool(@NotNull LocalInspectionToolWrapper wrapper2) {
            return !wrapper2.runForWholeFile();
        }
    }
}

