/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HintRenderer$Companion$WhenMappings;
import com.intellij.codeInsight.hints.HintWidthAdjustment;
import com.intellij.ide.ui.AntialiasingType;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FocusModeModel;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Segment;
import com.intellij.ui.paint.EffectPainter;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0005\u00a2\u0006\u0002\b\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J,\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001bH\u0016R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "getWidthAdjustment", "()Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "setWidthAdjustment", "(Lcom/intellij/codeInsight/hints/HintWidthAdjustment;)V", "calcWidthInPixels", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "doCalcWidth", "fontMetrics", "Ljava/awt/FontMetrics;", "getFontMetrics", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getFontMetrics$", "getTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "paint", "", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "textAttributes", "Companion", "intellij.platform.ide.impl"})
public class HintRenderer
implements EditorCustomElementRenderer {
    @Nullable
    private HintWidthAdjustment widthAdjustment;
    @Nullable
    private String text;
    private static final Key<Companion.MyFontMetrics> HINT_FONT_METRICS;
    private static final float BACKGROUND_ALPHA = 0.55f;
    public static final Companion Companion;

    @Nullable
    public final HintWidthAdjustment getWidthAdjustment() {
        return this.widthAdjustment;
    }

    public final void setWidthAdjustment(@Nullable HintWidthAdjustment hintWidthAdjustment) {
        this.widthAdjustment = hintWidthAdjustment;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        return Companion.calcWidthInPixels(inlay.getEditor(), this.text, this.widthAdjustment);
    }

    @Nullable
    protected TextAttributes getTextAttributes(@NotNull Editor editor) {
        return editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
        TextAttributes textAttributes2;
        Editor editor = inlay.getEditor();
        if (!(editor instanceof EditorImpl)) {
            return;
        }
        Segment focusModeRange = ((EditorImpl)editor).getFocusModeRange();
        if (focusModeRange != null && (inlay.getOffset() <= focusModeRange.getStartOffset() || focusModeRange.getEndOffset() <= inlay.getOffset())) {
            textAttributes2 = (TextAttributes)editor.getUserData(FocusModeModel.FOCUS_MODE_ATTRIBUTES);
            if (textAttributes2 == null) {
                textAttributes2 = this.getTextAttributes(editor);
            }
        } else {
            textAttributes2 = this.getTextAttributes(editor);
        }
        TextAttributes attributes = textAttributes2;
        Companion.paintHint(g, (EditorImpl)editor, r, this.text, attributes, textAttributes, this.widthAdjustment);
    }

    protected final int doCalcWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
        return Companion.calcHintTextWidth(text, fontMetrics);
    }

    @JvmName(name="getFontMetrics$")
    @NotNull
    protected final /* synthetic */ Companion.MyFontMetrics getFontMetrics$(@NotNull Editor editor) {
        return Companion.getFontMetrics(editor);
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String string) {
        this.text = string;
    }

    public HintRenderer(@Nullable String text) {
        this.text = text;
    }

    static {
        Companion = new Companion(null);
        HINT_FONT_METRICS = Key.create((String)"ParameterHintFontMetrics");
    }

    @JvmStatic
    public static final int calcWidthInPixels(@NotNull Editor editor, @Nullable String text, @Nullable HintWidthAdjustment widthAdjustment) {
        return Companion.calcWidthInPixels(editor, text, widthAdjustment);
    }

    @JvmStatic
    public static final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor, @NotNull Rectangle r, @Nullable String text, @Nullable TextAttributes attributes, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment) {
        Companion.paintHint(g, editor, r, text, attributes, textAttributes, widthAdjustment);
    }

    @JvmStatic
    @NotNull
    protected static final Companion.MyFontMetrics getFontMetrics(@NotNull Editor editor) {
        return Companion.getFontMetrics(editor);
    }

    @JvmStatic
    protected static final int calcHintTextWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
        return Companion.calcHintTextWidth(text, fontMetrics);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0005J,\u0010\u0010\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J$\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0005J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002JF\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010%\u001a\u00020\u001c2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0004H\u0002J\f\u0010+\u001a\u00020,*\u00020'H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion;", "", "()V", "BACKGROUND_ALPHA", "", "HINT_FONT_METRICS", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "calcHintTextWidth", "", "text", "", "fontMetrics", "Ljava/awt/FontMetrics;", "calcWidthAdjustment", "editor", "Lcom/intellij/openapi/editor/Editor;", "widthAdjustment", "Lcom/intellij/codeInsight/hints/HintWidthAdjustment;", "calcWidthInPixels", "getFont", "Ljava/awt/Font;", "getFontMetrics", "isInsufficientContrast", "", "attributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "surroundingAttributes", "paintHint", "", "g", "Ljava/awt/Graphics;", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "r", "Ljava/awt/Rectangle;", "textAttributes", "srcOverBlend", "Ljava/awt/Color;", "foreground", "background", "foregroundAlpha", "toGray", "", "MyFontMetrics", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        public final int calcWidthInPixels(@NotNull Editor editor, @Nullable String text, @Nullable HintWidthAdjustment widthAdjustment) {
            FontMetrics fontMetrics = this.getFontMetrics(editor).getMetrics();
            return this.calcHintTextWidth(text, fontMetrics) + this.calcWidthAdjustment(text, editor, fontMetrics, widthAdjustment);
        }

        @JvmStatic
        public final void paintHint(@NotNull Graphics g, @NotNull EditorImpl editor, @NotNull Rectangle r, @Nullable String text, @Nullable TextAttributes attributes, @NotNull TextAttributes textAttributes, @Nullable HintWidthAdjustment widthAdjustment) {
            int ascent = editor.getAscent();
            int descent = editor.getDescent();
            Graphics graphics = g;
            if (graphics == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
            }
            Graphics2D g2d = (Graphics2D)graphics;
            if (text != null && attributes != null) {
                Color foregroundColor;
                MyFontMetrics fontMetrics = this.getFontMetrics(editor);
                int gap = r.height < fontMetrics.getLineHeight() + 2 ? 1 : 2;
                Color backgroundColor = attributes.getBackgroundColor();
                if (backgroundColor != null) {
                    float alpha = this.isInsufficientContrast(attributes, textAttributes) ? 1.0f : 0.55f;
                    GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g);
                    GraphicsUtil.paintWithAlpha((Graphics)g, (float)alpha);
                    g.setColor(backgroundColor);
                    g.fillRoundRect(r.x + 2, r.y + gap, r.width - 4, r.height - gap * 2, 8, 8);
                    config2.restore();
                }
                if ((foregroundColor = attributes.getForegroundColor()) != null) {
                    Object savedHint = g2d.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    Shape savedClip = g.getClip();
                    g.setColor(foregroundColor);
                    g.setFont(this.getFont(editor));
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
                    g.clipRect(r.x + 3, r.y + 2, r.width - 6, r.height - 4);
                    FontMetrics metrics = fontMetrics.getMetrics();
                    int startX = r.x + 7;
                    int startY = r.y + Math.max(ascent, (r.height + metrics.getAscent() - metrics.getDescent()) / 2) - 1;
                    int adjustment = this.calcWidthAdjustment(text, editor, ((Graphics2D)g).getFontMetrics(), widthAdjustment);
                    if (adjustment == 0) {
                        g.drawString(text, startX, startY);
                    } else {
                        HintWidthAdjustment hintWidthAdjustment = widthAdjustment;
                        if (hintWidthAdjustment == null) {
                            Intrinsics.throwNpe();
                        }
                        int adjustmentPosition = hintWidthAdjustment.getAdjustmentPosition();
                        String string = text;
                        int n = 0;
                        boolean bl = false;
                        String string2 = string.substring(n, adjustmentPosition);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        String firstPart = string2;
                        String string3 = text;
                        bl = false;
                        String string4 = string3.substring(adjustmentPosition);
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                        String secondPart = string4;
                        g.drawString(firstPart, startX, startY);
                        g.drawString(secondPart, startX + g.getFontMetrics().stringWidth(firstPart) + adjustment, startY);
                    }
                    g.setClip(savedClip);
                    g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedHint);
                }
            }
            Color effectColor = textAttributes.getEffectColor();
            EffectType effectType = textAttributes.getEffectType();
            if (effectColor != null) {
                g.setColor(effectColor);
                int xStart = r.x;
                int xEnd = r.x + r.width;
                int y = r.y + ascent;
                Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
                EffectType effectType2 = effectType;
                if (effectType2 != null) {
                    switch (HintRenderer$Companion$WhenMappings.$EnumSwitchMapping$0[effectType2.ordinal()]) {
                        case 1: {
                            EffectPainter.LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                            break;
                        }
                        case 2: {
                            EffectPainter.BOLD_LINE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                            break;
                        }
                        case 3: {
                            EffectPainter.STRIKE_THROUGH.paint(g2d, xStart, y, xEnd - xStart, editor.getCharHeight(), (Object)font);
                            break;
                        }
                        case 4: {
                            EffectPainter.WAVE_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                            break;
                        }
                        case 5: {
                            EffectPainter.BOLD_DOTTED_UNDERSCORE.paint(g2d, xStart, y, xEnd - xStart, descent, (Object)font);
                            break;
                        }
                    }
                }
            }
        }

        private final boolean isInsufficientContrast(TextAttributes attributes, TextAttributes surroundingAttributes) {
            Color backgroundUnderHint = surroundingAttributes.getBackgroundColor();
            if (backgroundUnderHint != null && attributes.getForegroundColor() != null) {
                double textGrayed;
                Color backgroundBlended = this.srcOverBlend(attributes.getBackgroundColor(), backgroundUnderHint, 0.55f);
                double backgroundBlendedGrayed = this.toGray(backgroundBlended);
                double delta = Math.abs(backgroundBlendedGrayed - (textGrayed = this.toGray(attributes.getForegroundColor())));
                return delta < (double)10;
            }
            return false;
        }

        private final double toGray(Color $this$toGray) {
            return 0.3 * (double)$this$toGray.getRed() + 0.59 * (double)$this$toGray.getGreen() + 0.11 * (double)$this$toGray.getBlue();
        }

        private final Color srcOverBlend(Color foreground, Color background, float foregroundAlpha) {
            float r = (float)foreground.getRed() * foregroundAlpha + (float)background.getRed() * (1.0f - foregroundAlpha);
            float g = (float)foreground.getGreen() * foregroundAlpha + (float)background.getGreen() * (1.0f - foregroundAlpha);
            float b = (float)foreground.getBlue() * foregroundAlpha + (float)background.getBlue() * (1.0f - foregroundAlpha);
            return new Color(MathKt.roundToInt((float)r), MathKt.roundToInt((float)g), MathKt.roundToInt((float)b));
        }

        private final int calcWidthAdjustment(String text, Editor editor, FontMetrics fontMetrics, HintWidthAdjustment widthAdjustment) {
            if (widthAdjustment == null || !(editor instanceof EditorImpl)) {
                return 0;
            }
            int editorTextWidth = ((EditorImpl)editor).getFontMetrics(0).stringWidth(widthAdjustment.getEditorTextToMatch());
            return Math.max(0, editorTextWidth + this.calcHintTextWidth(widthAdjustment.getHintTextToMatch(), fontMetrics) - this.calcHintTextWidth(text, fontMetrics));
        }

        @JvmStatic
        @NotNull
        protected final MyFontMetrics getFontMetrics(@NotNull Editor editor) {
            String familyName = UIManager.getFont("Label.font").getFamily();
            int size = Math.max(1, editor.getColorsScheme().getEditorFontSize() - 1);
            MyFontMetrics metrics = (MyFontMetrics)editor.getUserData(HINT_FONT_METRICS);
            if (metrics != null && !metrics.isActual(editor, familyName, size)) {
                metrics = null;
            }
            if (metrics == null) {
                metrics = new MyFontMetrics(editor, familyName, size);
                editor.putUserData(HINT_FONT_METRICS, (Object)metrics);
            }
            return metrics;
        }

        private final Font getFont(Editor editor) {
            return this.getFontMetrics(editor).getFont();
        }

        @JvmStatic
        protected final int calcHintTextWidth(@Nullable String text, @NotNull FontMetrics fontMetrics) {
            return text == null ? 0 : fontMetrics.stringWidth(text) + 14;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/daemon/impl/HintRenderer$Companion$MyFontMetrics;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "familyName", "", "size", "", "(Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;I)V", "font", "Ljava/awt/Font;", "getFont", "()Ljava/awt/Font;", "lineHeight", "getLineHeight", "()I", "metrics", "Ljava/awt/FontMetrics;", "getMetrics", "()Ljava/awt/FontMetrics;", "getCurrentContext", "Ljava/awt/font/FontRenderContext;", "isActual", "", "intellij.platform.ide.impl"})
        public static final class MyFontMetrics {
            @NotNull
            private final FontMetrics metrics;
            private final int lineHeight;

            @NotNull
            public final FontMetrics getMetrics() {
                return this.metrics;
            }

            public final int getLineHeight() {
                return this.lineHeight;
            }

            @NotNull
            public final Font getFont() {
                return this.metrics.getFont();
            }

            public final boolean isActual(@NotNull Editor editor, @NotNull String familyName, int size) {
                Font font = this.metrics.getFont();
                if (Intrinsics.areEqual((Object)familyName, (Object)font.getFamily()) ^ true || size != font.getSize()) {
                    return false;
                }
                FontRenderContext currentContext = this.getCurrentContext(editor);
                return currentContext.equals(this.metrics.getFontRenderContext());
            }

            private final FontRenderContext getCurrentContext(Editor editor) {
                FontRenderContext editorContext = FontInfo.getFontRenderContext(editor.getContentComponent());
                return new FontRenderContext(editorContext.getTransform(), AntialiasingType.getKeyForCurrentScope((boolean)false), editor instanceof EditorImpl ? ((EditorImpl)editor).myFractionalMetricsHintValue : RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }

            public MyFontMetrics(@NotNull Editor editor, @NotNull String familyName, int size) {
                FontUIResource font = UIUtil.getFontWithFallback((String)familyName, (int)0, (int)size);
                FontRenderContext context = this.getCurrentContext(editor);
                this.metrics = FontInfo.getFontMetrics(font, context);
                this.lineHeight = (int)Math.ceil(font.createGlyphVector(context, "Ap").getVisualBounds().getHeight());
            }
        }
    }
}

