/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightInfo
implements Segment {
    private static final Logger LOG = Logger.getInstance(HighlightInfo.class);
    private static final String DESCRIPTION_PLACEHOLDER = "\u0000";
    private static final byte BIJECTIVE_MASK = 1;
    private static final byte HAS_HINT_MASK = 2;
    private static final byte FROM_INJECTION_MASK = 4;
    private static final byte AFTER_END_OF_LINE_MASK = 8;
    private static final byte FILE_LEVEL_ANNOTATION_MASK = 16;
    private static final byte NEEDS_UPDATE_ON_TYPING_MASK = 32;
    public final TextAttributes forcedTextAttributes;
    public final TextAttributesKey forcedTextAttributesKey;
    @NotNull
    public final HighlightInfoType type;
    public final int startOffset;
    public final int endOffset;
    public List<Pair<IntentionActionDescriptor, TextRange>> quickFixActionRanges;
    public List<Pair<IntentionActionDescriptor, RangeMarker>> quickFixActionMarkers;
    private final String description;
    private final String toolTip;
    @NotNull
    private final HighlightSeverity severity;
    private final GutterMark gutterIconRenderer;
    private final ProblemGroup myProblemGroup;
    private final String inspectionToolId;
    private int group;
    private int fixStartOffset;
    private int fixEndOffset;
    private volatile byte myFlags;
    final int navigationShift;
    JComponent fileLevelComponent;
    @Nullable(value="null means it the same as highlighter")
    @Nullable(value="null means it the same as highlighter") RangeMarker fixMarker;
    volatile RangeHighlighterEx highlighter;
    PsiElement psiElement;
    private static final String ANNOTATOR_INSPECTION_SHORT_NAME = "Annotator";

    protected HighlightInfo(@Nullable TextAttributes forcedTextAttributes, @Nullable TextAttributesKey forcedTextAttributesKey, @NotNull HighlightInfoType type, int startOffset, int endOffset, @Nullable String escapedDescription, @Nullable String escapedToolTip, @NotNull HighlightSeverity severity, boolean afterEndOfLine, @Nullable Boolean needsUpdateOnTyping, boolean isFileLevelAnnotation, int navigationShift, ProblemGroup problemGroup, @Nullable String inspectionToolId, GutterMark gutterIconRenderer, int group) {
        if (startOffset < 0 || startOffset > endOffset) {
            LOG.error("Incorrect highlightInfo bounds. description=" + escapedDescription + "; startOffset=" + startOffset + "; endOffset=" + endOffset + ";type=" + type);
        }
        this.forcedTextAttributes = forcedTextAttributes;
        this.forcedTextAttributesKey = forcedTextAttributesKey;
        this.type = type;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.fixStartOffset = startOffset;
        this.fixEndOffset = endOffset;
        this.description = escapedDescription;
        this.toolTip = HighlightInfo.encodeTooltip(escapedToolTip, escapedDescription);
        this.severity = severity;
        this.setFlag((byte)8, afterEndOfLine);
        this.setFlag((byte)32, HighlightInfo.calcNeedUpdateOnTyping(needsUpdateOnTyping, type));
        this.setFlag((byte)16, isFileLevelAnnotation);
        this.navigationShift = navigationShift;
        this.myProblemGroup = problemGroup;
        this.gutterIconRenderer = gutterIconRenderer;
        this.inspectionToolId = inspectionToolId;
        this.group = group;
    }

    @Nullable
    public static HighlightInfo fromRangeHighlighter(@NotNull RangeHighlighter highlighter) {
        Object errorStripeTooltip = highlighter.getErrorStripeTooltip();
        return errorStripeTooltip instanceof HighlightInfo ? (HighlightInfo)errorStripeTooltip : null;
    }

    @NotNull
    ProperTextRange getFixTextRange() {
        return new ProperTextRange(this.fixStartOffset, this.fixEndOffset);
    }

    void setFromInjection(boolean fromInjection) {
        this.setFlag((byte)4, fromInjection);
    }

    @Nullable
    public String getToolTip() {
        String toolTip = this.toolTip;
        String description = this.description;
        if (toolTip == null || description == null || !toolTip.contains(DESCRIPTION_PLACEHOLDER)) {
            return toolTip;
        }
        String decoded = StringUtil.replace((String)toolTip, (String)DESCRIPTION_PLACEHOLDER, (String)XmlStringUtil.escapeString((String)description));
        return XmlStringUtil.wrapInHtml((CharSequence)decoded);
    }

    private static String encodeTooltip(String tooltip, String description) {
        if (tooltip == null || description == null || description.isEmpty()) {
            return tooltip;
        }
        String encoded = StringUtil.replace((String)tooltip, (String)XmlStringUtil.escapeString((String)description), (String)DESCRIPTION_PLACEHOLDER);
        if (encoded == tooltip) {
            return tooltip;
        }
        if (encoded.equals(DESCRIPTION_PLACEHOLDER)) {
            encoded = DESCRIPTION_PLACEHOLDER;
        }
        return XmlStringUtil.stripHtml((String)encoded);
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    @NonNls
    public String getInspectionToolId() {
        return this.inspectionToolId;
    }

    private boolean isFlagSet(@FlagConstant byte mask) {
        return BitUtil.isSet((byte)this.myFlags, (byte)mask);
    }

    private void setFlag(@FlagConstant byte mask, boolean value2) {
        this.myFlags = BitUtil.set((byte)this.myFlags, (byte)mask, (boolean)value2);
    }

    boolean isFileLevelAnnotation() {
        return this.isFlagSet((byte)16);
    }

    boolean isBijective() {
        return this.isFlagSet((byte)1);
    }

    void setBijective(boolean bijective) {
        this.setFlag((byte)1, bijective);
    }

    @NotNull
    public HighlightSeverity getSeverity() {
        return this.severity;
    }

    public RangeHighlighterEx getHighlighter() {
        return this.highlighter;
    }

    public void setHighlighter(@Nullable RangeHighlighterEx highlighter) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.highlighter = highlighter;
    }

    public boolean isAfterEndOfLine() {
        return this.isFlagSet((byte)8);
    }

    @Nullable
    public TextAttributes getTextAttributes(@Nullable PsiElement element2, @Nullable EditorColorsScheme editorColorsScheme) {
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes;
        }
        EditorColorsScheme colorsScheme = HighlightInfo.getColorsScheme(editorColorsScheme);
        if (this.forcedTextAttributesKey != null) {
            return colorsScheme.getAttributes(this.forcedTextAttributesKey);
        }
        return HighlightInfo.getAttributesByType(element2, this.type, (TextAttributesScheme)colorsScheme);
    }

    public static TextAttributes getAttributesByType(@Nullable PsiElement element2, @NotNull HighlightInfoType type, @NotNull TextAttributesScheme colorsScheme) {
        SeverityRegistrar severityRegistrar = SeverityRegistrar.getSeverityRegistrar(element2 != null ? element2.getProject() : null);
        TextAttributes textAttributes = severityRegistrar.getTextAttributesBySeverity(type.getSeverity(element2));
        if (textAttributes != null) {
            return textAttributes;
        }
        TextAttributesKey key = type.getAttributesKey();
        return colorsScheme.getAttributes(key);
    }

    @Nullable
    Color getErrorStripeMarkColor(@NotNull PsiElement element2, @Nullable(value="when null, the global scheme will be used") @Nullable(value="when null, the global scheme will be used") EditorColorsScheme colorsScheme) {
        Color errorStripeColor;
        TextAttributes forcedTextAttributes;
        if (this.forcedTextAttributes != null) {
            return this.forcedTextAttributes.getErrorStripeColor();
        }
        EditorColorsScheme scheme = HighlightInfo.getColorsScheme(colorsScheme);
        if (this.forcedTextAttributesKey != null && (forcedTextAttributes = scheme.getAttributes(this.forcedTextAttributesKey)) != null && (errorStripeColor = forcedTextAttributes.getErrorStripeColor()) != null) {
            return errorStripeColor;
        }
        if (this.getSeverity() == HighlightSeverity.ERROR) {
            return scheme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WARNING) {
            return scheme.getAttributes(CodeInsightColors.WARNINGS_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.INFO) {
            return scheme.getAttributes(CodeInsightColors.INFO_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.WEAK_WARNING) {
            return scheme.getAttributes(CodeInsightColors.WEAK_WARNING_ATTRIBUTES).getErrorStripeColor();
        }
        if (this.getSeverity() == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) {
            return scheme.getAttributes(CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING).getErrorStripeColor();
        }
        TextAttributes attributes = HighlightInfo.getAttributesByType(element2, this.type, (TextAttributesScheme)scheme);
        return attributes == null ? null : attributes.getErrorStripeColor();
    }

    @NotNull
    private static EditorColorsScheme getColorsScheme(@Nullable EditorColorsScheme customScheme) {
        return customScheme != null ? customScheme : EditorColorsManager.getInstance().getGlobalScheme();
    }

    @Nullable
    private static String htmlEscapeToolTip(@Nullable String unescapedTooltip) {
        return unescapedTooltip == null ? null : XmlStringUtil.wrapInHtml((CharSequence)XmlStringUtil.escapeString((String)unescapedTooltip));
    }

    public boolean needUpdateOnTyping() {
        return this.isFlagSet((byte)32);
    }

    private static boolean calcNeedUpdateOnTyping(@Nullable Boolean needsUpdateOnTyping, HighlightInfoType type) {
        if (needsUpdateOnTyping != null) {
            return needsUpdateOnTyping;
        }
        if (type instanceof HighlightInfoType.UpdateOnTypingSuppressible) {
            return ((HighlightInfoType.UpdateOnTypingSuppressible)((Object)type)).needsUpdateOnTyping();
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HighlightInfo)) {
            return false;
        }
        HighlightInfo info = (HighlightInfo)obj;
        return info.getSeverity() == this.getSeverity() && info.startOffset == this.startOffset && info.endOffset == this.endOffset && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    protected boolean equalsByActualOffset(@NotNull HighlightInfo info) {
        if (info == this) {
            return true;
        }
        return info.getSeverity() == this.getSeverity() && info.getActualStartOffset() == this.getActualStartOffset() && info.getActualEndOffset() == this.getActualEndOffset() && Comparing.equal((Object)info.type, (Object)this.type) && Comparing.equal((Object)info.gutterIconRenderer, (Object)this.gutterIconRenderer) && Comparing.equal((Object)info.forcedTextAttributes, (Object)this.forcedTextAttributes) && Comparing.equal((Object)info.forcedTextAttributesKey, (Object)this.forcedTextAttributesKey) && Comparing.strEqual((String)info.getDescription(), (String)this.getDescription());
    }

    public int hashCode() {
        return this.startOffset;
    }

    public String toString() {
        String s = "HighlightInfo(" + this.startOffset + "," + this.endOffset + ")";
        if (this.getActualStartOffset() != this.startOffset || this.getActualEndOffset() != this.endOffset) {
            s = s + "; actual: (" + this.getActualStartOffset() + "," + this.getActualEndOffset() + ")";
        }
        if (this.highlighter != null) {
            s = s + " text='" + this.getText() + "'";
        }
        if (this.getDescription() != null) {
            s = s + ", description='" + this.getDescription() + "'";
        }
        s = s + " severity=" + this.getSeverity();
        s = s + " group=" + this.getGroup();
        if (this.quickFixActionRanges != null) {
            s = s + "; quickFixes: " + this.quickFixActionRanges;
        }
        if (this.gutterIconRenderer != null) {
            s = s + "; gutter: " + this.gutterIconRenderer;
        }
        return s;
    }

    @NotNull
    public static Builder newHighlightInfo(@NotNull HighlightInfoType type) {
        return new B(type);
    }

    void setGroup(int group) {
        this.group = group;
    }

    private static boolean isAcceptedByFilters(@NotNull HighlightInfo info, @Nullable PsiElement psiElement) {
        PsiFile file2 = psiElement == null ? null : psiElement.getContainingFile();
        for (HighlightInfoFilter filter2 : (HighlightInfoFilter[])HighlightInfoFilter.EXTENSION_POINT_NAME.getExtensions()) {
            if (filter2.accept(info, file2)) continue;
            return false;
        }
        info.psiElement = psiElement;
        return true;
    }

    public GutterMark getGutterIconRenderer() {
        return this.gutterIconRenderer;
    }

    @Nullable
    public ProblemGroup getProblemGroup() {
        return this.myProblemGroup;
    }

    @NotNull
    public static HighlightInfo fromAnnotation(@NotNull Annotation annotation) {
        return HighlightInfo.fromAnnotation(annotation, false);
    }

    @NotNull
    static HighlightInfo fromAnnotation(@NotNull Annotation annotation, boolean batchMode) {
        List fixes;
        TextAttributes forcedAttributes = annotation.getEnforcedTextAttributes();
        TextAttributesKey key = annotation.getTextAttributes();
        TextAttributesKey forcedAttributesKey = forcedAttributes == null && key != HighlighterColors.NO_HIGHLIGHTING ? key : null;
        HighlightInfo info = new HighlightInfo(forcedAttributes, forcedAttributesKey, HighlightInfo.convertType(annotation), annotation.getStartOffset(), annotation.getEndOffset(), annotation.getMessage(), annotation.getTooltip(), annotation.getSeverity(), annotation.isAfterEndOfLine(), annotation.needsUpdateOnTyping(), annotation.isFileLevelAnnotation(), 0, annotation.getProblemGroup(), null, (GutterMark)annotation.getGutterIconRenderer(), 4);
        List list2 = fixes = batchMode ? annotation.getBatchFixes() : annotation.getQuickFixes();
        if (fixes != null) {
            for (Annotation.QuickFixInfo quickFixInfo : fixes) {
                TextRange range2 = quickFixInfo.textRange;
                HighlightDisplayKey k = quickFixInfo.key != null ? quickFixInfo.key : HighlightDisplayKey.find((String)ANNOTATOR_INSPECTION_SHORT_NAME);
                info.registerFix(quickFixInfo.quickFix, null, HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)k), range2, k);
            }
        }
        return info;
    }

    @NotNull
    private static HighlightInfoType convertType(@NotNull Annotation annotation) {
        ProblemHighlightType type = annotation.getHighlightType();
        HighlightSeverity severity = annotation.getSeverity();
        return HighlightInfo.toHighlightInfoType(type, severity);
    }

    @NotNull
    private static HighlightInfoType toHighlightInfoType(ProblemHighlightType problemHighlightType, @NotNull HighlightSeverity severity) {
        if (problemHighlightType == ProblemHighlightType.LIKE_UNUSED_SYMBOL) {
            return HighlightInfoType.UNUSED_SYMBOL;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_UNKNOWN_SYMBOL) {
            return HighlightInfoType.WRONG_REF;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_DEPRECATED) {
            return HighlightInfoType.DEPRECATED;
        }
        if (problemHighlightType == ProblemHighlightType.LIKE_MARKED_FOR_REMOVAL) {
            return HighlightInfoType.MARKED_FOR_REMOVAL;
        }
        return HighlightInfo.convertSeverity(severity);
    }

    @NotNull
    public static HighlightInfoType convertSeverity(@NotNull HighlightSeverity severity) {
        return severity == HighlightSeverity.ERROR ? HighlightInfoType.ERROR : (severity == HighlightSeverity.WARNING ? HighlightInfoType.WARNING : (severity == HighlightSeverity.INFO ? HighlightInfoType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? HighlightInfoType.WEAK_WARNING : (severity == HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING ? HighlightInfoType.GENERIC_WARNINGS_OR_ERRORS_FROM_SERVER : HighlightInfoType.INFORMATION))));
    }

    @NotNull
    public static ProblemHighlightType convertType(@NotNull HighlightInfoType infoType) {
        if (infoType == HighlightInfoType.ERROR || infoType == HighlightInfoType.WRONG_REF) {
            return ProblemHighlightType.ERROR;
        }
        if (infoType == HighlightInfoType.WARNING) {
            return ProblemHighlightType.WARNING;
        }
        if (infoType == HighlightInfoType.INFORMATION) {
            return ProblemHighlightType.INFORMATION;
        }
        return ProblemHighlightType.WEAK_WARNING;
    }

    @NotNull
    public static ProblemHighlightType convertSeverityToProblemHighlight(@NotNull HighlightSeverity severity) {
        return severity == HighlightSeverity.ERROR ? ProblemHighlightType.ERROR : (severity == HighlightSeverity.WARNING ? ProblemHighlightType.WARNING : (severity == HighlightSeverity.INFO ? ProblemHighlightType.INFO : (severity == HighlightSeverity.WEAK_WARNING ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.INFORMATION)));
    }

    public boolean hasHint() {
        return this.isFlagSet((byte)2);
    }

    void setHint(boolean hasHint) {
        this.setFlag((byte)2, hasHint);
    }

    public int getActualStartOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.startOffset : h.getStartOffset();
    }

    public int getActualEndOffset() {
        RangeHighlighterEx h = this.highlighter;
        return h == null || !h.isValid() ? this.endOffset : h.getEndOffset();
    }

    public int getStartOffset() {
        return this.getActualStartOffset();
    }

    public int getEndOffset() {
        return this.getActualEndOffset();
    }

    int getGroup() {
        return this.group;
    }

    boolean isFromInjection() {
        return this.isFlagSet((byte)4);
    }

    @NotNull
    public String getText() {
        if (this.isFileLevelAnnotation()) {
            return "";
        }
        RangeHighlighterEx highlighter = this.highlighter;
        if (highlighter == null) {
            throw new RuntimeException("info not applied yet");
        }
        if (!highlighter.isValid()) {
            return "";
        }
        return highlighter.getDocument().getText(TextRange.create((Segment)highlighter));
    }

    public void registerFix(@Nullable IntentionAction action2, @Nullable List<IntentionAction> options2, @Nullable String displayName, @Nullable TextRange fixRange, @Nullable HighlightDisplayKey key) {
        if (action2 == null) {
            return;
        }
        if (fixRange == null) {
            fixRange = new TextRange(this.startOffset, this.endOffset);
        }
        if (this.quickFixActionRanges == null) {
            this.quickFixActionRanges = ContainerUtil.createLockFreeCopyOnWriteList();
        }
        IntentionActionDescriptor desc = new IntentionActionDescriptor(action2, options2, displayName, null, key, this.getProblemGroup(), this.getSeverity());
        this.quickFixActionRanges.add((Pair<IntentionActionDescriptor, TextRange>)Pair.create((Object)desc, (Object)fixRange));
        this.fixStartOffset = Math.min(this.fixStartOffset, fixRange.getStartOffset());
        this.fixEndOffset = Math.max(this.fixEndOffset, fixRange.getEndOffset());
        if (action2 instanceof HintAction) {
            this.setHint(true);
        }
    }

    public void unregisterQuickFix(@NotNull Condition<? super IntentionAction> condition) {
        if (this.quickFixActionRanges != null) {
            this.quickFixActionRanges.removeIf(pair -> condition.value((Object)((IntentionActionDescriptor)pair.first).getAction()));
        }
    }

    public static class IntentionActionDescriptor {
        private final IntentionAction myAction;
        private volatile List<IntentionAction> myOptions;
        private volatile HighlightDisplayKey myKey;
        private final ProblemGroup myProblemGroup;
        private final HighlightSeverity mySeverity;
        private final String myDisplayName;
        private final Icon myIcon;
        private Boolean myCanCleanup;

        IntentionActionDescriptor(@NotNull IntentionAction action2, List<IntentionAction> options2, String displayName) {
            this(action2, options2, displayName, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action2, Icon icon2) {
            this(action2, null, null, icon2);
        }

        IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable List<IntentionAction> options2, @Nullable String displayName, @Nullable Icon icon2) {
            this(action2, options2, displayName, icon2, null, null, null);
        }

        public IntentionActionDescriptor(@NotNull IntentionAction action2, @Nullable List<IntentionAction> options2, @Nullable String displayName, @Nullable Icon icon2, @Nullable HighlightDisplayKey key, @Nullable ProblemGroup problemGroup, @Nullable HighlightSeverity severity) {
            this.myAction = action2;
            this.myOptions = options2;
            this.myDisplayName = displayName;
            this.myIcon = icon2;
            this.myKey = key;
            this.myProblemGroup = problemGroup;
            this.mySeverity = severity;
        }

        @NotNull
        public IntentionAction getAction() {
            return this.myAction;
        }

        boolean isError() {
            return this.mySeverity == null || this.mySeverity.compareTo(HighlightSeverity.ERROR) >= 0;
        }

        boolean isInformation() {
            return HighlightSeverity.INFORMATION.equals((Object)this.mySeverity);
        }

        boolean canCleanup(@NotNull PsiElement element2) {
            if (this.myCanCleanup == null) {
                InspectionToolWrapper toolWrapper;
                InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element2.getProject()).getCurrentProfile();
                HighlightDisplayKey key = this.myKey;
                this.myCanCleanup = key == null ? Boolean.valueOf(false) : Boolean.valueOf((toolWrapper = profile.getInspectionTool(key.toString(), element2)) != null && toolWrapper.isCleanupTool());
            }
            return this.myCanCleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public List<IntentionAction> getOptions(@NotNull PsiElement element2, @Nullable Editor editor) {
            HighlightDisplayKey idKey;
            if (editor != null && Boolean.FALSE.equals(editor.getUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY))) {
                return null;
            }
            List options2 = this.myOptions;
            HighlightDisplayKey key = this.myKey;
            if (this.myProblemGroup != null) {
                HighlightDisplayKey problemGroupKey;
                String problemName = this.myProblemGroup.getProblemName();
                HighlightDisplayKey highlightDisplayKey = problemGroupKey = problemName != null ? HighlightDisplayKey.findById((String)problemName) : null;
                if (problemGroupKey != null) {
                    key = problemGroupKey;
                }
            }
            if (options2 != null || key == null) {
                return options2;
            }
            IntentionManager intentionManager = IntentionManager.getInstance();
            List newOptions = intentionManager.getStandardIntentionOptions(key, element2);
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance(element2.getProject()).getCurrentProfile();
            InspectionToolWrapper toolWrapper = profile.getInspectionTool(key.toString(), element2);
            if (!(toolWrapper instanceof LocalInspectionToolWrapper) && (idKey = HighlightDisplayKey.findById((String)key.toString())) != null) {
                toolWrapper = profile.getInspectionTool(idKey.toString(), element2);
            }
            if (toolWrapper != null) {
                InspectionProfileEntry wrappedTool;
                this.myCanCleanup = toolWrapper.isCleanupTool();
                IntentionAction fixAllIntention = intentionManager.createFixAllIntention(toolWrapper, this.myAction);
                InspectionProfileEntry inspectionProfileEntry = wrappedTool = toolWrapper instanceof LocalInspectionToolWrapper ? ((LocalInspectionToolWrapper)toolWrapper).getTool() : ((GlobalInspectionToolWrapper)toolWrapper).getTool();
                if (wrappedTool instanceof DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection) {
                    List<IntentionAction> actions = Collections.emptyList();
                    if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                        actions = Arrays.asList(((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element2));
                    }
                    if (fixAllIntention != null) {
                        if (actions.isEmpty()) {
                            return Collections.singletonList(fixAllIntention);
                        }
                        actions = new ArrayList<IntentionAction>(actions);
                        actions.add(fixAllIntention);
                    }
                    return actions;
                }
                ContainerUtil.addIfNotNull((Collection)newOptions, (Object)fixAllIntention);
                if (wrappedTool instanceof CustomSuppressableInspectionTool) {
                    Object[] suppressActions = ((CustomSuppressableInspectionTool)wrappedTool).getSuppressActions(element2);
                    if (suppressActions != null) {
                        ContainerUtil.addAll((Collection)newOptions, (Object[])suppressActions);
                    }
                } else {
                    Object[] suppressFixes = wrappedTool.getBatchSuppressActions(element2);
                    if (suppressFixes.length > 0) {
                        newOptions.addAll(ContainerUtil.map((Object[])suppressFixes, SuppressIntentionActionFromFix::convertBatchToSuppressIntentionAction));
                    }
                }
            }
            if (this.myProblemGroup instanceof SuppressableProblemGroup) {
                Object[] suppressActions = ((SuppressableProblemGroup)this.myProblemGroup).getSuppressActions(element2);
                ContainerUtil.addAll((Collection)newOptions, (Object[])suppressActions);
            }
            IntentionActionDescriptor intentionActionDescriptor = this;
            synchronized (intentionActionDescriptor) {
                options2 = this.myOptions;
                if (options2 == null) {
                    this.myOptions = options2 = newOptions;
                }
                this.myKey = null;
            }
            return options2;
        }

        @Nullable
        public String getDisplayName() {
            return this.myDisplayName;
        }

        public String toString() {
            String text = this.getAction().getText();
            return "descriptor: " + (text.isEmpty() ? this.getAction().getClass() : text);
        }

        @Nullable
        public Icon getIcon() {
            return this.myIcon;
        }

        public boolean equals(Object obj) {
            return obj instanceof IntentionActionDescriptor && this.myAction.equals(((IntentionActionDescriptor)obj).myAction);
        }
    }

    private static class B
    implements Builder {
        private Boolean myNeedsUpdateOnTyping;
        private TextAttributes forcedTextAttributes;
        private TextAttributesKey forcedTextAttributesKey;
        private final HighlightInfoType type;
        private int startOffset = -1;
        private int endOffset = -1;
        private String escapedDescription;
        private String escapedToolTip;
        private HighlightSeverity severity;
        private boolean isAfterEndOfLine;
        private boolean isFileLevelAnnotation;
        private int navigationShift;
        private GutterIconRenderer gutterIconRenderer;
        private ProblemGroup problemGroup;
        private String inspectionToolId;
        private PsiElement psiElement;
        private int group;

        private B(@NotNull HighlightInfoType type) {
            this.type = type;
        }

        @Override
        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
            assert (this.gutterIconRenderer == null) : "gutterIconRenderer already set";
            this.gutterIconRenderer = gutterIconRenderer;
            return this;
        }

        @Override
        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup problemGroup) {
            assert (this.problemGroup == null) : "problemGroup already set";
            this.problemGroup = problemGroup;
            return this;
        }

        @Override
        @NotNull
        public Builder inspectionToolId(@NotNull String inspectionToolId) {
            assert (this.inspectionToolId == null) : "inspectionToolId already set";
            this.inspectionToolId = inspectionToolId;
            return this;
        }

        @Override
        @NotNull
        public Builder description(@NotNull String description) {
            assert (this.escapedDescription == null) : "description already set";
            this.escapedDescription = description;
            return this;
        }

        @Override
        @NotNull
        public Builder descriptionAndTooltip(@NotNull String description) {
            return this.description(description).unescapedToolTip(description);
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributes attributes) {
            assert (this.forcedTextAttributes == null) : "textAttributes already set";
            this.forcedTextAttributes = attributes;
            return this;
        }

        @Override
        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey attributesKey) {
            assert (this.forcedTextAttributesKey == null) : "textAttributesKey already set";
            this.forcedTextAttributesKey = attributesKey;
            return this;
        }

        @Override
        @NotNull
        public Builder unescapedToolTip(@NotNull String unescapedToolTip) {
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = HighlightInfo.htmlEscapeToolTip(unescapedToolTip);
            return this;
        }

        @Override
        @NotNull
        public Builder escapedToolTip(@NotNull String escapedToolTip) {
            assert (this.escapedToolTip == null) : "Tooltip was already set";
            this.escapedToolTip = escapedToolTip;
            return this;
        }

        @Override
        @NotNull
        public Builder range(int start2, int end) {
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = start2;
            this.endOffset = end;
            return this;
        }

        @Override
        @NotNull
        public Builder range(@NotNull TextRange textRange) {
            assert (this.startOffset == -1 && this.endOffset == -1) : "Offsets already set";
            this.startOffset = textRange.getStartOffset();
            this.endOffset = textRange.getEndOffset();
            return this;
        }

        @Override
        @NotNull
        public Builder range(@NotNull ASTNode node) {
            return this.range(node.getPsi());
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element2) {
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element2;
            return this.range(element2.getTextRange());
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element2, @NotNull TextRange rangeInElement) {
            TextRange absoluteRange = rangeInElement.shiftRight(element2.getTextRange().getStartOffset());
            return this.range(element2, absoluteRange.getStartOffset(), absoluteRange.getEndOffset());
        }

        @Override
        @NotNull
        public Builder range(@NotNull PsiElement element2, int start2, int end) {
            assert (this.psiElement == null) : " psiElement already set";
            this.psiElement = element2;
            return this.range(start2, end);
        }

        @Override
        @NotNull
        public Builder endOfLine() {
            this.isAfterEndOfLine = true;
            return this;
        }

        @Override
        @NotNull
        public Builder needsUpdateOnTyping(boolean update2) {
            assert (this.myNeedsUpdateOnTyping == null) : " needsUpdateOnTyping already set";
            this.myNeedsUpdateOnTyping = update2;
            return this;
        }

        @Override
        @NotNull
        public Builder severity(@NotNull HighlightSeverity severity) {
            assert (this.severity == null) : " severity already set";
            this.severity = severity;
            return this;
        }

        @Override
        @NotNull
        public Builder fileLevelAnnotation() {
            this.isFileLevelAnnotation = true;
            return this;
        }

        @Override
        @NotNull
        public Builder navigationShift(int navigationShift) {
            this.navigationShift = navigationShift;
            return this;
        }

        @Override
        @NotNull
        public Builder group(int group) {
            this.group = group;
            return this;
        }

        @Override
        @Nullable
        public HighlightInfo create() {
            HighlightInfo info = this.createUnconditionally();
            LOG.assertTrue(this.psiElement != null || this.severity == HighlightInfoType.SYMBOL_TYPE_SEVERITY || this.severity == HighlightInfoType.INJECTED_FRAGMENT_SEVERITY || ArrayUtil.find((Object[])HighlightSeverity.DEFAULT_SEVERITIES, (Object)this.severity) != -1, (Object)"Custom type requires not-null element to detect its text attributes");
            if (!HighlightInfo.isAcceptedByFilters(info, this.psiElement)) {
                return null;
            }
            return info;
        }

        @Override
        @NotNull
        public HighlightInfo createUnconditionally() {
            if (this.severity == null) {
                this.severity = this.type.getSeverity(this.psiElement);
            }
            return new HighlightInfo(this.forcedTextAttributes, this.forcedTextAttributesKey, this.type, this.startOffset, this.endOffset, this.escapedDescription, this.escapedToolTip, this.severity, this.isAfterEndOfLine, this.myNeedsUpdateOnTyping, this.isFileLevelAnnotation, this.navigationShift, this.problemGroup, this.inspectionToolId, (GutterMark)this.gutterIconRenderer, this.group);
        }
    }

    public static interface Builder {
        @NotNull
        public Builder range(@NotNull TextRange var1);

        @NotNull
        public Builder range(@NotNull ASTNode var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1);

        @NotNull
        public Builder range(@NotNull PsiElement var1, @NotNull TextRange var2);

        @NotNull
        public Builder range(@NotNull PsiElement var1, int var2, int var3);

        @NotNull
        public Builder range(int var1, int var2);

        @NotNull
        public Builder gutterIconRenderer(@NotNull GutterIconRenderer var1);

        @NotNull
        public Builder problemGroup(@NotNull ProblemGroup var1);

        @NotNull
        public Builder inspectionToolId(@NotNull String var1);

        @NotNull
        public Builder description(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder descriptionAndTooltip(@NlsContexts.DetailedDescription @NotNull String var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributes var1);

        @NotNull
        public Builder textAttributes(@NotNull TextAttributesKey var1);

        @NotNull
        public Builder unescapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder escapedToolTip(@NlsContexts.Tooltip @NotNull String var1);

        @NotNull
        public Builder endOfLine();

        @NotNull
        public Builder needsUpdateOnTyping(boolean var1);

        @NotNull
        public Builder severity(@NotNull HighlightSeverity var1);

        @NotNull
        public Builder fileLevelAnnotation();

        @NotNull
        public Builder navigationShift(int var1);

        @NotNull
        public Builder group(int var1);

        @Nullable(value="null means filtered out")
        public @Nullable(value="null means filtered out") HighlightInfo create();

        @NotNull
        public HighlightInfo createUnconditionally();
    }

    private static @interface FlagConstant {
    }
}

