/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IncorrectOperationException;
import java.awt.event.InputEvent;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GutterIntentionAction
extends AbstractIntentionAction
implements Comparable<IntentionAction>,
Iconable,
ShortcutProvider,
PriorityAction {
    private final AnAction myAction;
    private final int myOrder;
    private final Icon myIcon;
    private String myText;

    GutterIntentionAction(AnAction action2, int order, Icon icon2) {
        this.myAction = action2;
        this.myOrder = order;
        this.myIcon = icon2;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        this.myAction.actionPerformed(new AnActionEvent((InputEvent)relativePoint.toMouseEvent(), ((EditorEx)editor).getDataContext(), "IntentionMenu", new Presentation(), ActionManager.getInstance(), 0));
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        return this.myText != null ? StringUtil.isNotEmpty((String)this.myText) : this.isAvailable(((EditorEx)editor).getDataContext());
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.myAction instanceof PriorityAction ? ((PriorityAction)this.myAction).getPriority() : PriorityAction.Priority.NORMAL;
    }

    @NotNull
    static AnActionEvent createActionEvent(@NotNull DataContext dataContext) {
        return AnActionEvent.createFromDataContext((String)"IntentionMenu", null, (DataContext)dataContext);
    }

    boolean isAvailable(@NotNull DataContext dataContext) {
        if (this.myText == null) {
            String text;
            AnActionEvent event = GutterIntentionAction.createActionEvent(dataContext);
            this.myAction.update(event);
            this.myText = event.getPresentation().isEnabled() && event.getPresentation().isVisible() ? ((text = event.getPresentation().getText()) != null ? text : StringUtil.notNullize((String)this.myAction.getTemplatePresentation().getText())) : "";
        }
        return StringUtil.isNotEmpty((String)this.myText);
    }

    @NotNull
    public String getText() {
        return StringUtil.notNullize((String)this.myText);
    }

    @Override
    public int compareTo(@NotNull IntentionAction o) {
        if (o instanceof GutterIntentionAction) {
            return this.myOrder - ((GutterIntentionAction)o).myOrder;
        }
        return 0;
    }

    public Icon getIcon(@Iconable.IconFlags int flags) {
        return this.myIcon;
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.myAction.getShortcutSet();
    }
}

