/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorTracker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(EditorTracker.class);
    private final Project myProject;
    private final Map<Window, List<Editor>> myWindowToEditorsMap = new HashMap<Window, List<Editor>>();
    private final Map<Window, WindowAdapter> myWindowToWindowFocusListenerMap = new HashMap<Window, WindowAdapter>();
    private final Map<Editor, Window> myEditorToWindowMap = new HashMap<Editor, Window>();
    private List<Editor> myActiveEditors = Collections.emptyList();
    private Window myActiveWindow;
    private final Map<Editor, Runnable> myExecuteOnEditorRelease = new HashMap<Editor, Runnable>();

    public EditorTracker(@NotNull Project project) {
        this.myProject = project;
        project.getMessageBus().connect((Disposable)this).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                JFrame frame = WindowManager.getInstance().getFrame(EditorTracker.this.myProject);
                if (frame == null || frame.getFocusOwner() == null) {
                    return;
                }
                EditorTracker.this.setActiveWindow(frame);
            }
        });
    }

    public static EditorTracker getInstance(@NotNull Project project) {
        return (EditorTracker)project.getService(EditorTracker.class);
    }

    private void registerEditor(@NotNull Editor editor) {
        this.unregisterEditor(editor);
        final Window window = this.windowByEditor(editor);
        if (window == null) {
            return;
        }
        this.myEditorToWindowMap.put(editor, window);
        List<Editor> list2 = this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            list2 = new ArrayList<Editor>();
            this.myWindowToEditorsMap.put(window, list2);
            if (!(window instanceof IdeFrameImpl)) {
                WindowAdapter listener2 = new WindowAdapter(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowGainedFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(window);
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowLostFocus:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }

                    @Override
                    public void windowClosed(WindowEvent event) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("windowClosed:" + window);
                        }
                        EditorTracker.this.setActiveWindow(null);
                    }
                };
                this.myWindowToWindowFocusListenerMap.put(window, listener2);
                window.addWindowFocusListener(listener2);
                window.addWindowListener(listener2);
                if (window.isFocused()) {
                    this.setActiveWindow(window);
                }
            }
        }
        list2.add(editor);
        if (this.myActiveWindow == window) {
            this.setActiveWindow(window);
        }
    }

    private void unregisterEditor(@NotNull Editor editor) {
        Window oldWindow = this.myEditorToWindowMap.get(editor);
        if (oldWindow != null) {
            this.myEditorToWindowMap.remove(editor);
            List<Editor> editorsList = this.myWindowToEditorsMap.get(oldWindow);
            boolean removed = editorsList.remove(editor);
            LOG.assertTrue(removed);
            if (editorsList.isEmpty()) {
                this.myWindowToEditorsMap.remove(oldWindow);
                WindowAdapter listener2 = this.myWindowToWindowFocusListenerMap.remove(oldWindow);
                if (listener2 != null) {
                    oldWindow.removeWindowFocusListener(listener2);
                    oldWindow.removeWindowListener(listener2);
                }
            }
        }
    }

    @Nullable
    private Window windowByEditor(@NotNull Editor editor) {
        Window window = SwingUtilities.windowForComponent(editor.getComponent());
        ProjectFrameHelper frameHelper = ProjectFrameHelper.getFrameHelper(window);
        return frameHelper != null && frameHelper.getProject() != this.myProject ? null : window;
    }

    @NotNull
    public List<Editor> getActiveEditors() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.myActiveEditors;
    }

    private void setActiveWindow(@Nullable Window window) {
        List<Editor> list2;
        this.myActiveWindow = window;
        List<Editor> list3 = list2 = window == null ? null : this.myWindowToEditorsMap.get(window);
        if (list2 == null) {
            this.setActiveEditors(Collections.emptyList());
        } else {
            SmartList editors = new SmartList();
            for (Editor editor : list2) {
                if (!editor.getContentComponent().isShowing()) continue;
                editors.add(editor);
            }
            this.setActiveEditors((List<Editor>)editors);
        }
    }

    public void setActiveEditors(@NotNull List<Editor> editors) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (editors.equals(this.myActiveEditors)) {
            return;
        }
        this.myActiveEditors = editors;
        if (LOG.isDebugEnabled()) {
            LOG.debug("active editors changed:");
            for (Editor editor : editors) {
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
                LOG.debug("    " + psiFile);
            }
        }
        ((EditorTrackerListener)this.myProject.getMessageBus().syncPublisher(EditorTrackerListener.TOPIC)).activeEditorsChanged(editors);
    }

    private void editorCreated(@NotNull EditorFactoryEvent event) {
        Editor editor = event.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject || this.myProject.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(editor.getDocument());
        if (psiFile == null) {
            return;
        }
        this.createEditorImpl(editor);
    }

    protected void createEditorImpl(final @NotNull Editor editor) {
        JComponent component2 = editor.getComponent();
        JComponent contentComponent = editor.getContentComponent();
        PropertyChangeListener propertyChangeListener = evt -> {
            if (evt.getOldValue() == null && evt.getNewValue() != null) {
                this.registerEditor(editor);
            }
        };
        component2.addPropertyChangeListener("ancestor", propertyChangeListener);
        FocusListener focusListener2 = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                Window window = (Window)EditorTracker.this.myEditorToWindowMap.get(editor);
                if (window == null) {
                    return;
                }
                List list2 = (List)EditorTracker.this.myWindowToEditorsMap.get(window);
                int index = list2.indexOf(editor);
                LOG.assertTrue(index >= 0);
                if (list2.isEmpty()) {
                    return;
                }
                for (int i2 = index - 1; i2 >= 0; --i2) {
                    list2.set(i2 + 1, list2.get(i2));
                }
                list2.set(0, editor);
                EditorTracker.this.setActiveWindow(window);
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
            }
        };
        contentComponent.addFocusListener(focusListener2);
        this.myExecuteOnEditorRelease.put(editor, () -> {
            component2.removePropertyChangeListener("ancestor", propertyChangeListener);
            contentComponent.removeFocusListener(focusListener2);
        });
    }

    private void editorReleased(@NotNull EditorFactoryEvent event) {
        Editor editor = event.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        this.editorReleasedImpl(editor);
    }

    protected void editorReleasedImpl(@NotNull Editor editor) {
        this.unregisterEditor(editor);
        this.executeOnRelease(editor);
    }

    public void dispose() {
        this.executeOnRelease(null);
    }

    private void executeOnRelease(@Nullable Editor editor) {
        if (editor == null) {
            for (Runnable r : this.myExecuteOnEditorRelease.values()) {
                r.run();
            }
            this.myExecuteOnEditorRelease.clear();
        } else {
            Runnable runnable2 = this.myExecuteOnEditorRelease.get(editor);
            if (runnable2 != null) {
                runnable2.run();
                this.myExecuteOnEditorRelease.remove(editor);
            }
        }
    }

    static final class MyAppLevelEditorFactoryListener
    implements EditorFactoryListener {
        MyAppLevelEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Project project = event.getEditor().getProject();
            if (project != null) {
                EditorTracker.getInstance(project).editorCreated(event);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Project project = event.getEditor().getProject();
            if (project != null) {
                EditorTracker.getInstance(project).editorReleased(event);
            }
        }
    }
}

