/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.AnnotatorStatisticsCollector;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.ErrorQuickFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.FactoryMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class DefaultHighlightVisitor
implements HighlightVisitor,
DumbAware {
    private AnnotationHolderImpl myAnnotationHolder;
    private final Map<Language, List<Annotator>> myAnnotators = FactoryMap.create(l -> this.createAnnotators((Language)l));
    private static final Logger LOG = Logger.getInstance(DefaultHighlightVisitor.class);
    private final Project myProject;
    private final boolean myHighlightErrorElements;
    private final boolean myRunAnnotators;
    private final DumbService myDumbService;
    private HighlightInfoHolder myHolder;
    private final boolean myBatchMode;
    private boolean myDumb;
    private final AnnotatorStatisticsCollector myAnnotatorStatisticsCollector = new AnnotatorStatisticsCollector();

    DefaultHighlightVisitor(@NotNull Project project) {
        this(project, true, true, false);
    }

    DefaultHighlightVisitor(@NotNull Project project, boolean highlightErrorElements, boolean runAnnotators, boolean batchMode) {
        this.myProject = project;
        this.myHighlightErrorElements = highlightErrorElements;
        this.myRunAnnotators = runAnnotators;
        this.myDumbService = DumbService.getInstance((Project)project);
        this.myBatchMode = batchMode;
    }

    @Override
    public boolean suitableForFile(@NotNull PsiFile file2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean analyze(@NotNull PsiFile file2, boolean updateWholeFile, final @NotNull HighlightInfoHolder holder, @NotNull Runnable action2) {
        this.myDumb = this.myDumbService.isDumb();
        this.myHolder = holder;
        this.myAnnotationHolder = new AnnotationHolderImpl(holder.getAnnotationSession(), this.myBatchMode){

            @Override
            void queueToUpdateIncrementally() {
                if (!this.isEmpty()) {
                    DefaultHighlightVisitor.this.myAnnotatorStatisticsCollector.reportAnnotationProduced(this.myCurrentAnnotator, (Annotation)this.get(0));
                    for (int i2 = 0; i2 < this.size(); ++i2) {
                        Annotation annotation = (Annotation)this.get(i2);
                        holder.add(HighlightInfo.fromAnnotation(annotation, DefaultHighlightVisitor.this.myBatchMode));
                    }
                    holder.queueToUpdateIncrementally();
                    this.clear();
                }
            }
        };
        try {
            action2.run();
            this.myAnnotationHolder.assertAllAnnotationsCreated();
        }
        finally {
            this.myAnnotators.clear();
            this.myHolder = null;
            this.myAnnotationHolder = null;
            this.myAnnotatorStatisticsCollector.reportAnalysisFinished(this.myProject, holder.getAnnotationSession(), file2);
        }
        return true;
    }

    @Override
    public void visit(@NotNull PsiElement element2) {
        if (element2 instanceof PsiErrorElement) {
            if (this.myHighlightErrorElements) {
                this.visitErrorElement((PsiErrorElement)element2);
            }
        } else if (this.myRunAnnotators) {
            this.runAnnotators(element2);
        }
    }

    @Override
    @NotNull
    public HighlightVisitor clone() {
        return new DefaultHighlightVisitor(this.myProject, this.myHighlightErrorElements, this.myRunAnnotators, this.myBatchMode);
    }

    private void runAnnotators(@NotNull PsiElement element2) {
        List<Annotator> annotators = this.myAnnotators.get(element2.getLanguage());
        if (!annotators.isEmpty()) {
            AnnotationHolderImpl holder = this.myAnnotationHolder;
            holder.myCurrentElement = element2;
            for (Annotator annotator : annotators) {
                if (this.myDumb && !DumbService.isDumbAware((Object)annotator)) continue;
                ProgressManager.checkCanceled();
                holder.myCurrentAnnotator = annotator;
                annotator.annotate(element2, (AnnotationHolder)holder);
                holder.queueToUpdateIncrementally();
            }
        }
    }

    private void visitErrorElement(@NotNull PsiErrorElement element2) {
        if (HighlightErrorFilter.EP_NAME.findFirstSafe((AreaInstance)this.myProject, filter2 -> !filter2.shouldHighlightErrorElement(element2)) != null) {
            return;
        }
        this.myHolder.add(DefaultHighlightVisitor.createErrorElementInfo(element2));
    }

    private static HighlightInfo createErrorElementInfo(@NotNull PsiErrorElement element2) {
        HighlightInfo info = DefaultHighlightVisitor.createInfoWithoutFixes(element2);
        if (info != null) {
            for (ErrorQuickFixProvider provider : ErrorQuickFixProvider.EP_NAME.getExtensionList()) {
                provider.registerErrorQuickFix(element2, info);
            }
        }
        return info;
    }

    private static HighlightInfo createInfoWithoutFixes(@NotNull PsiErrorElement element2) {
        int end;
        int start2;
        String text;
        TextRange range2 = element2.getTextRange();
        String errorDescription = element2.getErrorDescription();
        if (!range2.isEmpty()) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(range2).descriptionAndTooltip(errorDescription).create();
        }
        int offset = range2.getStartOffset();
        PsiFile containingFile = element2.getContainingFile();
        int fileLength = containingFile.getTextLength();
        FileViewProvider viewProvider = containingFile.getViewProvider();
        PsiElement elementAtOffset = viewProvider.findElementAt(offset, LanguageUtil.getRootLanguage((PsiElement)element2));
        String string = text = elementAtOffset == null ? null : elementAtOffset.getText();
        if (offset < fileLength && text != null && !StringUtil.startsWithChar((CharSequence)text, (char)'\n') && !StringUtil.startsWithChar((CharSequence)text, (char)'\r')) {
            HighlightInfo.Builder builder2 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(offset, offset + 1);
            builder2.descriptionAndTooltip(errorDescription);
            return builder2.create();
        }
        if (offset > 0) {
            start2 = offset;
            end = offset;
        } else {
            start2 = offset;
            end = offset < fileLength ? offset + 1 : offset;
        }
        HighlightInfo.Builder builder3 = HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)element2, start2, end);
        builder3.descriptionAndTooltip(errorDescription);
        builder3.endOfLine();
        return builder3.create();
    }

    @NotNull
    private List<Annotator> cloneTemplates(@NotNull Collection<? extends Annotator> templates) {
        ArrayList<Annotator> result2 = new ArrayList<Annotator>(templates.size());
        for (Annotator annotator : templates) {
            Annotator annotator2;
            try {
                annotator2 = (Annotator)ReflectionUtil.newInstance(annotator.getClass());
            }
            catch (Exception e) {
                LOG.error((Throwable)PluginException.createByClass((Throwable)e, annotator.getClass()));
                continue;
            }
            result2.add(annotator2);
            this.myAnnotatorStatisticsCollector.reportNewAnnotatorCreated(annotator2);
        }
        return result2;
    }

    @NotNull
    private List<Annotator> createAnnotators(@NotNull Language language) {
        return this.cloneTemplates(LanguageAnnotators.INSTANCE.allForLanguageOrAny(language));
    }
}

