/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.ProjectTopics;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.LineMarkerProviders;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.EditorTrackerListener;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.GotoNextErrorHandler;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.PsiChangeHandler;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.SilentChangeVetoer;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSettingListener;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.ide.AppLifecycleListener;
import com.intellij.ide.PowerSaveMode;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.lang.ExternalLanguageAnnotators;
import com.intellij.lang.LanguageAnnotators;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ModalityStateListener;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEventMulticasterEx;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.profile.ProfileChangeAdapter;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ThreeState;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DaemonListeners
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DaemonListeners.class);
    private final Project myProject;
    private final DaemonCodeAnalyzerImpl myDaemonCodeAnalyzer;
    private boolean myEscPressed;
    private volatile boolean cutOperationJustHappened;
    private final DaemonCodeAnalyzer.DaemonListener myDaemonEventPublisher;
    private List<Editor> myActiveEditors = Collections.emptyList();
    private static final Key<Boolean> DAEMON_INITIALIZED = Key.create((String)"DAEMON_INITIALIZED");

    public static DaemonListeners getInstance(Project project) {
        return (DaemonListeners)project.getComponent(DaemonListeners.class);
    }

    public DaemonListeners(final @NotNull Project project) {
        this.myProject = project;
        this.myDaemonCodeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)this.myProject);
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, null, (Object)Boolean.TRUE);
        if (!replaced) {
            LOG.error("Daemon listeners already initialized for the project " + this.myProject);
        }
        MessageBus messageBus = this.myProject.getMessageBus();
        this.myDaemonEventPublisher = (DaemonCodeAnalyzer.DaemonListener)messageBus.syncPublisher(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC);
        if (project.isDefault()) {
            return;
        }
        MessageBusConnection connection = messageBus.connect();
        connection.subscribe(AppLifecycleListener.TOPIC, (Object)new AppLifecycleListener(){

            @Override
            public void appClosing() {
                DaemonListeners.this.stopDaemon(false, "App closing");
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        EditorEventMulticasterEx eventMulticaster = (EditorEventMulticasterEx)editorFactory.getEventMulticaster();
        eventMulticaster.addDocumentListener(new DocumentListener(){

            public void beforeDocumentChange(@NotNull DocumentEvent e) {
                Project project;
                Document document = e.getDocument();
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                Project project2 = project = virtualFile == null ? null : ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
                if (!DaemonListeners.this.myProject.isDisposed() && ApplicationManager.getApplication().isDispatchThread() && DaemonListeners.this.worthBothering(document, project)) {
                    DaemonListeners.this.stopDaemon(true, "Document change");
                    UpdateHighlightersUtil.updateHighlightersByTyping(DaemonListeners.this.myProject, e);
                }
            }
        }, this);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            eventMulticaster.addCaretListener(new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    Editor editor = e.getEditor();
                    if (EditorActivityManager.getInstance().isVisible(editor) && DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (!DaemonListeners.this.myProject.isDisposed() && EditorActivityManager.getInstance().isVisible(editor)) {
                                IntentionsUI.getInstance(DaemonListeners.this.myProject).invalidate();
                            }
                        }, ModalityState.current(), DaemonListeners.this.myProject.getDisposed());
                    }
                }
            }, this);
        }
        connection.subscribe(EditorTrackerListener.TOPIC, (Object)new EditorTrackerListener(){

            @Override
            public void activeEditorsChanged(@NotNull List<Editor> activeEditors) {
                if (DaemonListeners.this.myActiveEditors.equals(activeEditors)) {
                    return;
                }
                DaemonListeners.this.myActiveEditors = new ArrayList<Editor>(activeEditors);
                DaemonListeners.this.stopDaemon(true, "Active editor change");
                if (ApplicationManager.getApplication().isDispatchThread() && LaterInvocator.isInModalContext()) {
                    DaemonListeners.this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(true);
                }
                ErrorStripeUpdateManager errorStripeUpdateManager = ErrorStripeUpdateManager.getInstance(DaemonListeners.this.myProject);
                for (Editor editor : activeEditors) {
                    errorStripeUpdateManager.repaintErrorStripePanel(editor);
                }
            }
        });
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                if (DaemonListeners.this.myProject.isDisposed()) {
                    return;
                }
                Editor editor = event.getEditor();
                Document document = editor.getDocument();
                Project editorProject = editor.getProject();
                PsiFile file2 = editorProject == null ? null : PsiDocumentManager.getInstance((Project)editorProject).getPsiFile(document);
                boolean showing2 = EditorActivityManager.getInstance().isVisible(editor);
                boolean worthBothering = DaemonListeners.this.worthBothering(document, editorProject);
                if (!showing2 || !worthBothering) {
                    LOG.debug("Not worth bothering about editor created for : " + file2 + " because editor isShowing(): " + showing2 + "; project is open and file is mine: " + worthBothering);
                    return;
                }
                ErrorStripeUpdateManager.getInstance(DaemonListeners.this.myProject).repaintErrorStripePanel(editor);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                DaemonListeners.this.myActiveEditors.remove(event.getEditor());
                UIUtil.invokeLaterIfNeeded(() -> {
                    IntentionsUI intentionUI = (IntentionsUI)DaemonListeners.this.myProject.getServiceIfCreated(IntentionsUI.class);
                    if (intentionUI != null) {
                        intentionUI.invalidate();
                    }
                });
            }
        }, (Disposable)this);
        PsiManager.getInstance((Project)this.myProject).addPsiTreeChangeListener((PsiTreeChangeListener)new PsiChangeHandler(this.myProject, connection, this), (Disposable)this);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Project roots changed");
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode started");
            }

            public void exitDumbMode() {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Dumb mode finished");
            }
        });
        connection.subscribe(PowerSaveMode.TOPIC, () -> this.stopDaemon(true, "Power save mode change"));
        connection.subscribe(EditorColorsManager.TOPIC, __ -> this.stopDaemonAndRestartAllFiles("Editor color scheme changed"));
        connection.subscribe(CommandListener.TOPIC, (Object)new MyCommandListener());
        connection.subscribe(ProfileChangeAdapter.TOPIC, (Object)new MyProfileChangeListener());
        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)new MyApplicationListener(), (Disposable)project);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, (Object)new MyTodoListener());
        connection.subscribe(AnActionListener.TOPIC, (Object)new MyAnActionListener());
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                boolean isDaemonShouldBeStopped = false;
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
                    VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)vFileEvent;
                    String propertyName = e.getPropertyName();
                    if ("name".equals(propertyName)) {
                        this.fileRenamed(e);
                    }
                    if (isDaemonShouldBeStopped || propertyName.equals("writable")) continue;
                    isDaemonShouldBeStopped = true;
                }
                if (isDaemonShouldBeStopped) {
                    DaemonListeners.this.stopDaemon(true, "Virtual file property change");
                }
            }

            private void fileRenamed(@NotNull VFilePropertyChangeEvent event) {
                PsiFile psiFile;
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Virtual file name changed");
                VirtualFile virtualFile = event.getFile();
                PsiFile psiFile2 = psiFile = !virtualFile.isValid() ? null : PsiManagerEx.getInstanceEx(DaemonListeners.this.myProject).getFileManager().getCachedPsiFile(virtualFile);
                if (psiFile == null || DaemonListeners.this.myDaemonCodeAnalyzer.isHighlightingAvailable(psiFile)) {
                    return;
                }
                Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
                if (document == null) {
                    return;
                }
                UpdateHighlightersUtil.setHighlightersToEditor(DaemonListeners.this.myProject, document, 0, document.getTextLength(), Collections.emptyList(), null, 4);
            }
        });
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                IntentionsUI.getInstance(project).invalidate();
            }
        });
        eventMulticaster.addErrorStripeListener(new ErrorStripeListener(){

            @Override
            public void errorMarkerClicked(@NotNull ErrorStripeEvent e) {
                RangeHighlighter highlighter = e.getHighlighter();
                if (!highlighter.isValid()) {
                    return;
                }
                HighlightInfo info = HighlightInfo.fromRangeHighlighter(highlighter);
                if (info != null) {
                    GotoNextErrorHandler.navigateToError(DaemonListeners.this.myProject, e.getEditor(), info, null);
                }
            }
        }, this);
        LaterInvocator.addModalityStateListener(new ModalityStateListener(){

            public void beforeModalityStateChanged(boolean entering, @NotNull Object modalEntity) {
                boolean inModalContext = Registry.is((String)"ide.perProjectModality") || LaterInvocator.isInModalContext();
                DaemonListeners.this.stopDaemon(inModalContext, "Modality change. Was modal: " + inModalContext);
                DaemonListeners.this.myDaemonCodeAnalyzer.setUpdateByTimerEnabled(inModalContext);
            }
        }, this);
        connection.subscribe(SeverityRegistrar.SEVERITIES_CHANGED_TOPIC, () -> this.stopDaemonAndRestartAllFiles("Severities changed"));
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetRenamed(@NotNull Facet facet, @NotNull String oldName) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet renamed: " + oldName + " -> " + facet.getName());
            }

            public void facetAdded(@NotNull Facet facet) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet added: " + facet.getName());
            }

            public void facetRemoved(@NotNull Facet facet) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet removed: " + facet.getName());
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("facet changed: " + facet.getName());
            }
        });
        this.restartOnExtensionChange(LanguageAnnotators.EP_NAME, "annotators list changed");
        this.restartOnExtensionChange(LineMarkerProviders.EP_NAME, "line marker providers list changed");
        this.restartOnExtensionChange(ExternalLanguageAnnotators.EP_NAME, "external annotators list changed");
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)DaemonListeners.this.myProject).getModificationTracker()).incCounter();
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Plugin installed");
            }

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)DaemonListeners.this.myProject).getModificationTracker()).incCounter();
                DaemonListeners.this.stopDaemon(false, "Plugin will be uninstalled");
                DaemonListeners.this.removeHighlightersOnPluginUnload((PluginDescriptor)pluginDescriptor);
                DaemonListeners.this.myDaemonCodeAnalyzer.clearProgressIndicator();
                DaemonListeners.this.myDaemonCodeAnalyzer.cleanAllFileLevelHighlights();
                IntentionsUI.getInstance(project).invalidate();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Plugin unloaded");
            }
        });
        connection.subscribe(FileHighlightingSettingListener.SETTING_CHANGE, (root, setting) -> WriteAction.run(() -> {
            PsiFile file2 = root.getContainingFile();
            if (file2 != null) {
                ((PsiModificationTrackerImpl)PsiManager.getInstance((Project)this.myProject).getModificationTracker()).incCounter();
            }
        }));
    }

    private <T, U extends KeyedLazyInstance<T>> void restartOnExtensionChange(@NotNull ExtensionPointName<U> name, @NotNull String message) {
        name.addChangeListener(() -> this.stopDaemonAndRestartAllFiles(message), (Disposable)this);
    }

    private boolean worthBothering(@Nullable Document document, Project project) {
        if (document == null) {
            return true;
        }
        if (project != null && project != this.myProject) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
        return psiFile != null && psiFile.isPhysical() && psiFile.getOriginalFile() == psiFile;
    }

    public void dispose() {
        this.stopDaemonAndRestartAllFiles("Project closed");
        boolean replaced = ((UserDataHolderEx)this.myProject).replace(DAEMON_INITIALIZED, (Object)Boolean.TRUE, (Object)Boolean.FALSE);
        LOG.assertTrue(replaced, (Object)("Daemon listeners already disposed for the project " + this.myProject));
    }

    public static boolean canChangeFileSilently(@NotNull PsiFileSystemItem file2) {
        Project project = file2.getProject();
        DaemonListeners listeners = DaemonListeners.getInstance(project);
        if (listeners == null) {
            return true;
        }
        if (listeners.cutOperationJustHappened) {
            return false;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file2 instanceof PsiCodeFragment) {
            return true;
        }
        if (ScratchUtil.isScratch(virtualFile)) {
            return listeners.canUndo(virtualFile);
        }
        if (!ModuleUtilCore.projectContainsFile((Project)project, (VirtualFile)virtualFile, (boolean)false)) {
            return false;
        }
        for (SilentChangeVetoer extension : SilentChangeVetoer.EP_NAME.getExtensionList()) {
            ThreeState result2 = extension.canChangeFileSilently(project, virtualFile);
            if (result2 == ThreeState.UNSURE) continue;
            return result2.toBoolean();
        }
        return listeners.canUndo(virtualFile);
    }

    private boolean canUndo(@NotNull VirtualFile virtualFile) {
        FileEditor[] editors = FileEditorManager.getInstance((Project)this.myProject).getEditors(virtualFile);
        if (editors.length == 0) {
            return false;
        }
        UndoManager undoManager = UndoManager.getInstance((Project)this.myProject);
        for (FileEditor editor : editors) {
            if (!undoManager.isUndoAvailable(editor)) continue;
            return true;
        }
        return false;
    }

    private void stopDaemon(boolean toRestartAlarm, @NonNls @NotNull String reason) {
        if (this.myDaemonCodeAnalyzer.stopProcess(toRestartAlarm, reason)) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private void stopDaemonAndRestartAllFiles(@NotNull String reason) {
        if (this.myDaemonCodeAnalyzer.doRestart(reason) && !this.myProject.isDisposed()) {
            this.myDaemonEventPublisher.daemonCancelEventOccurred(reason);
        }
    }

    private void removeHighlightersOnPluginUnload(@NotNull PluginDescriptor pluginDescriptor) {
        for (FileEditor fileEditor : FileEditorManager.getInstance((Project)this.myProject).getAllEditors()) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            DaemonListeners.removeHighlightersOnPluginUnload(editor.getMarkupModel(), pluginDescriptor);
            MarkupModel documentMarkupModel = DocumentMarkupModel.forDocument(editor.getDocument(), this.myProject, false);
            if (documentMarkupModel == null) continue;
            DaemonListeners.removeHighlightersOnPluginUnload(documentMarkupModel, pluginDescriptor);
        }
    }

    private static void removeHighlightersOnPluginUnload(@NotNull MarkupModel model, @NotNull PluginDescriptor pluginDescriptor) {
        for (RangeHighlighter highlighter : model.getAllHighlighters()) {
            CustomHighlighterRenderer renderer;
            if (!(highlighter instanceof RangeHighlighterEx) || !((RangeHighlighterEx)highlighter).isPersistent()) {
                model.removeHighlighter(highlighter);
                continue;
            }
            if (!(pluginDescriptor.getPluginClassLoader() instanceof PluginClassLoader) || (renderer = highlighter.getCustomRenderer()) == null || renderer.getClass().getClassLoader() != pluginDescriptor.getPluginClassLoader()) continue;
            model.removeHighlighter(highlighter);
        }
    }

    private final class MyAnActionListener
    implements AnActionListener {
        private AnAction cachedEscapeAction;

        private MyAnActionListener() {
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            if (this.cachedEscapeAction == null) {
                DaemonListeners.this.myEscPressed = "EditorEscape".equals(event.getActionManager().getId(action2));
                if (DaemonListeners.this.myEscPressed) {
                    this.cachedEscapeAction = action2;
                }
            } else {
                DaemonListeners.this.myEscPressed = this.cachedEscapeAction == action2;
            }
        }

        public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor != null && !DaemonListeners.this.worthBothering(editor.getDocument(), editor.getProject())) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Editor typing");
        }
    }

    private class MyProfileChangeListener
    implements ProfileChangeAdapter {
        private MyProfileChangeListener() {
        }

        public void profileChanged(InspectionProfile profile) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile changed");
        }

        public void profileActivated(InspectionProfile oldProfile, @Nullable InspectionProfile profile) {
            DaemonListeners.this.stopDaemonAndRestartAllFiles("Profile activated");
        }

        public void profilesInitialized() {
            AppUIUtil.invokeLaterIfProjectAlive(DaemonListeners.this.myProject, () -> DaemonListeners.this.stopDaemonAndRestartAllFiles("Inspection profiles activated"));
        }
    }

    private final class MyTodoListener
    implements PropertyChangeListener {
        private MyTodoListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            if ("todoPatterns".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo patterns changed");
            } else if ("multiLine".equals(evt.getPropertyName())) {
                DaemonListeners.this.stopDaemonAndRestartAllFiles("Todo multi-line detection changed");
            }
        }
    }

    private final class MyCommandListener
    implements CommandListener {
        private MyCommandListener() {
        }

        public void commandStarted(@NotNull CommandEvent event) {
            Document affectedDocument = this.extractDocumentFromCommand(event);
            if (!DaemonListeners.this.worthBothering(affectedDocument, event.getProject())) {
                return;
            }
            DaemonListeners.this.cutOperationJustHappened = Comparing.strEqual((String)Holder.myCutActionName, (String)event.getCommandName());
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cancelling code highlighting by command:" + event.getCommand());
            }
            DaemonListeners.this.stopDaemon(false, "Command start");
        }

        @Nullable
        private Document extractDocumentFromCommand(@NotNull CommandEvent event) {
            Document affectedDocument = event.getDocument();
            if (affectedDocument != null) {
                return affectedDocument;
            }
            Object id2 = event.getCommandGroupId();
            if (id2 instanceof Document) {
                affectedDocument = (Document)id2;
            } else if (id2 instanceof DocCommandGroupId) {
                affectedDocument = ((DocCommandGroupId)id2).getDocument();
            }
            return affectedDocument;
        }

        public void commandFinished(@NotNull CommandEvent event) {
            Document affectedDocument = this.extractDocumentFromCommand(event);
            if (!DaemonListeners.this.worthBothering(affectedDocument, event.getProject())) {
                return;
            }
            if (DaemonListeners.this.myEscPressed) {
                DaemonListeners.this.myEscPressed = false;
                if (affectedDocument != null && !DaemonListeners.this.myDaemonCodeAnalyzer.getFileStatusMap().allDirtyScopesAreNull(affectedDocument)) {
                    DaemonListeners.this.stopDaemon(true, "Command finish");
                }
            } else if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                DaemonListeners.this.stopDaemon(true, "Command finish");
            }
        }
    }

    private static final class Holder {
        private static final String myCutActionName = ActionManager.getInstance().getAction("EditorCut").getTemplatePresentation().getText();

        private Holder() {
        }
    }

    private class MyApplicationListener
    implements ApplicationListener {
        private MyApplicationListener() {
        }

        public void beforeWriteActionStart(@NotNull Object action2) {
            if (!DaemonListeners.this.myDaemonCodeAnalyzer.isRunning()) {
                return;
            }
            DaemonListeners.this.stopDaemon(true, "Write action start");
        }

        public void writeActionFinished(@NotNull Object action2) {
            DaemonListeners.this.stopDaemon(true, "Write action finish");
        }
    }
}

