/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.ConfigureHighlightingLevelKt;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class DaemonEditorPopup
extends PopupHandler {
    private final Project myProject;
    private final Editor myEditor;

    DaemonEditorPopup(@NotNull Project project, @NotNull Editor editor) {
        this.myProject = project;
        this.myEditor = editor;
    }

    public void invokePopup(final Component comp, final int x, final int y) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        if (file2 == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DefaultActionGroup gotoGroup = DaemonEditorPopup.createGotoGroup();
        actionGroup.add((AnAction)gotoGroup);
        actionGroup.addSeparator();
        actionGroup.add(new AnAction(EditorBundle.messagePointer((String)"customize.highlighting.level.menu.item", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                JBPopup popup2 = ConfigureHighlightingLevelKt.getConfigureHighlightingLevelPopup(e.getDataContext());
                if (popup2 != null) {
                    popup2.show(new RelativePoint(comp, new Point(x, y)));
                }
            }
        });
        if (!UIUtil.uiParents((Component)this.myEditor.getComponent(), (boolean)false).filter(EditorWindowHolder.class).isEmpty()) {
            actionGroup.addSeparator();
            actionGroup.add((AnAction)new ToggleAction(IdeBundle.message((String)"checkbox.show.editor.preview.popup", (Object[])new Object[0])){

                public boolean isSelected(@NotNull AnActionEvent e) {
                    return UISettings.getInstance().getShowEditorToolTip();
                }

                public void setSelected(@NotNull AnActionEvent e, boolean state) {
                    UISettings.getInstance().setShowEditorToolTip(state);
                    UISettings.getInstance().fireUISettingsChanged();
                }
            });
        }
        ActionPopupMenu editorPopup = actionManager.createActionPopupMenu("RightEditorGutterPopup", (ActionGroup)actionGroup);
        if (DaemonCodeAnalyzer.getInstance((Project)this.myProject).isHighlightingAvailable(file2)) {
            UIEventLogger.logUIEvent((UIEventId)UIEventId.DaemonEditorPopupInvoked);
            editorPopup.getComponent().show(comp, x, y);
        }
    }

    @NotNull
    static DefaultActionGroup createGotoGroup() {
        Shortcut shortcut = KeymapUtil.getPrimaryShortcut((String)"GotoNextError");
        String shortcutText = shortcut != null ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")" : "";
        DefaultActionGroup gotoGroup = DefaultActionGroup.createPopupGroup(() -> CodeInsightBundle.message((String)"popup.title.next.error.action.0.goes.through", (Object[])new Object[]{shortcutText}));
        gotoGroup.add((AnAction)new ToggleAction(EditorBundle.message((String)"errors.panel.go.to.errors.first.radio", (Object[])new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return DaemonCodeAnalyzerSettings.getInstance().isNextErrorActionGoesToErrorsFirst();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                DaemonCodeAnalyzerSettings.getInstance().setNextErrorActionGoesToErrorsFirst(state);
            }

            public boolean isDumbAware() {
                return true;
            }
        });
        gotoGroup.add((AnAction)new ToggleAction(EditorBundle.message((String)"errors.panel.go.to.next.error.warning.radio", (Object[])new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                return !DaemonCodeAnalyzerSettings.getInstance().isNextErrorActionGoesToErrorsFirst();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                DaemonCodeAnalyzerSettings.getInstance().setNextErrorActionGoesToErrorsFirst(!state);
            }

            public boolean isDumbAware() {
                return true;
            }
        });
        return gotoGroup;
    }
}

