/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IntentionMenuContributor;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CleanupIntentionMenuContributor
implements IntentionMenuContributor {
    @Override
    public void collectActions(@NotNull Editor hostEditor, @NotNull PsiFile hostFile, @NotNull ShowIntentionsPass.IntentionsInfo intentions, int passIdToShowIntentionsFor, int offset) {
        boolean cleanup = CleanupIntentionMenuContributor.appendCleanupCode(intentions.inspectionFixesToShow, hostFile);
        if (!cleanup) {
            CleanupIntentionMenuContributor.appendCleanupCode(intentions.errorFixesToShow, hostFile);
        }
    }

    private static boolean appendCleanupCode(@NotNull List<HighlightInfo.IntentionActionDescriptor> actionDescriptors, @NotNull PsiFile file2) {
        for (HighlightInfo.IntentionActionDescriptor descriptor2 : actionDescriptors) {
            if (!descriptor2.canCleanup((PsiElement)file2)) continue;
            IntentionManager manager = IntentionManager.getInstance();
            actionDescriptors.add(new HighlightInfo.IntentionActionDescriptor(manager.createCleanupAllIntention(), manager.getCleanupIntentionOptions(), "Code Cleanup Options"));
            return true;
        }
        return false;
    }
}

