/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.util.Consumer;
import com.intellij.util.JdomKt;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InspectionProfileConvertor {
    private final Map<String, HighlightDisplayLevel> myDisplayLevelMap = new HashMap<String, HighlightDisplayLevel>();
    @NonNls
    public static final String OLD_HIGHTLIGHTING_SETTINGS_PROFILE = "EditorHighlightingSettings";
    @NonNls
    public static final String OLD_DEFAUL_PROFILE = "OldDefaultProfile";
    private static final Logger LOG = Logger.getInstance(InspectionProfileConvertor.class);
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String VERSION_ATT = "version";
    @NonNls
    private static final String OPTION_TAG = "option";
    @NonNls
    private static final String DISPLAY_LEVEL_MAP_OPTION = "DISPLAY_LEVEL_MAP";
    @NonNls
    protected static final String VALUE_ATT = "value";
    @NonNls
    private static final String DEFAULT_XML = "Default.xml";
    @NonNls
    private static final String XML_EXTENSION = ".xml";
    @NonNls
    public static final String LEVEL_ATT = "level";
    private final InspectionProfileManager myManager;

    public InspectionProfileConvertor(@NotNull InspectionProfileManager manager) {
        this.myManager = manager;
        InspectionProfileConvertor.renameOldDefaultsProfile();
    }

    private boolean retrieveOldSettings(@NotNull Element element2) {
        boolean hasOldSettings = false;
        for (Element option2 : element2.getChildren(OPTION_TAG)) {
            String name = option2.getAttributeValue(NAME_ATT);
            if (name == null) continue;
            hasOldSettings |= this.processElement(option2, name);
        }
        return hasOldSettings;
    }

    protected boolean processElement(Element option2, String name) {
        if (name.equals(DISPLAY_LEVEL_MAP_OPTION)) {
            for (Element e : option2.getChild(VALUE_ATT).getChildren()) {
                HighlightDisplayLevel level;
                String key = e.getName();
                String levelName = e.getAttributeValue(LEVEL_ATT);
                HighlightSeverity severity = this.myManager.getSeverityRegistrar().getSeverity(levelName);
                HighlightDisplayLevel highlightDisplayLevel = level = severity == null ? null : HighlightDisplayLevel.find((HighlightSeverity)severity);
                if (level == null) continue;
                this.myDisplayLevelMap.put(key, level);
            }
            return true;
        }
        return false;
    }

    public void storeEditorHighlightingProfile(@NotNull Element element2, @NotNull InspectionProfileImpl editorProfile) {
        if (this.retrieveOldSettings(element2)) {
            editorProfile.modifyProfile((Consumer<? super InspectionProfileModifiableModel>)((Consumer)it -> this.fillErrorLevels((InspectionProfileImpl)it)));
        }
    }

    private static void renameOldDefaultsProfile() {
        Path directoryPath = Paths.get(PathManager.getConfigPath(), "inspection");
        if (!PathKt.exists((Path)directoryPath)) {
            return;
        }
        File[] files2 = directoryPath.toFile().listFiles(pathname -> pathname.getPath().endsWith(File.separator + DEFAULT_XML));
        if (files2 == null || files2.length != 1 || !files2[0].isFile() || files2[0].length() == 0L) {
            return;
        }
        try {
            Element root = JDOMUtil.load((Path)files2[0].toPath());
            if (root.getAttributeValue(VERSION_ATT) == null) {
                JdomKt.write((Parent)root, (Path)directoryPath.resolve("OldDefaultProfile.xml"));
                FileUtil.delete((File)files2[0]);
            }
        }
        catch (IOException | JDOMException e) {
            LOG.error(e);
        }
    }

    protected void fillErrorLevels(InspectionProfileImpl profile) {
        LOG.assertTrue(profile.getInspectionTools(null) != null, (Object)"Profile was not correctly init");
        for (String shortName : this.myDisplayLevelMap.keySet()) {
            HighlightDisplayLevel level = this.myDisplayLevelMap.get(shortName);
            HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
            if (key == null) continue;
            if (level != HighlightDisplayLevel.DO_NOT_SHOW) {
                profile.enableTool(shortName, null);
            }
            if (level == null || level == HighlightDisplayLevel.DO_NOT_SHOW) {
                level = HighlightDisplayLevel.WARNING;
            }
            profile.setErrorLevel(key, level, null);
        }
    }
}

