/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.impl;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionPhase;
import com.intellij.codeInsight.completion.CompletionPhaseListener;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessBase;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionThreadingBase;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.StatisticsWeigher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiveTemplateWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.Weigher;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.messages.MessageBusConnection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CompletionServiceImpl
extends BaseCompletionService {
    private static final Logger LOG = Logger.getInstance(CompletionServiceImpl.class);
    private static volatile CompletionPhase ourPhase = CompletionPhase.NoCompletion;
    private static boolean ourTracePhases;
    private static Throwable ourPhaseTrace;

    public CompletionServiceImpl() {
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect();
        connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectClosing(@NotNull Project project) {
                CompletionProgressIndicator indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
                if (indicator != null && indicator.getProject() == project) {
                    indicator.closeAndFinish(true);
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                } else if (indicator == null) {
                    CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
                }
            }
        });
        connection.subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                CompletionServiceImpl.setCompletionPhase(CompletionPhase.NoCompletion);
            }
        });
    }

    public static CompletionServiceImpl getCompletionService() {
        return (CompletionServiceImpl)CompletionService.getCompletionService();
    }

    @Override
    public void setAdvertisementText(@Nullable String text) {
        if (text == null) {
            return;
        }
        CompletionProgressIndicator completion = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        if (completion != null) {
            completion.addAdvertisement(text, null);
        }
    }

    @Override
    protected CompletionResultSet createResultSet(@NotNull CompletionParameters parameters2, @NotNull Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, @NotNull PrefixMatcher matcher) {
        return new CompletionResultSetImpl(consumer, matcher, contributor, parameters2, null, null);
    }

    @Override
    public CompletionProcess getCurrentCompletion() {
        CompletionProgressIndicator indicator = CompletionServiceImpl.getCurrentCompletionProgressIndicator();
        return indicator != null ? indicator : this.myApiCompletionProcess;
    }

    public static CompletionProgressIndicator getCurrentCompletionProgressIndicator() {
        if (CompletionServiceImpl.isPhase(CompletionPhase.BgCalculation.class, CompletionPhase.ItemsCalculated.class, CompletionPhase.CommittingDocuments.class, CompletionPhase.Synchronous.class)) {
            return CompletionServiceImpl.ourPhase.indicator;
        }
        return null;
    }

    @SafeVarargs
    public static void assertPhase(Class<? extends CompletionPhase> ... possibilities) {
        if (!CompletionServiceImpl.isPhase(possibilities)) {
            CompletionServiceImpl.reportPhase();
        }
    }

    private static void reportPhase() {
        LOG.error(ourPhase + (ourPhaseTrace != null ? "; set at " + ExceptionUtil.getThrowableText((Throwable)ourPhaseTrace) : ""));
        ourTracePhases = true;
    }

    @SafeVarargs
    public static boolean isPhase(Class<? extends CompletionPhase> ... possibilities) {
        CompletionPhase phase = CompletionServiceImpl.getCompletionPhase();
        for (Class<? extends CompletionPhase> possibility : possibilities) {
            if (!possibility.isInstance(phase)) continue;
            return true;
        }
        return false;
    }

    public static void setCompletionPhase(@NotNull CompletionPhase phase) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        CompletionPhase oldPhase = CompletionServiceImpl.getCompletionPhase();
        CompletionProgressIndicator oldIndicator = oldPhase.indicator;
        if (oldIndicator != null && !(phase instanceof CompletionPhase.BgCalculation) && oldIndicator.isRunning() && !oldIndicator.isCanceled()) {
            LOG.error("don't change phase during running completion: oldPhase=" + oldPhase);
        }
        boolean wasCompletionRunning = CompletionServiceImpl.isRunningPhase(oldPhase);
        boolean isCompletionRunning = CompletionServiceImpl.isRunningPhase(phase);
        if (isCompletionRunning != wasCompletionRunning) {
            ((CompletionPhaseListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(CompletionPhaseListener.TOPIC)).completionPhaseChanged(isCompletionRunning);
        }
        Disposer.dispose((Disposable)oldPhase);
        ourPhase = phase;
        if (ourTracePhases) {
            ourPhaseTrace = new Throwable();
        }
    }

    private static boolean isRunningPhase(@NotNull CompletionPhase phase) {
        return phase != CompletionPhase.NoCompletion && !(phase instanceof CompletionPhase.ZombiePhase) && !(phase instanceof CompletionPhase.ItemsCalculated);
    }

    public static CompletionPhase getCompletionPhase() {
        return ourPhase;
    }

    @Override
    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        CompletionSorterImpl processed2 = super.addWeighersBefore(sorter);
        return processed2.withClassifier(CompletionSorterImpl.weighingFactory(new LiveTemplateWeigher()));
    }

    @Override
    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher2, final @NotNull CompletionLocation location) {
        CompletionSorterImpl processedSorter = super.processStatsWeigher(sorter, weigher2, location);
        return processedSorter.withClassifier(new ClassifierFactory<LookupElement>("stats"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new StatisticsWeigher.LookupStatisticsWeigher(location, next);
            }
        });
    }

    private static class CompletionResultSetImpl
    extends BaseCompletionService.BaseCompletionResultSet {
        CompletionResultSetImpl(Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters2, @Nullable CompletionSorter sorter, @Nullable CompletionResultSetImpl original) {
            super(consumer, prefixMatcher, contributor, parameters2, sorter, original);
        }

        public void addAllElements(@NotNull Iterable<? extends LookupElement> elements2) {
            CompletionThreadingBase.withBatchUpdate(() -> super.addAllElements(elements2), this.myParameters.getProcess());
        }

        @Override
        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher.equals(this.getPrefixMatcher())) {
                return this;
            }
            return new CompletionResultSetImpl((Consumer<? super CompletionResult>)this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
        }

        @Override
        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            return new CompletionResultSetImpl((Consumer<? super CompletionResult>)this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, sorter, this);
        }

        @Override
        public void addLookupAdvertisement(@NotNull String text) {
            CompletionServiceImpl.getCompletionService().setAdvertisementText(text);
        }

        @Override
        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProcessBase) {
                ((CompletionProcessBase)process2).addWatchedPrefix(this.myParameters.getOffset() - this.getPrefixMatcher().getPrefix().length(), prefixCondition);
            }
        }

        @Override
        public void restartCompletionWhenNothingMatches() {
            CompletionProcess process2 = this.myParameters.getProcess();
            if (process2 instanceof CompletionProgressIndicator) {
                ((CompletionProgressIndicator)process2).getLookup().setStartCompletionWhenNothingMatches(true);
            }
        }
    }
}

