/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.FileElement;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00000\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/codeInsight/completion/OffsetsInFile;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "offsets", "Lcom/intellij/codeInsight/completion/OffsetMap;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInsight/completion/OffsetMap;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffsets", "()Lcom/intellij/codeInsight/completion/OffsetMap;", "copyWithReplacement", "startOffset", "", "endOffset", "replacement", "", "replaceInCopy", "Ljava/util/function/Supplier;", "fileCopy", "toInjectedIfAny", "offset", "toTopLevelFile", "intellij.platform.analysis.impl"})
public final class OffsetsInFile {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final OffsetMap offsets;

    @NotNull
    public final OffsetsInFile toTopLevelFile() {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.file.getProject());
        PsiFile hostFile = manager.getTopLevelFile((PsiElement)this.file);
        if (Intrinsics.areEqual((Object)hostFile, (Object)this.file)) {
            return this;
        }
        Document document = hostFile.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        return new OffsetsInFile(hostFile, this.offsets.mapOffsets(document, (Function)new Function<Integer, Integer>(this, manager){
            final /* synthetic */ OffsetsInFile this$0;
            final /* synthetic */ InjectedLanguageManager $manager;

            public final Integer apply(Integer it) {
                return this.$manager.injectedToHost((PsiElement)this.this$0.getFile(), it.intValue());
            }
            {
                this.this$0 = offsetsInFile;
                this.$manager = injectedLanguageManager;
            }
        }));
    }

    @NotNull
    public final OffsetsInFile toInjectedIfAny(int offset) {
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.file.getProject());
        PsiElement psiElement = manager.findInjectedElementAt(this.file, offset);
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return this;
        }
        PsiElement injected = psiElement;
        VirtualFile virtualFile = injected.getVirtualFile();
        if (virtualFile instanceof VirtualFileWindow) {
            DocumentWindow documentWindow = ((VirtualFileWindow)virtualFile).getDocumentWindow();
            return new OffsetsInFile((PsiFile)injected, this.offsets.mapOffsets((Document)documentWindow, (Function)new Function<Integer, Integer>(documentWindow){
                final /* synthetic */ DocumentWindow $documentWindow;

                public final Integer apply(Integer it) {
                    return this.$documentWindow.hostToInjected(it.intValue());
                }
                {
                    this.$documentWindow = documentWindow;
                }
            }));
        }
        return this;
    }

    @NotNull
    public final OffsetsInFile copyWithReplacement(int startOffset, int endOffset, @NotNull String replacement) {
        PsiElement psiElement = this.file.copy();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        return this.replaceInCopy((PsiFile)psiElement, startOffset, endOffset, replacement).get();
    }

    @NotNull
    public final Supplier<OffsetsInFile> replaceInCopy(@NotNull PsiFile fileCopy, int startOffset, int endOffset, @NotNull String replacement) {
        CharSequence originalText;
        DocumentImpl tempDocument = new DocumentImpl(originalText, StringsKt.contains$default((CharSequence)(originalText = this.offsets.getDocument().getImmutableCharSequence()), (char)'\r', (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)replacement, (char)'\r', (boolean)false, (int)2, null), true);
        OffsetMap tempMap = this.offsets.copyOffsets((Document)tempDocument);
        tempDocument.replaceString(startOffset, endOffset, replacement);
        Document document = fileCopy.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        Document copyDocument = document;
        PomModel pomModel = PomManager.getModel((Project)this.file.getProject());
        if (pomModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.pom.core.impl.PomModelImpl");
        }
        FileASTNode fileASTNode = fileCopy.getNode();
        if (fileASTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.impl.source.tree.FileElement");
        }
        Runnable applyPsiChange = ((PomModelImpl)pomModel).reparseFile(fileCopy, (FileElement)fileASTNode, tempDocument.getImmutableCharSequence());
        return new Supplier<OffsetsInFile>(applyPsiChange, fileCopy, tempMap, copyDocument){
            final /* synthetic */ Runnable $applyPsiChange;
            final /* synthetic */ PsiFile $fileCopy;
            final /* synthetic */ OffsetMap $tempMap;
            final /* synthetic */ Document $copyDocument;

            @NotNull
            public final OffsetsInFile get() {
                block0: {
                    Runnable runnable2 = this.$applyPsiChange;
                    if (runnable2 == null) break block0;
                    runnable2.run();
                }
                return new OffsetsInFile(this.$fileCopy, this.$tempMap.copyOffsets(this.$copyDocument));
            }
            {
                this.$applyPsiChange = runnable2;
                this.$fileCopy = psiFile;
                this.$tempMap = offsetMap;
                this.$copyDocument = document;
            }
        };
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final OffsetMap getOffsets() {
        return this.offsets;
    }

    public OffsetsInFile(@NotNull PsiFile file2, @NotNull OffsetMap offsets2) {
        this.file = file2;
        this.offsets = offsets2;
    }

    public OffsetsInFile(@NotNull PsiFile file2) {
        Document document = file2.getViewProvider().getDocument();
        if (document == null) {
            Intrinsics.throwNpe();
        }
        this(file2, new OffsetMap(document));
    }
}

