/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.AutoCompletionContext;
import com.intellij.codeInsight.completion.AutoCompletionDecision;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class DefaultCompletionContributor
extends CompletionContributor {
    static void addDefaultAdvertisements(LookupImpl lookup2, boolean includePsiFeatures) {
        String shortcut;
        Project project = lookup2.getProject();
        if (CompletionUtil.shouldShowFeature(project, "editing.completion.finishByDotEtc")) {
            lookup2.addAdvertisement(LangBundle.message((String)"completion.dot.etc.ad", (Object[])new Object[0]), null);
        }
        if (!includePsiFeatures) {
            return;
        }
        if (CompletionUtil.shouldShowFeature(project, "editing.completion.finishBySmartEnter") && StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"EditorChooseLookupItemCompleteStatement")))) {
            lookup2.addAdvertisement(LangBundle.message((String)"completion.smart.enter.ad", (Object[])new Object[]{shortcut}), null);
        }
        if ((CompletionUtil.shouldShowFeature(project, "codeassists.quickjavadoc") || CompletionUtil.shouldShowFeature(project, "codeassists.quickjavadoc.lookup")) && StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"QuickJavaDoc")))) {
            lookup2.addAdvertisement(LangBundle.message((String)"completion.quick.javadoc.ad", (Object[])new Object[]{shortcut}), null);
        }
        if ((CompletionUtil.shouldShowFeature(project, "codeassists.quickdefinition") || CompletionUtil.shouldShowFeature(project, "codeassists.quickdefinition.lookup")) && StringUtil.isNotEmpty((String)(shortcut = KeymapUtil.getFirstKeyboardShortcutText((String)"QuickImplementations")))) {
            lookup2.addAdvertisement(LangBundle.message((String)"completion.quick.implementations.ad", (Object[])new Object[]{shortcut}), null);
        }
    }

    public AutoCompletionDecision handleAutoCompletionPossibility(@NotNull AutoCompletionContext context) {
        LookupElement[] items = context.getItems();
        if (items.length == 1) {
            LookupElement item = items[0];
            if (!StringUtil.isEmpty((String)context.getLookup().itemPattern(item)) || context.getParameters().getCompletionType() == CompletionType.SMART) {
                return AutoCompletionDecision.insertItem((LookupElement)item);
            }
        }
        return null;
    }
}

