/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public final class DeclarativeInsertHandler
implements InsertHandler<LookupElement> {
    public final String ignoredCompletionChars;
    public final String valueToInsert;
    public final boolean autoPopup;

    private DeclarativeInsertHandler(@NotNull String ignoredCompletionChars, @NotNull String valueToInsert, boolean autoPopup) {
        this.ignoredCompletionChars = ignoredCompletionChars;
        this.valueToInsert = valueToInsert;
        this.autoPopup = autoPopup;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        if (StringUtil.containsChar((String)this.ignoredCompletionChars, (char)completionChar)) {
            return;
        }
        Project project = editor.getProject();
        if (project != null) {
            CaretModel model = editor.getCaretModel();
            if (this.isValueAlreadyHere(editor)) {
                model.moveToOffset(model.getOffset() + this.valueToInsert.length());
            } else {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)this.valueToInsert);
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
            if (this.autoPopup) {
                AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
            }
        }
    }

    private boolean isValueAlreadyHere(@NotNull Editor editor) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        int valueLength = this.valueToInsert.length();
        return document.getTextLength() >= startOffset + valueLength && document.getText(TextRange.create((int)startOffset, (int)(startOffset + valueLength))).equals(this.valueToInsert);
    }

    public static final class Builder {
        private String myIgnoredCharacters;
        private String myValueToInsert;
        private boolean myTriggerAutoPopup;

        @NotNull
        public Builder disableOnCompletionChars(@NotNull String ignoredChars) {
            this.myIgnoredCharacters = ignoredChars;
            return this;
        }

        @NotNull
        public Builder insertOrMove(@NotNull String value2) {
            this.myValueToInsert = value2;
            return this;
        }

        @NotNull
        public Builder triggerAutoPopup() {
            this.myTriggerAutoPopup = true;
            return this;
        }

        @NotNull
        public DeclarativeInsertHandler build() {
            return new DeclarativeInsertHandler(StringUtil.notNullize((String)this.myIgnoredCharacters), StringUtil.notNullize((String)this.myValueToInsert), this.myTriggerAutoPopup);
        }
    }
}

