/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionData;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.completion.impl.LiftShorterItemsClassifier;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.ClassifierFactory;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.Weigher;
import com.intellij.psi.WeighingService;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionService
extends CompletionService {
    private static final Logger LOG = Logger.getInstance(BaseCompletionService.class);
    @Nullable
    protected CompletionProcess myApiCompletionProcess;
    @ApiStatus.Internal
    public static final Key<CompletionContributor> LOOKUP_ELEMENT_CONTRIBUTOR = Key.create((String)"lookup element contributor");

    public void performCompletion(CompletionParameters parameters2, Consumer<? super CompletionResult> consumer) {
        this.myApiCompletionProcess = parameters2.getProcess();
        try {
            super.performCompletion(parameters2, consumer);
        }
        finally {
            this.myApiCompletionProcess = null;
        }
    }

    public void setAdvertisementText(@Nullable @NlsContexts.PopupAdvertisement String text) {
        if (text == null) {
            return;
        }
        if (this.myApiCompletionProcess instanceof CompletionProcessEx) {
            ((CompletionProcessEx)this.myApiCompletionProcess).addAdvertisement(text, null);
        }
    }

    protected String suggestPrefix(CompletionParameters parameters2) {
        PsiElement position = parameters2.getPosition();
        int offset = parameters2.getOffset();
        TextRange range2 = position.getTextRange();
        assert (range2.containsOffset(offset)) : position + "; " + offset + " not in " + range2;
        return CompletionData.findPrefixStatic(position, offset);
    }

    @NotNull
    protected PrefixMatcher createMatcher(String prefix, boolean typoTolerant) {
        return BaseCompletionService.createMatcher(prefix, true, typoTolerant);
    }

    @NotNull
    private static CamelHumpMatcher createMatcher(String prefix, boolean caseSensitive, boolean typoTolerant) {
        return new CamelHumpMatcher(prefix, caseSensitive, typoTolerant);
    }

    protected CompletionResultSet createResultSet(CompletionParameters parameters2, Consumer<? super CompletionResult> consumer, @NotNull CompletionContributor contributor, PrefixMatcher matcher) {
        return new BaseCompletionResultSet(consumer, matcher, contributor, parameters2, null, null);
    }

    @Nullable
    public CompletionProcess getCurrentCompletion() {
        return this.myApiCompletionProcess;
    }

    @NotNull
    protected CompletionSorterImpl addWeighersBefore(@NotNull CompletionSorterImpl sorter) {
        return sorter;
    }

    @NotNull
    protected CompletionSorterImpl processStatsWeigher(@NotNull CompletionSorterImpl sorter, @NotNull Weigher weigher2, @NotNull CompletionLocation location) {
        return sorter;
    }

    public CompletionSorter defaultSorter(CompletionParameters parameters2, PrefixMatcher matcher) {
        final CompletionLocation location = new CompletionLocation(parameters2);
        CompletionSorterImpl sorter = this.emptySorter();
        sorter = this.addWeighersBefore(sorter);
        sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new PreferStartMatching()));
        for (final Weigher weigher2 : WeighingService.getWeighers((Key)RELEVANCE_KEY)) {
            String id2 = weigher2.toString();
            if ("prefix".equals(id2)) {
                sorter = sorter.withClassifier(CompletionSorterImpl.weighingFactory(new RealPrefixMatchingWeigher()));
                continue;
            }
            if ("stats".equals(id2)) {
                sorter = this.processStatsWeigher(sorter, weigher2, location);
                continue;
            }
            sorter = sorter.weigh(new LookupElementWeigher(id2, true, false){

                @Nullable
                public Comparable weigh(@NotNull LookupElement element2) {
                    return weigher2.weigh((Object)element2, (Object)location);
                }
            });
        }
        return sorter.withClassifier("priority", true, new ClassifierFactory<LookupElement>("liftShorter"){

            @Override
            public Classifier<LookupElement> createClassifier(Classifier<LookupElement> next) {
                return new LiftShorterItemsClassifier("liftShorter", next, new LiftShorterItemsClassifier.LiftingCondition(), false);
            }
        });
    }

    public CompletionSorterImpl emptySorter() {
        return new CompletionSorterImpl(new ArrayList());
    }

    protected static class BaseCompletionResultSet
    extends CompletionResultSet {
        protected final CompletionParameters myParameters;
        protected CompletionSorter mySorter;
        @Nullable
        protected final BaseCompletionResultSet myOriginal;

        protected BaseCompletionResultSet(Consumer<? super CompletionResult> consumer, PrefixMatcher prefixMatcher, CompletionContributor contributor, CompletionParameters parameters2, @Nullable CompletionSorter sorter, @Nullable BaseCompletionResultSet original) {
            super(prefixMatcher, consumer, contributor);
            this.myParameters = parameters2;
            this.mySorter = sorter;
            this.myOriginal = original;
        }

        public void addElement(@NotNull LookupElement element2) {
            ProgressManager.checkCanceled();
            if (!element2.isValid()) {
                LOG.error("Invalid lookup element: " + element2 + " of " + element2.getClass() + " in " + this.myParameters.getOriginalFile() + " of " + this.myParameters.getOriginalFile().getClass());
                return;
            }
            this.mySorter = this.mySorter == null ? CompletionService.getCompletionService().defaultSorter(this.myParameters, this.getPrefixMatcher()) : this.mySorter;
            CompletionResult matched = CompletionResult.wrap((LookupElement)element2, (PrefixMatcher)this.getPrefixMatcher(), (CompletionSorter)this.mySorter);
            if (matched != null) {
                element2.putUserData(LOOKUP_ELEMENT_CONTRIBUTOR, (Object)this.myContributor);
                this.passResult(matched);
            }
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull PrefixMatcher matcher) {
            if (matcher.equals(this.getPrefixMatcher())) {
                return this;
            }
            return new BaseCompletionResultSet((Consumer<? super CompletionResult>)this.getConsumer(), matcher, this.myContributor, this.myParameters, this.mySorter, this);
        }

        @NotNull
        public CompletionResultSet withPrefixMatcher(@NotNull String prefix) {
            return this.withPrefixMatcher(this.getPrefixMatcher().cloneWithPrefix(prefix));
        }

        public void stopHere() {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Completion stopped\n" + DebugUtil.currentStackTrace());
            }
            super.stopHere();
            if (this.myOriginal != null) {
                this.myOriginal.stopHere();
            }
        }

        @NotNull
        public CompletionResultSet withRelevanceSorter(@NotNull CompletionSorter sorter) {
            return new BaseCompletionResultSet((Consumer<? super CompletionResult>)this.getConsumer(), this.getPrefixMatcher(), this.myContributor, this.myParameters, sorter, this);
        }

        public void addLookupAdvertisement(@NotNull @NlsContexts.PopupAdvertisement String text) {
            CompletionService.getCompletionService().setAdvertisementText(text);
        }

        @NotNull
        public CompletionResultSet caseInsensitive() {
            PrefixMatcher matcher = this.getPrefixMatcher();
            boolean typoTolerant = matcher instanceof CamelHumpMatcher && ((CamelHumpMatcher)matcher).isTypoTolerant();
            return this.withPrefixMatcher(BaseCompletionService.createMatcher(matcher.getPrefix(), false, typoTolerant));
        }

        public void restartCompletionOnPrefixChange(ElementPattern<String> prefixCondition) {
        }

        public void restartCompletionWhenNothingMatches() {
        }
    }
}

