/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionLookupArranger;
import com.intellij.codeInsight.completion.CompletionPreselectSkipper;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.LookupElementListPresenter;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.lookup.impl.EmptyLookupItem;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseCompletionLookupArranger
extends LookupArranger
implements CompletionLookupArranger {
    private static final Logger LOG = Logger.getInstance(BaseCompletionLookupArranger.class);
    private static final Key<LookupElementPresentation> DEFAULT_PRESENTATION = Key.create((String)"PRESENTATION_INVARIANT");
    private static final Comparator<LookupElementPresentation> PRESENTATION_COMPARATOR = Comparator.comparing(LookupElementPresentation::getItemText, NaturalComparator.INSTANCE).thenComparing(p -> StringUtil.notNullize((String)p.getTailText()).length()).thenComparing(LookupElementPresentation::getTailText, NaturalComparator.INSTANCE).thenComparing(LookupElementPresentation::getTypeText, NaturalComparator.INSTANCE);
    private static final Comparator<LookupElement> BY_PRESENTATION_COMPARATOR = Comparator.comparing(arg_0 -> DEFAULT_PRESENTATION.get(arg_0), PRESENTATION_COMPARATOR);
    static final int MAX_PREFERRED_COUNT = 5;
    public static final Key<Object> FORCE_MIDDLE_MATCH = Key.create((String)"FORCE_MIDDLE_MATCH");
    public static final String OVERFLOW_MESSAGE = "Not all variants are shown, please type more letters to see the rest";
    private final List<LookupElement> myFrozenItems = new ArrayList<LookupElement>();
    private final int myLimit = Registry.intValue((String)"ide.completion.variant.limit");
    private boolean myOverflow;
    @Nullable
    private volatile CompletionLocation myLocation;
    protected final CompletionProcessEx myProcess;
    private final Map<CompletionSorterImpl, Classifier<LookupElement>> myClassifiers = new java.util.LinkedHashMap<CompletionSorterImpl, Classifier<LookupElement>>();
    private final Key<CompletionSorterImpl> mySorterKey = Key.create((String)"SORTER_KEY");
    private final CompletionFinalSorter myFinalSorter = CompletionFinalSorter.newSorter();
    private int myPrefixChanges;
    private String myLastLookupPrefix;
    private final CompletionPreselectSkipper[] mySkippers = (CompletionPreselectSkipper[])CompletionPreselectSkipper.EP_NAME.getExtensions();
    private final Set<LookupElement> mySkippedItems = Collections.newSetFromMap(new IdentityHashMap());
    private boolean isInBatchUpdate = false;
    private final List<Pair<LookupElement, LookupElementPresentation>> batchItems = new ArrayList<Pair<LookupElement, LookupElementPresentation>>();

    public BaseCompletionLookupArranger(CompletionProcessEx process2) {
        this.myProcess = process2;
    }

    private MultiMap<CompletionSorterImpl, LookupElement> groupItemsBySorter(Iterable<? extends LookupElement> source) {
        MultiMap inputBySorter = MultiMap.createLinked();
        for (LookupElement lookupElement : source) {
            inputBySorter.putValue((Object)this.obtainSorter(lookupElement), (Object)lookupElement);
        }
        for (CompletionSorterImpl completionSorterImpl : inputBySorter.keySet()) {
            inputBySorter.put((Object)completionSorterImpl, this.sortByPresentation(inputBySorter.get((Object)completionSorterImpl)));
        }
        return inputBySorter;
    }

    @NotNull
    private CompletionSorterImpl obtainSorter(LookupElement element2) {
        return (CompletionSorterImpl)((Object)element2.getUserData(this.mySorterKey));
    }

    @Override
    @NotNull
    public synchronized Map<LookupElement, List<Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items, boolean hideSingleValued) {
        IdentityHashMap<LookupElement, ArrayList> map2 = new IdentityHashMap<LookupElement, ArrayList>();
        MultiMap<CompletionSorterImpl, LookupElement> inputBySorter = this.groupItemsBySorter(items);
        int sorterNumber = 0;
        for (CompletionSorterImpl sorter : inputBySorter.keySet()) {
            ++sorterNumber;
            Collection thisSorterItems = inputBySorter.get((Object)sorter);
            for (LookupElement element2 : thisSorterItems) {
                map2.put(element2, ContainerUtil.newArrayList((Object[])new Pair[]{new Pair((Object)"frozen", (Object)this.myFrozenItems.contains(element2)), new Pair((Object)"sorter", (Object)sorterNumber)}));
            }
            ProcessingContext processingContext = this.createContext();
            for (Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter); classifier != null; classifier = classifier.getNext()) {
                ReferenceOpenHashSet itemSet = new ReferenceOpenHashSet(thisSorterItems);
                List unsortedItems = ContainerUtil.filter((Collection)this.myItems, arg_0 -> BaseCompletionLookupArranger.lambda$getRelevanceObjects$1((Set)itemSet, arg_0));
                List<Pair<LookupElement, Object>> pairs = classifier.getSortingWeights(unsortedItems, processingContext);
                if (hideSingleValued && BaseCompletionLookupArranger.haveSameWeights(pairs)) continue;
                for (Pair<LookupElement, Object> pair : pairs) {
                    ((List)map2.get(pair.first)).add(Pair.create((Object)classifier.getPresentableName(), (Object)pair.second));
                }
            }
        }
        LinkedHashMap result2 = new LinkedHashMap(EqualityPolicy.IDENTITY);
        Map<LookupElement, List<Pair<String, Object>>> additional = this.myFinalSorter.getRelevanceObjects(items);
        for (LookupElement lookupElement : items) {
            List mainRelevance = (List)map2.get(lookupElement);
            List<Pair<String, Object>> additionalRelevance = additional.get(lookupElement);
            result2.put(lookupElement, additionalRelevance == null ? mainRelevance : ContainerUtil.concat((List)mainRelevance, additionalRelevance));
        }
        return result2;
    }

    void associateSorter(LookupElement element2, CompletionSorterImpl sorter) {
        element2.putUserData(this.mySorterKey, (Object)sorter);
    }

    public void clearClassifierCache() {
        this.myClassifiers.clear();
    }

    private static boolean haveSameWeights(List<? extends Pair<LookupElement, Object>> pairs) {
        if (pairs.isEmpty()) {
            return true;
        }
        for (int i2 = 1; i2 < pairs.size(); ++i2) {
            if (Comparing.equal((Object)pairs.get((int)i2).second, (Object)pairs.get((int)0).second)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addElement(@NotNull LookupElement element2, @NotNull CompletionSorter sorter, @NotNull PrefixMatcher prefixMatcher, @NotNull LookupElementPresentation presentation2) {
        this.registerMatcher(element2, prefixMatcher);
        this.associateSorter(element2, (CompletionSorterImpl)sorter);
        this.addElement(element2, presentation2);
    }

    @Override
    public void addElement(@NotNull CompletionResult result2) {
        LookupElementPresentation presentation2 = new LookupElementPresentation();
        result2.getLookupElement().renderElement(presentation2);
        this.addElement(result2.getLookupElement(), result2.getSorter(), result2.getPrefixMatcher(), presentation2);
    }

    @Override
    public synchronized void addElement(LookupElement element2, LookupElementPresentation presentation2) {
        element2.putUserData(DEFAULT_PRESENTATION, (Object)presentation2);
        CompletionSorterImpl sorter = this.obtainSorter(element2);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        if (classifier == null) {
            classifier = sorter.buildClassifier(new EmptyClassifier());
            this.myClassifiers.put(sorter, classifier);
        }
        ProcessingContext context = this.createContext();
        classifier.addElement(element2, context);
        if (this.shouldSkip(element2)) {
            this.mySkippedItems.add(element2);
        }
        if (this.isInBatchUpdate) {
            this.batchItems.add((Pair<LookupElement, LookupElementPresentation>)new Pair((Object)element2, (Object)presentation2));
        } else {
            super.addElement(element2, presentation2);
            this.trimToLimit(context);
        }
    }

    @ApiStatus.Internal
    public void batchUpdate(Runnable runnable2) {
        if (this.isInBatchUpdate) {
            runnable2.run();
        } else {
            this.isInBatchUpdate = true;
            try {
                runnable2.run();
            }
            finally {
                this.isInBatchUpdate = false;
            }
            if (!this.batchItems.isEmpty()) {
                this.flushBatch();
            }
        }
    }

    private synchronized void flushBatch() {
        for (Pair<LookupElement, LookupElementPresentation> pair : this.batchItems) {
            super.addElement((LookupElement)pair.first, (LookupElementPresentation)pair.second);
        }
        this.batchItems.clear();
        this.trimToLimit(this.createContext());
    }

    @Override
    @NotNull
    public synchronized String itemPattern(@NotNull LookupElement element2) {
        return super.itemPattern(element2);
    }

    @Override
    public synchronized void prefixReplaced(@NotNull Lookup lookup2, @NotNull String newPrefix) {
        super.prefixReplaced(lookup2, newPrefix);
    }

    @Override
    public void itemSelected(@Nullable LookupElement lookupItem, char completionChar) {
        this.myProcess.itemSelected(lookupItem, completionChar);
    }

    private void trimToLimit(ProcessingContext context) {
        if (this.myItems.size() < this.myLimit) {
            return;
        }
        List<LookupElement> items = this.getMatchingItems();
        Iterator<LookupElement> iterator2 = this.sortByRelevance(this.groupItemsBySorter(items)).iterator();
        THashSet retainedSet = ContainerUtil.newIdentityTroveSet();
        retainedSet.addAll(this.getPrefixItems(true));
        retainedSet.addAll(this.getPrefixItems(false));
        retainedSet.addAll(this.myFrozenItems);
        while (retainedSet.size() < this.myLimit / 2 && iterator2.hasNext()) {
            retainedSet.add(iterator2.next());
        }
        if (!iterator2.hasNext()) {
            return;
        }
        List<LookupElement> removed = this.retainItems((Set<LookupElement>)retainedSet);
        for (LookupElement element2 : removed) {
            this.removeItem(element2, context);
        }
        if (!this.myOverflow) {
            this.myOverflow = true;
            this.myProcess.addAdvertisement(OVERFLOW_MESSAGE, null);
            this.myProcess.addWatchedPrefix(0, (ElementPattern<String>)StandardPatterns.string());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.printTestWarning();
            }
        }
    }

    private void printTestWarning() {
        System.err.println("Your test might miss some lookup items, because only " + this.myLimit / 2 + " most relevant items are guaranteed to be shown in the lookup. You can:");
        System.err.println("1. Make the prefix used for completion longer, so that there are less suggestions.");
        System.err.println("2. Increase 'ide.completion.variant.limit' (using RegistryValue#setValue with a test root disposable).");
        System.err.println("3. Ignore this warning.");
    }

    protected void removeItem(LookupElement element2, ProcessingContext context) {
        CompletionSorterImpl sorter = this.obtainSorter(element2);
        Classifier<LookupElement> classifier = this.myClassifiers.get((Object)sorter);
        if (classifier != null) {
            classifier.removeElement(element2, context);
        }
    }

    private List<LookupElement> sortByPresentation(Iterable<? extends LookupElement> source) {
        ArrayList<LookupElement> startMatches = new ArrayList<LookupElement>();
        ArrayList middleMatches = new ArrayList();
        for (LookupElement lookupElement : source) {
            (this.itemMatcher(lookupElement).isStartMatch(lookupElement) ? startMatches : middleMatches).add(lookupElement);
        }
        ContainerUtil.sort(startMatches, BY_PRESENTATION_COMPARATOR);
        ContainerUtil.sort(middleMatches, BY_PRESENTATION_COMPARATOR);
        startMatches.addAll(middleMatches);
        return startMatches;
    }

    protected boolean isAlphaSorted() {
        return false;
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems() {
        LookupElementListPresenter dummyListPresenter = new LookupElementListPresenter(){

            public String getAdditionalPrefix() {
                return "";
            }

            public LookupElement getCurrentItem() {
                return null;
            }

            public LookupElement getCurrentItemOrEmpty() {
                return null;
            }

            public boolean isSelectionTouched() {
                return false;
            }

            public int getSelectedIndex() {
                return 0;
            }

            public int getLastVisibleIndex() {
                return 0;
            }

            @NotNull
            public LookupFocusDegree getLookupFocusDegree() {
                return LookupFocusDegree.FOCUSED;
            }

            public boolean isShown() {
                return true;
            }
        };
        return this.doArrangeItems(dummyListPresenter, false);
    }

    @Override
    public Pair<List<LookupElement>, Integer> arrangeItems(@NotNull Lookup lookup2, boolean onExplicitAction) {
        return this.doArrangeItems((LookupElementListPresenter)lookup2, onExplicitAction);
    }

    @NotNull
    private synchronized Pair<List<LookupElement>, Integer> doArrangeItems(@NotNull LookupElementListPresenter lookup2, boolean onExplicitAction) {
        List<LookupElement> items = this.getMatchingItems();
        Iterable<LookupElement> sortedByRelevance = this.sortByRelevance(this.groupItemsBySorter(items));
        sortedByRelevance = this.applyFinalSorter(sortedByRelevance);
        LookupElement relevantSelection = this.findMostRelevantItem(sortedByRelevance);
        List<LookupElement> listModel = this.isAlphaSorted() ? this.sortByPresentation(items) : this.fillModelByRelevance(lookup2, (Set<? extends LookupElement>)new ReferenceOpenHashSet(items), sortedByRelevance, relevantSelection);
        int toSelect2 = this.getItemToSelect(lookup2, listModel, onExplicitAction, relevantSelection);
        LOG.assertTrue(toSelect2 >= 0);
        return new Pair(listModel, (Object)toSelect2);
    }

    @NotNull
    protected Iterable<? extends LookupElement> applyFinalSorter(Iterable<? extends LookupElement> sortedByRelevance) {
        if (sortedByRelevance.iterator().hasNext()) {
            return this.myFinalSorter.sort(sortedByRelevance, Objects.requireNonNull(this.myProcess.getParameters()));
        }
        return sortedByRelevance;
    }

    private List<LookupElement> fillModelByRelevance(LookupElementListPresenter lookup2, Set<? extends LookupElement> items, Iterable<? extends LookupElement> sortedElements, @Nullable LookupElement relevantSelection) {
        Iterator<? extends LookupElement> byRelevance = sortedElements.iterator();
        LinkedHashSet model = new LinkedHashSet();
        this.addPrefixItems(model);
        this.addFrozenItems(items, model);
        if (model.size() < 5) {
            BaseCompletionLookupArranger.addSomeItems(model, byRelevance, (Condition<? super LookupElement>)((Condition)lastAdded -> model.size() >= 5));
        }
        BaseCompletionLookupArranger.addCurrentlySelectedItemToTop(lookup2, items, model);
        this.freezeTopItems(lookup2, model);
        BaseCompletionLookupArranger.ensureItemAdded(items, model, byRelevance, lookup2.getCurrentItem());
        BaseCompletionLookupArranger.ensureItemAdded(items, model, byRelevance, relevantSelection);
        ContainerUtil.addAll(model, byRelevance);
        return new ArrayList<LookupElement>(model);
    }

    private static void ensureItemAdded(Set<? extends LookupElement> items, LinkedHashSet<? super LookupElement> model, Iterator<? extends LookupElement> byRelevance, @Nullable LookupElement item) {
        if (item != null && items.contains(item) && !model.contains(item)) {
            BaseCompletionLookupArranger.addSomeItems(model, byRelevance, (Condition<? super LookupElement>)((Condition)lastAdded -> lastAdded == item));
        }
    }

    private void freezeTopItems(LookupElementListPresenter lookup2, LinkedHashSet<? extends LookupElement> model) {
        this.myFrozenItems.clear();
        if (lookup2.isShown()) {
            this.myFrozenItems.addAll(model);
        }
    }

    private void addFrozenItems(Set<? extends LookupElement> items, LinkedHashSet<? super LookupElement> model) {
        Iterator<LookupElement> iterator2 = this.myFrozenItems.iterator();
        while (iterator2.hasNext()) {
            LookupElement element2 = iterator2.next();
            if (element2.isValid() && items.contains(element2)) continue;
            iterator2.remove();
        }
        model.addAll(this.myFrozenItems);
    }

    private void addPrefixItems(LinkedHashSet<? super LookupElement> model) {
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(true))));
        ContainerUtil.addAll(model, this.sortByRelevance(this.groupItemsBySorter(this.getPrefixItems(false))));
    }

    private static void addCurrentlySelectedItemToTop(LookupElementListPresenter lookup2, Set<? extends LookupElement> items, LinkedHashSet<? super LookupElement> model) {
        LookupElement lastSelection;
        if (!lookup2.isSelectionTouched() && items.contains(lastSelection = lookup2.getCurrentItem())) {
            model.add((LookupElement)lastSelection);
        }
    }

    private static void addSomeItems(LinkedHashSet<? super LookupElement> model, Iterator<? extends LookupElement> iterator2, Condition<? super LookupElement> stopWhen) {
        while (iterator2.hasNext()) {
            LookupElement item = iterator2.next();
            model.add((LookupElement)item);
            if (!stopWhen.value((Object)item)) continue;
            break;
        }
    }

    private Iterable<LookupElement> sortByRelevance(MultiMap<CompletionSorterImpl, LookupElement> inputBySorter) {
        if (inputBySorter.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Iterable<LookupElement>> byClassifier = new ArrayList<Iterable<LookupElement>>();
        for (CompletionSorterImpl sorter : this.myClassifiers.keySet()) {
            ProcessingContext context = this.createContext();
            byClassifier.add(this.myClassifiers.get((Object)sorter).classify(inputBySorter.get((Object)sorter), context));
        }
        return ContainerUtil.concat((Iterable[])byClassifier.toArray(new Iterable[0]));
    }

    private ProcessingContext createContext() {
        ProcessingContext context = new ProcessingContext();
        context.put(PREFIX_CHANGES, (Object)this.myPrefixChanges);
        context.put(WEIGHING_CONTEXT, (Object)this);
        return context;
    }

    void setLastLookupPrefix(String lookupPrefix) {
        this.myLastLookupPrefix = lookupPrefix;
    }

    public String getLastLookupPrefix() {
        return this.myLastLookupPrefix;
    }

    @Override
    public LookupArranger createEmptyCopy() {
        return new BaseCompletionLookupArranger(this.myProcess);
    }

    private int getItemToSelect(LookupElementListPresenter lookup2, List<? extends LookupElement> items, boolean onExplicitAction, @Nullable LookupElement mostRelevant) {
        LookupElement exactMatch;
        if (items.isEmpty() || lookup2.getLookupFocusDegree() == LookupFocusDegree.UNFOCUSED) {
            return 0;
        }
        if (lookup2.isSelectionTouched() || !onExplicitAction) {
            int index;
            LookupElement lastSelection = lookup2.getCurrentItem();
            int old = ContainerUtil.indexOfIdentity(items, (Object)lastSelection);
            if (old >= 0) {
                return old;
            }
            LookupElement selectedValue = lookup2.getCurrentItemOrEmpty();
            if (selectedValue instanceof EmptyLookupItem && ((EmptyLookupItem)selectedValue).isLoading() && (index = lookup2.getSelectedIndex()) >= 0 && index < items.size()) {
                return index;
            }
            for (int i2 = 0; i2 < items.size(); ++i2) {
                LookupElementPresentation p1 = (LookupElementPresentation)DEFAULT_PRESENTATION.get((UserDataHolder)items.get(i2));
                LookupElementPresentation p2 = (LookupElementPresentation)DEFAULT_PRESENTATION.get((UserDataHolder)lastSelection);
                if (p1 == null || p2 == null || PRESENTATION_COMPARATOR.compare(p1, p2) != 0) continue;
                return i2;
            }
        }
        return Math.max(0, ContainerUtil.indexOfIdentity(items, (Object)((exactMatch = this.getBestExactMatch(items)) != null ? exactMatch : mostRelevant)));
    }

    protected List<LookupElement> getExactMatches(List<? extends LookupElement> items) {
        Editor editor = this.myProcess.getParameters().getEditor();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        SmartList exactMatches = new SmartList();
        for (LookupElement lookupElement : items) {
            if (!this.isPrefixItem(lookupElement, true) && !lookupElement.getLookupString().equals(selectedText)) continue;
            exactMatches.add(lookupElement);
        }
        return exactMatches;
    }

    @Nullable
    private LookupElement getBestExactMatch(List<? extends LookupElement> items) {
        List<LookupElement> exactMatches = this.getExactMatches(items);
        if (exactMatches.isEmpty()) {
            return null;
        }
        if (exactMatches.size() == 1) {
            return exactMatches.get(0);
        }
        return this.sortByRelevance(this.groupItemsBySorter(exactMatches)).iterator().next();
    }

    @Nullable
    private LookupElement findMostRelevantItem(Iterable<? extends LookupElement> sorted) {
        for (LookupElement lookupElement : sorted) {
            if (this.mySkippedItems.contains(lookupElement)) continue;
            return lookupElement;
        }
        return null;
    }

    private boolean shouldSkip(LookupElement element2) {
        CompletionLocation location = this.myLocation;
        if (location == null) {
            this.myLocation = location = new CompletionLocation(Objects.requireNonNull(this.myProcess.getParameters()));
        }
        for (CompletionPreselectSkipper skipper : this.mySkippers) {
            if (!skipper.skipElement(element2, location)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Skipped element " + element2 + " by " + skipper);
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void prefixChanged(Lookup lookup2) {
        ++this.myPrefixChanges;
        this.myFrozenItems.clear();
        super.prefixChanged(lookup2);
    }

    @Override
    public void prefixTruncated(@NotNull LookupEx lookup2, int hideOffset) {
        if (hideOffset < lookup2.getEditor().getCaretModel().getOffset()) {
            this.myProcess.scheduleRestart();
            return;
        }
        this.myProcess.prefixUpdated();
        lookup2.hideLookup(false);
    }

    @Override
    public boolean isCompletion() {
        return true;
    }

    private static /* synthetic */ boolean lambda$getRelevanceObjects$1(Set itemSet, LookupElement lookupElement) {
        return itemSet.contains(lookupElement);
    }

    private static class EmptyClassifier
    extends Classifier<LookupElement> {
        private EmptyClassifier() {
            super(null, "empty");
        }

        @Override
        @NotNull
        public List<Pair<LookupElement, Object>> getSortingWeights(@NotNull Iterable<? extends LookupElement> items, @NotNull ProcessingContext context) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Iterable<LookupElement> classify(@NotNull Iterable<? extends LookupElement> source, @NotNull ProcessingContext context) {
            return source;
        }
    }
}

