/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.DeclarativeInsertHandler;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class AddSpaceInsertHandler
implements InsertHandler<LookupElement> {
    public static final InsertHandler<LookupElement> INSTANCE = new DeclarativeInsertHandler.Builder().disableOnCompletionChars(" ").insertOrMove(" ").build();
    public static final InsertHandler<LookupElement> INSTANCE_WITH_AUTO_POPUP = new DeclarativeInsertHandler.Builder().disableOnCompletionChars(" ").insertOrMove(" ").triggerAutoPopup().build();
    private final String myIgnoreOnChars;
    private final boolean myTriggerAutoPopup;

    public AddSpaceInsertHandler(boolean triggerAutoPopup) {
        this("", triggerAutoPopup);
    }

    public AddSpaceInsertHandler(String ignoreOnChars, boolean triggerAutoPopup) {
        this.myIgnoreOnChars = ignoreOnChars;
        this.myTriggerAutoPopup = triggerAutoPopup;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        if (completionChar == ' ' || StringUtil.containsChar((String)this.myIgnoreOnChars, (char)completionChar)) {
            return;
        }
        Project project = editor.getProject();
        if (project != null) {
            if (!AddSpaceInsertHandler.isCharAtSpace(editor)) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            } else if (this.shouldOverwriteExistingSpace(editor)) {
                editor.getCaretModel().moveToOffset(editor.getCaretModel().getOffset() + 1);
            }
            if (this.myTriggerAutoPopup) {
                AutoPopupController.getInstance(project).autoPopupMemberLookup(editor, null);
            }
        }
    }

    protected boolean shouldOverwriteExistingSpace(Editor editor) {
        return true;
    }

    private static boolean isCharAtSpace(Editor editor) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        return document.getTextLength() > startOffset && document.getCharsSequence().charAt(startOffset) == ' ';
    }
}

