/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

final class ActionTracker {
    @NotNull
    private final MessageBusConnection myConnection;
    @NotNull
    private List<Integer> myCaretOffsets;
    private long myStartDocStamp;
    private boolean myActionsHappened;
    private final Editor myEditor;
    private final Project myProject;
    private final boolean myIsDumb;

    ActionTracker(@NotNull Editor editor, @NotNull Disposable parentDisposable) {
        this.myEditor = editor;
        this.myProject = Objects.requireNonNull(editor.getProject());
        this.myIsDumb = DumbService.getInstance((Project)this.myProject).isDumb();
        this.myConnection = this.myProject.getMessageBus().connect(parentDisposable);
        this.myConnection.subscribe(AnActionListener.TOPIC, (Object)new AnActionListener(){

            public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
                ActionTracker.this.myActionsHappened = true;
            }
        });
        this.myStartDocStamp = this.docStamp();
        this.myCaretOffsets = this.caretOffsets();
    }

    private List<Integer> caretOffsets() {
        return ContainerUtil.map((Collection)this.myEditor.getCaretModel().getAllCarets(), Caret::getOffset);
    }

    private long docStamp() {
        return this.myEditor.getDocument().getModificationStamp();
    }

    void ignoreCurrentDocumentChange() {
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            return;
        }
        this.myConnection.subscribe(CommandListener.TOPIC, (Object)new CommandListener(){
            boolean insideCommand = true;

            public void commandFinished(@NotNull CommandEvent event) {
                if (this.insideCommand) {
                    this.insideCommand = false;
                    ActionTracker.this.myStartDocStamp = ActionTracker.this.docStamp();
                    ActionTracker.this.myCaretOffsets = ActionTracker.this.caretOffsets();
                }
            }
        });
    }

    boolean hasAnythingHappened() {
        return this.myActionsHappened || this.myIsDumb != DumbService.getInstance((Project)this.myProject).isDumb() || this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid() || this.myStartDocStamp != this.docStamp() || !this.myCaretOffsets.equals(this.caretOffsets());
    }
}

